/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.container;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jdk.Jvm;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton
public class OperatingSystem {
    private int cachedActiveProcessorCount;
    private UnsignedWord cachedPhysicalMemorySize;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    OperatingSystem() {
    }

    @Fold
    public static OperatingSystem singleton() {
        return (OperatingSystem)ImageSingletons.lookup(OperatingSystem.class);
    }

    public int getActiveProcessorCount() {
        int value;
        this.cachedActiveProcessorCount = value = Jvm.JVM_ActiveProcessorCount();
        return value;
    }

    public int getCachedActiveProcessorCount() {
        return this.cachedActiveProcessorCount;
    }

    public UnsignedWord getPhysicalMemorySize() {
        UnsignedWord value;
        this.cachedPhysicalMemorySize = value = ((PhysicalMemory.PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemory.PhysicalMemorySupport.class)).size();
        return value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getCachedPhysicalMemorySize() {
        return this.cachedPhysicalMemorySize;
    }
}

