/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.container;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.container.ContainerLibrary;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@AutomaticallyRegisteredImageSingleton
public class Container {
    private static final CGlobalData<Pointer> STATE = CGlobalDataFactory.createWord();
    private static final int CACHE_MS = 20;
    private long activeProcessorCountTimeoutMs;
    private int cachedActiveProcessorCount;
    private long physicalMemoryTimeoutMs;
    private UnsignedWord cachedPhysicalMemorySize;
    private long memoryLimitInBytesTimeoutMs;
    private long cachedMemoryLimitInBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Container() {
    }

    @Fold
    public static boolean isSupported() {
        return SubstrateOptions.UseContainerSupport.getValue() != false && Platform.includedIn(Platform.LINUX.class);
    }

    @Fold
    public static Container singleton() {
        return (Container)ImageSingletons.lookup(Container.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isContainerized() {
        if (!Container.isSupported()) {
            return false;
        }
        UnsignedWord value = (UnsignedWord)STATE.get().readWord(0);
        assert (value == State.CONTAINERIZED || value == State.NOT_CONTAINERIZED);
        return value == State.CONTAINERIZED;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize() {
        if (!Container.isSupported()) {
            return;
        }
        Pointer statePtr = STATE.get();
        UnsignedWord value = (UnsignedWord)statePtr.compareAndSwapWord(0, (WordBase)State.UNINITIALIZED, (WordBase)State.INITIALIZING, LocationIdentity.ANY_LOCATION);
        if (value == State.UNINITIALIZED) {
            value = switch (ContainerLibrary.initialize(240100)) {
                case 0 -> State.NOT_CONTAINERIZED;
                case 1 -> State.CONTAINERIZED;
                case 2 -> State.ERROR_LIBCONTAINER_TOO_OLD;
                case 3 -> State.ERROR_LIBCONTAINER_TOO_NEW;
                default -> State.ERROR_UNKNOWN;
            };
            statePtr.writeWordVolatile(0, (WordBase)value);
        } else {
            while (value == State.INITIALIZING) {
                PauseNode.pause();
                value = (UnsignedWord)statePtr.readWordVolatile(0, LocationIdentity.ANY_LOCATION);
            }
        }
        VMError.guarantee(value != State.ERROR_LIBCONTAINER_TOO_OLD, "native-image tries to use a libsvm_container version that is too old");
        VMError.guarantee(value != State.ERROR_LIBCONTAINER_TOO_NEW, "native-image tries to use a libsvm_container version that is too new");
        VMError.guarantee(value == State.CONTAINERIZED || value == State.NOT_CONTAINERIZED, "unexpected libsvm_container initialize result");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getActiveProcessorCount() {
        VMError.guarantee(this.isContainerized());
        long currentMs = TimeUtils.currentTimeMillis();
        if (currentMs > this.activeProcessorCountTimeoutMs) {
            this.cachedActiveProcessorCount = ContainerLibrary.getActiveProcessorCount();
            this.activeProcessorCountTimeoutMs = currentMs + 20L;
        }
        return this.cachedActiveProcessorCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getCachedActiveProcessorCount() {
        VMError.guarantee(this.isContainerized());
        return this.cachedActiveProcessorCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getPhysicalMemory() {
        VMError.guarantee(this.isContainerized());
        long currentMs = TimeUtils.currentTimeMillis();
        if (currentMs > this.physicalMemoryTimeoutMs) {
            this.cachedPhysicalMemorySize = ContainerLibrary.physicalMemory();
            this.physicalMemoryTimeoutMs = currentMs + 20L;
        }
        return this.cachedPhysicalMemorySize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getCachedPhysicalMemory() {
        VMError.guarantee(this.isContainerized());
        return this.cachedPhysicalMemorySize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getMemoryLimitInBytes() {
        VMError.guarantee(this.isContainerized());
        long currentMs = TimeUtils.currentTimeMillis();
        if (currentMs > this.memoryLimitInBytesTimeoutMs) {
            this.cachedMemoryLimitInBytes = ContainerLibrary.getMemoryLimitInBytes();
            this.memoryLimitInBytesTimeoutMs = currentMs + 20L;
        }
        return this.cachedMemoryLimitInBytes;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCachedMemoryLimitInBytes() {
        VMError.guarantee(this.isContainerized());
        return this.cachedMemoryLimitInBytes;
    }

    private static final class State {
        static final UnsignedWord UNINITIALIZED = Word.unsigned((int)0);
        static final UnsignedWord INITIALIZING = Word.unsigned((int)1);
        static final UnsignedWord NOT_CONTAINERIZED = Word.unsigned((int)2);
        static final UnsignedWord CONTAINERIZED = Word.unsigned((int)3);
        static final UnsignedWord ERROR_LIBCONTAINER_TOO_OLD = Word.unsigned((int)4);
        static final UnsignedWord ERROR_LIBCONTAINER_TOO_NEW = Word.unsigned((int)5);
        static final UnsignedWord ERROR_UNKNOWN = Word.unsigned((int)6);

        private State() {
        }
    }
}

