/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.core.FutureDefaultsOptions;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionMigrationMessage;
import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ConfigurationFiles {
    public static List<Path> findConfigurationFiles(String fileName) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path configDir : Options.ConfigurationFileDirectories.getValue().values()) {
            if (Files.exists(configDir.resolve(".lock"), new LinkOption[0])) {
                throw ConfigurationFiles.foundLockFile("Configuration file directory '" + String.valueOf(configDir) + "'");
            }
            Path path = configDir.resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            files.add(path);
        }
        return files;
    }

    public static List<URL> findConfigurationResources(String fileName, ClassLoader classLoader) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (String root : Options.ConfigurationResourceRoots.getValue().values()) {
            String separator = "/";
            String relativeRoot = Stream.of(root.split("/")).filter(part -> !part.isEmpty() && !part.equals(".")).collect(Collectors.joining("/"));
            try {
                Object lockPath = relativeRoot.isEmpty() ? ".lock" : relativeRoot + "/.lock";
                Enumeration<URL> resource = classLoader.getResources((String)lockPath);
                if (resource != null && resource.hasMoreElements()) {
                    throw ConfigurationFiles.foundLockFile("Configuration resource root '" + root + "'");
                }
            }
            catch (IOException lockPath) {
                // empty catch block
            }
            String relativePath = relativeRoot.isEmpty() ? fileName : relativeRoot + "/" + fileName;
            try {
                Enumeration<URL> e = classLoader.getResources(relativePath);
                while (e.hasMoreElements()) {
                    resources.add(e.nextElement());
                }
            }
            catch (IOException e) {
                throw UserError.abort(e, "Error while looking for %s in %s", fileName, root);
            }
        }
        return resources;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static UserError.UserException foundLockFile(String container) {
        throw UserError.abort("%s contains file '%s', which means an agent is currently writing to it.The agent must finish execution before its generated configuration can be used to build a native image.Unless the lock file is a leftover from an earlier process that terminated abruptly, it is unsafe to delete it.", container, ".lock");
    }

    public static final class Options {
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> ConfigurationFileDirectories = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ConfigurationResourceRoots = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a reflect-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> ReflectionConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ReflectionConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a proxy-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> DynamicProxyConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> DynamicProxyConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a serialization-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> SerializationConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> SerializationConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a serialization-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> SerializationDenyConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> SerializationDenyConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a resource-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> ResourceConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ResourceConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a jni-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> JNIConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> JNIConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ReachabilityMetadataResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        @OptionMigrationMessage(value="Use a predefined-classes-config.json in your META-INF/native-image/<groupID>/<artifactID> directory instead.")
        @BundleMember(role=BundleMember.Role.Input)
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> PredefinedClassesConfigurationFiles = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> PredefinedClassesConfigurationResources = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<Boolean> StrictConfiguration = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TreatAllTypeReachableConditionsAsTypeReached = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TreatAllNameEntriesAsType = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TrackUnsatisfiedTypeReachedConditions = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TrackTypeReachedOnInterfaces = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TreatAllUserSpaceTypesAsTrackedForTypeReached = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> WarnAboutMissingReflectionOrJNIMetadataElements = new HostedOptionKey<Boolean>(false);

        public static EnumSet<ConfigurationParserOption> getConfigurationParserOptions() {
            EnumSet<ConfigurationParserOption> result = EnumSet.noneOf(ConfigurationParserOption.class);
            if (StrictConfiguration.getValue().booleanValue()) {
                result.add(ConfigurationParserOption.STRICT_CONFIGURATION);
            }
            if (WarnAboutMissingReflectionOrJNIMetadataElements.getValue().booleanValue()) {
                result.add(ConfigurationParserOption.PRINT_MISSING_ELEMENTS);
            }
            if (TreatAllTypeReachableConditionsAsTypeReached.getValue().booleanValue()) {
                result.add(ConfigurationParserOption.TREAT_ALL_TYPE_REACHABLE_CONDITIONS_AS_TYPE_REACHED);
            }
            if (TreatAllNameEntriesAsType.getValue().booleanValue() || FutureDefaultsOptions.completeReflectionTypes()) {
                result.add(ConfigurationParserOption.TREAT_ALL_NAME_ENTRIES_AS_TYPE);
            }
            return result;
        }

        public static EnumSet<ConfigurationParserOption> getConfigurationParserOptions(EnumSet<ConfigurationParserOption> includes, EnumSet<ConfigurationParserOption> excludes) {
            assert (includes == null || excludes == null || Collections.disjoint(includes, excludes));
            EnumSet<ConfigurationParserOption> result = Options.getConfigurationParserOptions();
            if (includes != null) {
                result.addAll(includes);
            }
            if (excludes != null) {
                result.removeAll(excludes);
            }
            return result;
        }
    }
}

