/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class VMInspectionOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(VMInspectionOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "DumpRuntimeCompilationOnSignal": {
                return OptionDescriptor.create((String)"DumpRuntimeCompilationOnSignal", (OptionType)OptionType.User, Boolean.class, (String)"Dumps all runtime compiled methods on SIGUSR2.", (Object)this.getContainer(), VMInspectionOptions.DumpRuntimeCompilationOnSignal, (String)"DumpRuntimeCompilationOnSignal", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EnableMonitoringFeatures": {
                return OptionDescriptor.create((String)"EnableMonitoringFeatures", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Enable monitoring features that allow the VM to be inspected at run time. Comma-separated list can contain 'heapdump', 'jfr', 'jvmstat', 'jmxserver' (experimental), 'jmxclient' (experimental), 'threaddump', 'nmt' (experimental), 'jcmd' (experimental), or 'all' (deprecated behavior: defaults to 'all' if no argument is provided). For example: '--enable-monitoring=heapdump,jfr'.", (Object)this.getContainer(), VMInspectionOptions.EnableMonitoringFeatures, (String)"EnableMonitoringFeatures", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintNMTStatistics": {
                return OptionDescriptor.create((String)"PrintNMTStatistics", (OptionType)OptionType.User, Boolean.class, (String)"Print native memory tracking statistics on shutdown if native memory tracking is enabled.", (Object)this.getContainer(), VMInspectionOptions.PrintNMTStatistics, (String)"PrintNMTStatistics", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 3;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return VMInspectionOptions_OptionDescriptors.this.get("DumpRuntimeCompilationOnSignal");
                    }
                    case 1: {
                        return VMInspectionOptions_OptionDescriptors.this.get("EnableMonitoringFeatures");
                    }
                    case 2: {
                        return VMInspectionOptions_OptionDescriptors.this.get("PrintNMTStatistics");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

