/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class UnmanagedMemoryUtil {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copy(Pointer from, Pointer to, UnsignedWord size) {
        if (from.aboveThan((UnsignedWord)to)) {
            UnmanagedMemoryUtil.copyForward(from, to, size);
        } else if (from.belowThan((UnsignedWord)to)) {
            UnmanagedMemoryUtil.copyBackward(from, to, size);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyForward(Pointer from, Pointer to, UnsignedWord size) {
        UnsignedWord alignBits = Word.unsigned((int)7);
        UnsignedWord alignedSize = size.and(alignBits.not());
        UnmanagedMemoryUtil.copyLongsForward(from, to, alignedSize);
        if (alignedSize.notEqual(size)) {
            UnsignedWord offset = alignedSize;
            if (size.and(4).notEqual(0)) {
                to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
                offset = offset.add(4);
            }
            if (size.and(2).notEqual(0)) {
                to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
                offset = offset.add(2);
            }
            if (size.and(1).notEqual(0)) {
                to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
                offset = offset.add(1);
            }
            assert (offset.equal(size));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyBackward(Pointer from, Pointer to, UnsignedWord size) {
        UnsignedWord alignBits = Word.unsigned((int)7);
        UnsignedWord alignedSize = size.and(alignBits.not());
        UnsignedWord unalignedSize = size.subtract(alignedSize);
        UnmanagedMemoryUtil.copyLongsBackward(from.add(unalignedSize), to.add(unalignedSize), alignedSize);
        if (unalignedSize.aboveThan(0)) {
            UnsignedWord offset = unalignedSize;
            if (size.and(4).notEqual(0)) {
                offset = offset.subtract(4);
                to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
            }
            if (size.and(2).notEqual(0)) {
                offset = offset.subtract(2);
                to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
            }
            if (size.and(1).notEqual(0)) {
                offset = offset.subtract(1);
                to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
            }
            assert (offset.equal(0));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyLongsForward(Pointer from, Pointer to, UnsignedWord size) {
        assert (size.unsignedRemainder(8).equal(0));
        UnsignedWord offset = (UnsignedWord)Word.zero();
        UnsignedWord next = offset.add(32);
        while (next.belowOrEqual(size)) {
            Pointer src = from.add(offset);
            Pointer dst = to.add(offset);
            long l0 = src.readLong(0);
            long l8 = src.readLong(8);
            long l16 = src.readLong(16);
            long l24 = src.readLong(24);
            dst.writeLong(0, l0);
            dst.writeLong(8, l8);
            dst.writeLong(16, l16);
            dst.writeLong(24, l24);
            offset = next;
            next = offset.add(32);
        }
        while (offset.belowThan(size)) {
            to.writeLong((WordBase)offset, from.readLong((WordBase)offset));
            offset = offset.add(8);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyWordsForward(Pointer from, Pointer to, UnsignedWord size) {
        int wordSize = ConfigurationValues.getTarget().wordSize;
        int stepSize = 4 * wordSize;
        Pointer src = from;
        Pointer dst = to;
        Pointer srcEnd = src.add(size);
        while (src.add(stepSize).belowOrEqual((UnsignedWord)srcEnd)) {
            WordBase w0 = src.readWord(0 * wordSize);
            WordBase w8 = src.readWord(1 * wordSize);
            WordBase w16 = src.readWord(2 * wordSize);
            WordBase w24 = src.readWord(3 * wordSize);
            dst.writeWord(0 * wordSize, w0);
            dst.writeWord(1 * wordSize, w8);
            dst.writeWord(2 * wordSize, w16);
            dst.writeWord(3 * wordSize, w24);
            src = src.add(stepSize);
            dst = dst.add(stepSize);
        }
        while (src.belowThan((UnsignedWord)srcEnd)) {
            dst.writeWord(Word.zero(), src.readWord(Word.zero()));
            src = src.add(wordSize);
            dst = dst.add(wordSize);
        }
        assert (src.equal((UnsignedWord)srcEnd));
        assert (dst.equal((UnsignedWord)to.add(size)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void copyLongsBackward(Pointer from, Pointer to, UnsignedWord size) {
        assert (size.unsignedRemainder(8).equal(0));
        UnsignedWord offset = size;
        while (offset.aboveOrEqual(32)) {
            offset = offset.subtract(32);
            Pointer src = from.add(offset);
            Pointer dst = to.add(offset);
            long l24 = src.readLong(24);
            long l16 = src.readLong(16);
            long l8 = src.readLong(8);
            long l0 = src.readLong(0);
            dst.writeLong(24, l24);
            dst.writeLong(16, l16);
            dst.writeLong(8, l8);
            dst.writeLong(0, l0);
        }
        while (offset.aboveOrEqual(8)) {
            offset = offset.subtract(8);
            to.writeLong((WordBase)offset, from.readLong((WordBase)offset));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord compareLongs(Pointer x, Pointer y, UnsignedWord size) {
        assert (size.unsignedRemainder(8).equal(0));
        UnsignedWord offset = (UnsignedWord)Word.zero();
        while (offset.belowThan(size)) {
            if (x.readLong((WordBase)offset) != y.readLong((WordBase)offset)) {
                return offset;
            }
            offset = offset.add(8);
        }
        return offset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord compareBytes(Pointer x, Pointer y, UnsignedWord size) {
        UnsignedWord offset = (UnsignedWord)Word.zero();
        while (offset.belowThan(size)) {
            if (x.readByte((WordBase)offset) != y.readByte((WordBase)offset)) {
                return offset;
            }
            offset = offset.add(1);
        }
        return offset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord compare(Pointer x, Pointer y, UnsignedWord size) {
        UnsignedWord alignBits = Word.unsigned((int)7);
        UnsignedWord alignedSize = size.and(alignBits.not());
        UnsignedWord offset = UnmanagedMemoryUtil.compareLongs(x, y, alignedSize);
        return offset.add(UnmanagedMemoryUtil.compareBytes(x.add(offset), y.add(offset), size.subtract(offset)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fill(Pointer to, UnsignedWord size, byte value) {
        long v = (long)value & 0xFFL;
        v = v << 8 | v;
        v = v << 16 | v;
        v = v << 32 | v;
        UnsignedWord alignBits = Word.unsigned((int)7);
        UnsignedWord alignedSize = size.and(alignBits.not());
        UnmanagedMemoryUtil.fillLongs(to, alignedSize, v);
        if (alignedSize.notEqual(size)) {
            UnsignedWord offset = alignedSize;
            if (size.and(4).notEqual(0)) {
                to.writeInt((WordBase)offset, (int)v);
                offset = offset.add(4);
            }
            if (size.and(2).notEqual(0)) {
                to.writeShort((WordBase)offset, (short)v);
                offset = offset.add(2);
            }
            if (size.and(1).notEqual(0)) {
                to.writeByte((WordBase)offset, (byte)v);
                offset = offset.add(1);
            }
            assert (offset.equal(size));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fillLongs(Pointer to, UnsignedWord size, long longValue) {
        assert (size.unsignedRemainder(8).equal(0));
        UnsignedWord offset = (UnsignedWord)Word.zero();
        UnsignedWord next = offset.add(32);
        while (next.belowOrEqual(size)) {
            Pointer p = to.add(offset);
            p.writeLong(0, longValue);
            p.writeLong(8, longValue);
            p.writeLong(16, longValue);
            p.writeLong(24, longValue);
            offset = next;
            next = offset.add(32);
        }
        while (offset.belowThan(size)) {
            to.writeLong((WordBase)offset, longValue);
            offset = offset.add(8);
        }
    }

    private UnmanagedMemoryUtil() {
    }
}

