/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import org.graalvm.nativeimage.ImageSingletons;

public interface BuildArtifacts {
    public static BuildArtifacts singleton() {
        return (BuildArtifacts)ImageSingletons.lookup(BuildArtifacts.class);
    }

    public void add(ArtifactType var1, Path var2);

    public List<Path> get(ArtifactType var1);

    public void forEach(BiConsumer<ArtifactType, List<Path>> var1);

    public boolean isEmpty();

    public static enum ArtifactType {
        EXECUTABLE("executables"),
        IMAGE_LAYER("image_layer"),
        IMAGE_LAYER_BUNDLE("image_layer_bundle"),
        SHARED_LIBRARY("shared_libraries"),
        JDK_LIBRARY("jdk_libraries"),
        JDK_LIBRARY_SHIM(JDK_LIBRARY.getJsonKey()),
        LANGUAGE_HOME("language_home"),
        LANGUAGE_INTERNAL_RESOURCES("language_resources"),
        BUILD_INFO("build_info"),
        DEBUG_INFO("debug_info"),
        C_HEADER("c_headers"),
        IMPORT_LIBRARY("import_libraries");

        private final String jsonKey;

        private ArtifactType(String jsonKey) {
            this.jsonKey = jsonKey;
        }

        public String getJsonKey() {
            return this.jsonKey;
        }
    }
}

