/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.code.Register;

public class ReadReservedRegister {
    public static ValueNode createReadStackPointerNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getFrameRegister());
    }

    public static ValueNode createReadIsolateThreadNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getThreadRegister());
    }

    public static ValueNode createReadHeapBaseNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getHeapBaseRegister());
    }

    private static ValueNode createReadNode(StructuredGraph graph, Register register) {
        if (SubstrateCompilationDirectives.isDeoptTarget(graph.method())) {
            return new ReadReservedRegisterFixedNode(register);
        }
        return new ReadReservedRegisterFloatingNode(register);
    }
}

