/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.net.URLConnection;
import java.util.Optional;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;

@AutomaticallyRegisteredFeature
class JDKRegistrations
extends JNIRegistrationUtil
implements InternalFeature {
    JDKRegistrations() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "java.lang.ProcessEnvironment", "java.io.File$TempDirectory", "java.nio.file.TempFileHelper", "java.lang.Terminator");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "java.lang.ProcessImpl", "java.lang.ProcessHandleImpl", "java.lang.ProcessHandleImpl$Info", "java.io.FilePermission");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "java.io.Console");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "jdk.internal.loader.NativeLibraries$LibraryPaths");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "sun.nio.ch.UnixDomainSockets");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "java.util.concurrent.ThreadLocalRandom$ThreadLocalRandomProxy");
        JDKRegistrations.initializeAtRunTime((Feature.FeatureAccess)a, "java.lang.ApplicationShutdownHooks", "java.io.DeleteOnExitHook");
        URLConnection.getFileNameMap();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JDKRegistrations.registerInfoCmpResources(access);
    }

    private static void registerInfoCmpResources(Feature.BeforeAnalysisAccess access) {
        Class infoCmpClazz = ReflectionUtil.lookupClass((boolean)true, (String)"jdk.internal.org.jline.utils.InfoCmp");
        if (infoCmpClazz != null) {
            access.registerReachabilityHandler(a -> {
                Module module = infoCmpClazz.getModule();
                Optional<ResolvedModule> resolvedModule = ModuleLayer.boot().configuration().findModule(module.getName());
                VMError.guarantee(resolvedModule.isPresent());
                try (ModuleReader reader = resolvedModule.get().reference().open();){
                    reader.list().filter(entry -> entry.endsWith(".caps") || entry.endsWith("capabilities.txt")).forEach(entry -> RuntimeResourceAccess.addResource((Module)module, (String)entry));
                }
                catch (IOException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }, new Object[]{infoCmpClazz});
        }
    }
}

