/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.imagelayer.LayerArchiveSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarOutputStream;

public class WriteLayerArchiveSupport
extends LayerArchiveSupport {
    private final Path outputLayerLocation;

    public WriteLayerArchiveSupport(ArchiveSupport archiveSupport, Path layerFile) {
        super(archiveSupport);
        this.outputLayerLocation = WriteLayerArchiveSupport.validateLayerFile(layerFile);
    }

    private static Path validateLayerFile(Path layerFile) {
        Path fileName = layerFile.getFileName();
        if (fileName == null || !fileName.toString().endsWith(".nil")) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " must end with '.nil'.", new Object[0]);
        }
        if (layerFile.getParent() != null) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " must be a simple file name, i.e., no path separators are allowed.", new Object[0]);
        }
        Path layerFilePath = layerFile.toAbsolutePath();
        if (Files.isDirectory(layerFilePath, new LinkOption[0])) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " is a directory and not a file.", new Object[0]);
        }
        Path layerParentPath = layerFilePath.getParent();
        if (layerParentPath == null) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " doesn't have a parent directory.", new Object[0]);
        }
        if (!Files.isWritable(layerParentPath)) {
            throw UserError.abort("The layer file parent directory " + String.valueOf(layerParentPath) + " is not writeable.", new Object[0]);
        }
        if (Files.exists(layerFilePath, new LinkOption[0]) && !Files.isWritable(layerFilePath)) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " is not writeable.", new Object[0]);
        }
        return layerFile;
    }

    public void write(String imageName) {
        this.layerProperties.writeLayerName(String.valueOf(imageName));
        this.layerProperties.write();
        try (JarOutputStream jarOutStream = new JarOutputStream(Files.newOutputStream(this.outputLayerLocation, new OpenOption[0]), this.archiveSupport.createManifest());){
            Path imageBuilderOutputDir = NativeImageGenerator.getOutputDirectory();
            jarOutStream.setLevel(0);
            Path snapshotFile = BuildArtifacts.singleton().get(BuildArtifacts.ArtifactType.LAYER_SNAPSHOT).getFirst();
            this.archiveSupport.addFileToJar(imageBuilderOutputDir, snapshotFile, this.outputLayerLocation, jarOutStream);
            Path snapshotGraphsFile = BuildArtifacts.singleton().get(BuildArtifacts.ArtifactType.LAYER_SNAPSHOT_GRAPHS).getFirst();
            this.archiveSupport.addFileToJar(imageBuilderOutputDir, snapshotGraphsFile, this.outputLayerLocation, jarOutStream);
            Path sharedLibFile = BuildArtifacts.singleton().get(BuildArtifacts.ArtifactType.IMAGE_LAYER).getFirst();
            this.archiveSupport.addFileToJar(imageBuilderOutputDir, sharedLibFile, this.outputLayerLocation, jarOutStream);
            Path propertiesFile = imageBuilderOutputDir.resolve(layerPropertiesFileName);
            this.archiveSupport.addFileToJar(imageBuilderOutputDir, propertiesFile, this.outputLayerLocation, jarOutStream);
        }
        catch (IOException e) {
            throw UserError.abort("Failed to create Native Image Layer file " + String.valueOf(this.outputLayerLocation.getFileName()), e);
        }
        WriteLayerArchiveSupport.info("Layer written to %s", this.outputLayerLocation);
    }
}

