/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import java.nio.file.Path;
import java.util.Arrays;

public class LayerOptionsSupport {

    public record ExtendedOption(String key, String value) {
        static ExtendedOption parse(String option) {
            String[] optionParts = SubstrateUtil.split(option, "=", 2);
            if (optionParts.length == 2) {
                return new ExtendedOption(optionParts[0], optionParts[1]);
            }
            return new ExtendedOption(option, null);
        }
    }

    public record LayerOption(Path fileName, ExtendedOption[] extendedOptions) {
        public static LayerOption parse(String layerOptionValue) {
            VMError.guarantee(!layerOptionValue.isEmpty());
            String[] options = SubstrateUtil.split(layerOptionValue, ",");
            String fileName = null;
            int skip = 0;
            if (options[0].endsWith(".nil")) {
                fileName = options[0];
                skip = 1;
            }
            ExtendedOption[] extendedOptions = (ExtendedOption[])Arrays.stream(options).skip(skip).map(ExtendedOption::parse).toArray(ExtendedOption[]::new);
            return new LayerOption(Path.of(fileName, new String[0]), extendedOptions);
        }
    }
}

