/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageLayerWriter;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.RuntimeOnlyWrapper;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.heap.ImageSingletonWriterImpl;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.lambda.StableLambdaProxyNameFeature;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import com.oracle.svm.hosted.methodhandles.MethodHandleFeature;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerSubstitutionType;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxySubstitutionType;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.impl.CEntryPointLiteralCodePointer;
import sun.reflect.annotation.AnnotationType;

public class SVMImageLayerWriter
extends ImageLayerWriter {
    private NativeImageHeap nativeImageHeap;
    private HostedUniverse hUniverse;

    public SVMImageLayerWriter(boolean useSharedLayerGraphs) {
        super(useSharedLayerGraphs);
    }

    public void setNativeImageHeap(NativeImageHeap nativeImageHeap) {
        this.nativeImageHeap = nativeImageHeap;
    }

    public void setHostedUniverse(HostedUniverse hUniverse) {
        this.hUniverse = hUniverse;
    }

    protected void persistAnnotations(AnnotatedElement annotatedElement, EconomicMap<String, Object> elementMap, Class<? extends Annotation>[] annotationTypes) {
        elementMap.put((Object)"annotation values", Arrays.stream(annotationTypes).map(annotationClass -> {
            EconomicMap members = EconomicMap.create();
            AnnotationType annotationType = AnnotationType.getInstance(annotationClass);
            Annotation annotation = AnnotationAccess.getAnnotation((AnnotatedElement)annotatedElement, (Class)annotationClass);
            annotationType.members().forEach((memberName, memberAccessor) -> {
                try {
                    AnnotationMemberValue memberValue;
                    HashMap<String, String> value;
                    String moduleName = memberAccessor.getDeclaringClass().getModule().getName();
                    if (moduleName != null) {
                        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, SVMImageLayerWriter.class, (boolean)false, (String)moduleName, (String[])new String[0]);
                    }
                    if ((value = (memberValue = AnnotationMemberValue.getMemberValue(annotation, memberName, memberAccessor, annotationType)).get(annotationType.memberTypes().get(memberName))).getClass().isEnum()) {
                        HashMap<String, String> enumEncoding = new HashMap<String, String>();
                        enumEncoding.put("enum class", value.getClass().getName());
                        enumEncoding.put("enum name", ((Object)value).toString());
                        value = enumEncoding;
                    }
                    members.put(memberName, (Object)value);
                }
                catch (AnnotationMetadata.AnnotationExtractionError annotationExtractionError) {
                    // empty catch block
                }
            });
            return members;
        }).toList());
        elementMap.put((Object)"annotations", Arrays.stream(annotationTypes).map(Class::getName).toList());
        super.persistAnnotations(annotatedElement, elementMap, (Class[])annotationTypes);
    }

    protected void persistHook() {
        ImageHeapConstant staticPrimitiveFields = (ImageHeapConstant)this.hUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getStaticPrimitiveFields());
        ImageHeapConstant staticObjectFields = (ImageHeapConstant)this.hUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getStaticObjectFields());
        this.jsonMap.put((Object)"static primitive fields", (Object)this.getConstantId(staticPrimitiveFields));
        this.jsonMap.put((Object)"static object fields", (Object)this.getConstantId(staticObjectFields));
    }

    protected void persistType(AnalysisType type, EconomicMap<String, Object> typeMap) {
        HostVM hostVM = this.aUniverse.hostVM();
        SVMHost svmHost = (SVMHost)hostVM;
        DynamicHub hub = svmHost.dynamicHub((ResolvedJavaType)type);
        typeMap.put((Object)"hub identityHashCode", (Object)System.identityHashCode(hub));
        typeMap.put((Object)"is initialized at build time", (Object)ClassInitializationSupport.singleton().maybeInitializeAtBuildTime((ResolvedJavaType)type));
        ClassInitializationInfo info = hub.getClassInitializationInfo();
        if (info != null) {
            typeMap.put((Object)"in no initializer no tracking", (Object)(info == ClassInitializationInfo.forNoInitializerInfo(false) ? 1 : 0));
            typeMap.put((Object)"is initialized no tracking", (Object)(info == ClassInitializationInfo.forInitializedInfo(false) ? 1 : 0));
            typeMap.put((Object)"is failed no tracking", (Object)(info == ClassInitializationInfo.forFailedInfo(false) ? 1 : 0));
            typeMap.put((Object)"info is initialized", (Object)info.isInitialized());
            typeMap.put((Object)"info is in error state", (Object)info.isInErrorState());
            typeMap.put((Object)"info is linked", (Object)info.isLinked());
            typeMap.put((Object)"info has initializer", (Object)info.hasInitializer());
            typeMap.put((Object)"info is build time initialized", (Object)info.isBuildTimeInitialized());
            typeMap.put((Object)"info is tracked", (Object)info.isTracked());
            FunctionPointerHolder classInitializer = info.getClassInitializer();
            if (classInitializer != null) {
                MethodPointer methodPointer = (MethodPointer)classInitializer.functionPointer;
                AnalysisMethod classInitializerMethod = (AnalysisMethod)methodPointer.getMethod();
                typeMap.put((Object)"info class initializer", (Object)classInitializerMethod.getId());
            }
        }
        super.persistType(type, typeMap);
    }

    public void checkTypeStability(AnalysisType type) {
        ProxySubstitutionType proxySubstitutionType;
        Object methodHandleFeature;
        String message;
        Object stableLambdaProxyNameFeature;
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof LambdaSubstitutionType) {
            LambdaSubstitutionType lambdaSubstitutionType = (LambdaSubstitutionType)resolvedJavaType;
            stableLambdaProxyNameFeature = (StableLambdaProxyNameFeature)ImageSingletons.lookup(StableLambdaProxyNameFeature.class);
            if (!((StableLambdaProxyNameFeature)stableLambdaProxyNameFeature).getLambdaSubstitutionProcessor().isNameAlwaysStable(lambdaSubstitutionType.getName())) {
                message = "The lambda method " + lambdaSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((stableLambdaProxyNameFeature = type.getWrapped()) instanceof MethodHandleInvokerSubstitutionType) {
            MethodHandleInvokerSubstitutionType methodHandleSubstitutionType = (MethodHandleInvokerSubstitutionType)stableLambdaProxyNameFeature;
            methodHandleFeature = (MethodHandleFeature)ImageSingletons.lookup(MethodHandleFeature.class);
            if (!((MethodHandleFeature)methodHandleFeature).getMethodHandleSubstitutionProcessor().isNameAlwaysStable(methodHandleSubstitutionType.getName())) {
                message = "The method handle " + methodHandleSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((methodHandleFeature = type.getWrapped()) instanceof ProxySubstitutionType && !ProxyRenamingSubstitutionProcessor.isNameAlwaysStable((proxySubstitutionType = (ProxySubstitutionType)methodHandleFeature).getName())) {
            String message2 = "The Proxy type " + proxySubstitutionType.getName() + " might not have a stable name in the extension image.";
            SVMImageLayerWriter.handleNameConflict(message2);
        }
    }

    private static void handleNameConflict(String message) {
        if (SubstrateOptions.AbortOnNameConflict.getValue().booleanValue()) {
            throw VMError.shouldNotReachHere(message);
        }
        LogUtils.warning((String)message);
    }

    public void persistMethod(AnalysisMethod method, EconomicMap<String, Object> methodMap) {
        super.persistMethod(method, methodMap);
        HostedDynamicLayerInfo.singleton().recordPersistedMethod(this.hUniverse.lookup((JavaMethod)method));
    }

    protected void persistField(AnalysisField field, EconomicMap<String, Object> fieldMap) {
        Integer fieldCheck;
        HostedField hostedField = this.hUniverse.lookup((JavaField)field);
        int location = hostedField.getLocation();
        if (location > 0) {
            fieldMap.put((Object)"location", (Object)location);
        }
        if ((fieldCheck = StaticFinalFieldFoldingFeature.singleton().getFieldCheckIndex(field)) != null) {
            fieldMap.put((Object)"field check", (Object)fieldCheck);
        }
        super.persistField(field, fieldMap);
    }

    protected void persistConstant(int parentId, int index, ImageHeapConstant imageHeapConstant, EconomicMap<String, Object> constantMap) {
        NativeImageHeap.ObjectInfo objectInfo = this.nativeImageHeap.getConstantInfo((JavaConstant)imageHeapConstant);
        if (objectInfo != null) {
            constantMap.put((Object)"object offset", (Object)String.valueOf(objectInfo.getOffset()));
        }
        super.persistConstant(parentId, index, imageHeapConstant, constantMap);
    }

    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, BigBang bb, Class<?> clazz, JavaConstant hostedObject, int id) {
        ResolvedJavaType type = bb.getConstantReflectionProvider().asJavaType((Constant)hostedObject);
        if (type instanceof AnalysisType) {
            AnalysisType analysisType = (AnalysisType)type;
            constantMap.put((Object)"class id", (Object)analysisType.getId());
            this.constantsToRelink.add(id);
        } else {
            super.persistConstantRelinkingInfo(constantMap, bb, clazz, hostedObject, id);
        }
    }

    protected boolean delegateProcessing(List<List<Object>> data, Object constant) {
        if (constant instanceof RelocatableConstant) {
            RelocatableConstant relocatableConstant = (RelocatableConstant)constant;
            RelocatedPointer pointer = relocatableConstant.getPointer();
            if (pointer instanceof MethodPointer) {
                MethodPointer methodPointer = (MethodPointer)pointer;
                AnalysisMethod method = SVMImageLayerWriter.getRelocatableConstantMethod(methodPointer);
                this.persistMethod(method);
                data.add(List.of("M", Integer.valueOf(method.getId())));
                return true;
            }
            if (pointer instanceof CEntryPointLiteralCodePointer) {
                CEntryPointLiteralCodePointer cEntryPointLiteralCodePointer = (CEntryPointLiteralCodePointer)pointer;
                data.add(List.of("CONSTANT", cEntryPointLiteralCodePointer.methodName, cEntryPointLiteralCodePointer.definingClass.getName(), Arrays.stream(cEntryPointLiteralCodePointer.parameterTypes).map(Class::getName)));
                return true;
            }
        }
        return super.delegateProcessing(data, constant);
    }

    private static AnalysisMethod getRelocatableConstantMethod(MethodPointer methodPointer) {
        ResolvedJavaMethod method = methodPointer.getMethod();
        if (method instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)method;
            return hostedMethod.wrapped;
        }
        return (AnalysisMethod)method;
    }

    public void writeImageSingletonInfo(List<Map.Entry<Class<?>, Object>> layeredImageSingletons) {
        SingletonPersistInfo info;
        ArrayList<List<Integer>> singletonsList = new ArrayList<List<Integer>>();
        HashMap<LayeredImageSingleton, SingletonPersistInfo> singletonInfoMap = new HashMap<LayeredImageSingleton, SingletonPersistInfo>();
        int nextID = 1;
        for (Map.Entry<Class<?>, Object> singletonInfo : layeredImageSingletons) {
            LayeredImageSingleton singleton;
            Object object = singletonInfo.getValue();
            if (object instanceof RuntimeOnlyWrapper) {
                RuntimeOnlyWrapper wrapper = (RuntimeOnlyWrapper)object;
                singleton = wrapper.wrappedObject();
            } else {
                singleton = (LayeredImageSingleton)singletonInfo.getValue();
            }
            String key = singletonInfo.getKey().getName();
            if (!singletonInfoMap.containsKey(singleton)) {
                ImageSingletonWriterImpl writer = new ImageSingletonWriterImpl();
                LayeredImageSingleton.PersistFlags flags = singleton.preparePersist(writer);
                boolean persistData = flags == LayeredImageSingleton.PersistFlags.CREATE;
                SingletonPersistInfo info2 = new SingletonPersistInfo(flags, persistData ? nextID++ : -1, persistData ? writer.getKeyValueStore() : null);
                singletonInfoMap.put(singleton, info2);
            }
            info = (SingletonPersistInfo)singletonInfoMap.get(singleton);
            singletonsList.add(List.of(key, Integer.valueOf(info.flags.ordinal()), Integer.valueOf(info.id)));
        }
        this.jsonMap.put((Object)"image singleton keys", singletonsList);
        ArrayList<List<EconomicMap<String, Object>>> objectList = new ArrayList<List<EconomicMap<String, Object>>>();
        List<Map.Entry> sortedByIDs = singletonInfoMap.entrySet().stream().filter(e -> ((SingletonPersistInfo)e.getValue()).flags == LayeredImageSingleton.PersistFlags.CREATE).sorted(Comparator.comparingInt(e -> ((SingletonPersistInfo)e.getValue()).id)).toList();
        for (Map.Entry entry : sortedByIDs) {
            info = (SingletonPersistInfo)entry.getValue();
            objectList.add(List.of(Integer.valueOf(info.id), ((LayeredImageSingleton)entry.getKey()).getClass().getName(), info.keyStore));
        }
        this.jsonMap.put((Object)"image singleton objects", objectList);
    }

    record SingletonPersistInfo(LayeredImageSingleton.PersistFlags flags, int id, EconomicMap<String, Object> keyStore) {
    }
}

