/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.ImageLayerLoaderHelper;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.lambda.LambdaParser;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.serialize.SerializationFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.internal.reflect.ReflectionFactory;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public class SVMImageLayerLoaderHelper
extends ImageLayerLoaderHelper {
    private final Map<Class<?>, Boolean> capturingClasses = new ConcurrentHashMap();

    public SVMImageLayerLoaderHelper(ImageLayerLoader imageLayerLoader) {
        super(imageLayerLoader);
    }

    protected boolean loadType(EconomicMap<String, Object> typeData, int tid) {
        String wrappedType = (String)ImageLayerLoader.get(typeData, (String)"wrapped type");
        if (wrappedType == null) {
            return false;
        }
        if (wrappedType.equals("generated serialization")) {
            String rawDeclaringClassName = (String)ImageLayerLoader.get(typeData, (String)"raw declaring class");
            String rawTargetConstructorClassName = (String)ImageLayerLoader.get(typeData, (String)"raw target constructor class");
            Class rawDeclaringClass = this.imageLayerLoader.lookupClass(false, rawDeclaringClassName);
            Class rawTargetConstructorClass = this.imageLayerLoader.lookupClass(false, rawTargetConstructorClassName);
            SerializationSupport serializationSupport = SerializationSupport.singleton();
            Constructor rawTargetConstructor = ReflectionUtil.lookupConstructor((Class)rawTargetConstructorClass, (Class[])new Class[0]);
            Constructor<?> constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(rawDeclaringClass, rawTargetConstructor);
            serializationSupport.addConstructorAccessor(rawDeclaringClass, rawTargetConstructorClass, SerializationFeature.getConstructorAccessor(constructor));
            Class<?> constructorAccessor = serializationSupport.getSerializationConstructorAccessor(rawDeclaringClass, rawTargetConstructorClass).getClass();
            this.imageLayerLoader.getMetaAccess().lookupJavaType(constructorAccessor);
            return true;
        }
        if (wrappedType.equals("lambda type")) {
            String capturingClassName = (String)ImageLayerLoader.get(typeData, (String)"capturing class");
            Class capturingClass = this.imageLayerLoader.lookupClass(false, capturingClassName);
            this.loadLambdaTypes(capturingClass);
        } else if (wrappedType.equals("proxy type")) {
            List interfaceIds = (List)ImageLayerLoader.get(typeData, (String)"interfaces");
            Class[] interfaces = (Class[])interfaceIds.stream().map(i -> this.imageLayerLoader.getAnalysisType(i).getJavaClass()).toArray(Class[]::new);
            Class<?> proxy = Proxy.getProxyClass(interfaces[0].getClassLoader(), interfaces);
            this.imageLayerLoader.getMetaAccess().lookupJavaType(proxy);
            return true;
        }
        return super.loadType(typeData, tid);
    }

    private void loadLambdaTypes(Class<?> capturingClass) {
        AnalysisUniverse universe = this.imageLayerLoader.getUniverse();
        this.capturingClasses.computeIfAbsent(capturingClass, key -> {
            LambdaParser.allExecutablesDeclaredInClass(universe.getOriginalMetaAccess().lookupJavaType(capturingClass)).filter(m -> m.getCode() != null).forEach(m -> SVMImageLayerLoaderHelper.loadLambdaTypes(m, universe.getBigbang()));
            return true;
        });
    }

    private static void loadLambdaTypes(ResolvedJavaMethod m, BigBang bigBang) {
        StructuredGraph graph;
        try {
            graph = LambdaParser.createMethodGraph(m, bigBang.getOptions());
        }
        catch (NoClassDefFoundError | BytecodeParser.BytecodeParserError e) {
            return;
        }
        NodeIterable constantNodes = ConstantNode.getConstantNodes((StructuredGraph)graph);
        for (ConstantNode cNode : constantNodes) {
            Class<?> lambdaClass = LambdaParser.getLambdaClassFromConstantNode(cNode);
            if (lambdaClass == null) continue;
            bigBang.getMetaAccess().lookupJavaType(lambdaClass);
        }
    }

    protected boolean loadMethod(EconomicMap<String, Object> methodData, int mid) {
        String wrappedMethod = (String)ImageLayerLoader.get(methodData, (String)"wrapped method");
        if (wrappedMethod == null) {
            return false;
        }
        if (wrappedMethod.equals("factory")) {
            int constructorId = (Integer)ImageLayerLoader.get(methodData, (String)"target constructor");
            boolean throwAllocatedObject = (Boolean)ImageLayerLoader.get(methodData, (String)"throw allocated object");
            AnalysisMethod analysisMethod = this.imageLayerLoader.getAnalysisMethod(constructorId);
            if (analysisMethod.wrapped instanceof BaseLayerMethod) {
                return false;
            }
            int instantiatedTypeId = (Integer)ImageLayerLoader.get(methodData, (String)"instantiated type");
            AnalysisType instantiatedType = this.imageLayerLoader.getAnalysisType(Integer.valueOf(instantiatedTypeId));
            FactoryMethodSupport.singleton().lookup(this.imageLayerLoader.getMetaAccess(), analysisMethod, instantiatedType, throwAllocatedObject);
            return true;
        }
        if (wrappedMethod.equals("CEntryPointCallStubMethod")) {
            int originalMethodId = (Integer)ImageLayerLoader.get(methodData, (String)"original method id");
            boolean asNotPublished = (Boolean)ImageLayerLoader.get(methodData, (String)"not as published");
            AnalysisMethod originalMethod = this.imageLayerLoader.getAnalysisMethod(originalMethodId);
            CEntryPointCallStubSupport.singleton().registerStubForMethod(originalMethod, () -> {
                CEntryPointData data = CEntryPointData.create((ResolvedJavaMethod)originalMethod);
                if (asNotPublished) {
                    data = data.copyWithPublishAs(CEntryPoint.Publish.NotPublished);
                }
                return data;
            });
            return true;
        }
        if (wrappedMethod.equals("reflection expand signature method")) {
            Executable member = this.getWrappedMember(methodData);
            if (member == null) {
                return false;
            }
            ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(member);
            return true;
        }
        if (wrappedMethod.equals("jni java call variant wrapper method")) {
            Executable member = this.getWrappedMember(methodData);
            if (member == null) {
                return false;
            }
            JNIAccessFeature.singleton().addMethod(member, (FeatureImpl.DuringAnalysisAccessImpl)this.imageLayerLoader.getUniverse().getConcurrentAnalysisAccess());
            return true;
        }
        return super.loadMethod(methodData, mid);
    }

    private Executable getWrappedMember(EconomicMap<String, Object> methodData) {
        String className = (String)ImageLayerLoader.get(methodData, (String)"wrapped member class");
        Class declaringClass = this.imageLayerLoader.lookupClass(true, className);
        if (declaringClass == null) {
            return null;
        }
        String name = (String)ImageLayerLoader.get(methodData, (String)"wrapped member name");
        List parameterNames = (List)ImageLayerLoader.get(methodData, (String)"wrapped member arguments");
        Class[] parameters = (Class[])parameterNames.stream().map(c -> this.imageLayerLoader.lookupClass(false, c)).toArray(Class[]::new);
        return ImageLayerLoader.lookupMethodByReflection((String)name, (Class)declaringClass, (Class[])parameters);
    }
}

