/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.heap.ImageSingletonLoaderImpl;
import com.oracle.svm.hosted.heap.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import com.oracle.svm.hosted.util.IdentityHashCodeUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.impl.CEntryPointLiteralCodePointer;
import sun.reflect.annotation.AnnotationParser;

public class SVMImageLayerLoader
extends ImageLayerLoader {
    private final Field dynamicHubArrayHubField = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");
    private HostedUniverse hostedUniverse;
    private final ImageClassLoader imageClassLoader;

    public SVMImageLayerLoader(List<ImageLayerLoader.FilePaths> loadPaths, ImageClassLoader imageClassLoader) {
        super(loadPaths);
        this.imageClassLoader = imageClassLoader;
    }

    public void setHostedUniverse(HostedUniverse hostedUniverse) {
        this.hostedUniverse = hostedUniverse;
    }

    public HostedUniverse getHostedUniverse() {
        return this.hostedUniverse;
    }

    public ClassInitializationInfo getClassInitializationInfo(AnalysisType type) {
        ClassInitializationInfo.InitState initState;
        int tid = type.getId();
        EconomicMap typesMap = (EconomicMap)SVMImageLayerLoader.get((EconomicMap)this.jsonMap, (String)"types");
        EconomicMap typeMap = (EconomicMap)SVMImageLayerLoader.get((EconomicMap)typesMap, (String)((String)this.typeIdToIdentifier.get(tid)));
        boolean isNoInitializerNoTracking = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"in no initializer no tracking");
        boolean isInitializedNoTracking = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"is initialized no tracking");
        boolean isFailedNoTracking = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"is failed no tracking");
        if (isNoInitializerNoTracking) {
            return ClassInitializationInfo.forNoInitializerInfo(false);
        }
        if (isInitializedNoTracking) {
            return ClassInitializationInfo.forInitializedInfo(false);
        }
        if (isFailedNoTracking) {
            return ClassInitializationInfo.forFailedInfo(false);
        }
        boolean isInitialized = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info is initialized");
        boolean isInErrorState = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info is in error state");
        boolean isLinked = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info is linked");
        boolean hasInitializer = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info has initializer");
        boolean isBuildTimeInitialized = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info is build time initialized");
        boolean isTracked = (Boolean)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info is tracked");
        if (isInitialized) {
            initState = ClassInitializationInfo.InitState.FullyInitialized;
        } else if (isInErrorState) {
            initState = ClassInitializationInfo.InitState.InitializationError;
        } else {
            assert (isLinked) : "Invalid state";
            Integer classInitializerId = (Integer)SVMImageLayerLoader.get((EconomicMap)typeMap, (String)"info class initializer");
            MethodPointer classInitializer = classInitializerId == null ? null : new MethodPointer((ResolvedJavaMethod)this.getAnalysisMethod(classInitializerId));
            return new ClassInitializationInfo(classInitializer, isTracked);
        }
        return new ClassInitializationInfo(initState, hasInitializer, isBuildTimeInitialized, isTracked);
    }

    public Class<?> lookupClass(boolean optional, String className) {
        TypeResult<Class<?>> typeResult = this.imageClassLoader.findClass(className);
        if (!typeResult.isPresent()) {
            if (optional) {
                return null;
            }
            throw AnalysisError.shouldNotReachHere((String)("Class not found: " + className));
        }
        return typeResult.get();
    }

    protected Annotation[] getAnnotations(EconomicMap<String, Object> elementData) {
        List annotationNames = (List)SVMImageLayerLoader.get(elementData, (String)"annotations");
        List annotationValuesList = (List)SVMImageLayerLoader.get(elementData, (String)"annotation values");
        Annotation[] annotations = new Annotation[annotationNames.size()];
        for (int i = 0; i < annotationNames.size(); ++i) {
            Class annotationType = (Class)SVMImageLayerLoader.cast((Object)this.lookupBaseLayerTypeInHostVM((String)annotationNames.get(i)));
            EconomicMap annotationValues = (EconomicMap)annotationValuesList.get(i);
            HashMap<String, Object> annotationValuesMap = new HashMap<String, Object>();
            MapCursor cursor = annotationValues.getEntries();
            while (cursor.advance()) {
                Object value = cursor.getValue();
                if (value instanceof EconomicMap) {
                    EconomicMap enumData = (EconomicMap)SVMImageLayerLoader.cast((Object)value);
                    value = this.getEnumValue(enumData);
                }
                annotationValuesMap.put((String)cursor.getKey(), value);
            }
            annotations[i] = AnnotationParser.annotationForMap(annotationType, annotationValuesMap);
        }
        return annotations;
    }

    protected void initializeBaseLayerMethod(AnalysisMethod analysisMethod, EconomicMap<String, Object> methodData) {
        if (!HostedDynamicLayerInfo.singleton().compiledInPriorLayer(analysisMethod) && this.hasAnalysisParsedGraph(analysisMethod)) {
            analysisMethod.ensureGraphParsed(this.universe.getBigbang());
            analysisMethod.setAnalyzedGraph(((AnalysisParsedGraph)analysisMethod.getGraph()).getEncodedGraph());
        }
        super.initializeBaseLayerMethod(analysisMethod, methodData);
    }

    protected void afterGraphDecodeHook(EncodedGraph encodedGraph) {
        super.afterGraphDecodeHook(encodedGraph);
        for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
            Object object = encodedGraph.getObject(i);
            if (!(object instanceof CGlobalDataInfo)) continue;
            CGlobalDataInfo cGlobalDataInfo = (CGlobalDataInfo)object;
            encodedGraph.setObject(i, (Object)CGlobalDataFeature.singleton().registerAsAccessedOrGet(cGlobalDataInfo.getData()));
        }
    }

    public void initializeBaseLayerField(AnalysisField analysisField) {
        EconomicMap fieldData = this.getFieldData(analysisField);
        Integer fieldCheckIndex = (Integer)SVMImageLayerLoader.get((EconomicMap)fieldData, (String)"field check");
        if (fieldCheckIndex != null) {
            StaticFinalFieldFoldingFeature.singleton().putBaseLayerFieldCheckIndex(analysisField.getId(), fieldCheckIndex);
        }
        super.initializeBaseLayerField(analysisField);
    }

    protected void prepareConstantRelinking(EconomicMap<String, Object> constantData, int identityHashCode, int id) {
        Integer tid = (Integer)SVMImageLayerLoader.get(constantData, (String)"class id");
        if (tid != null) {
            this.typeToConstant.put(tid, id);
        } else {
            super.prepareConstantRelinking(constantData, identityHashCode, id);
        }
    }

    protected boolean delegateProcessing(String constantType, Object constantValue, List<Object> constantData, Object[] values, int i) {
        if (constantType.equals("M")) {
            AnalysisFuture task = new AnalysisFuture(() -> {
                AnalysisType methodPointerType = this.metaAccess.lookupJavaType(MethodPointer.class);
                int mid = (Integer)constantValue;
                AnalysisMethod method = this.getAnalysisMethod(mid);
                RelocatableConstant constant = new RelocatableConstant((RelocatedPointer)new MethodPointer((ResolvedJavaMethod)method), methodPointerType);
                values[i] = constant;
                return constant;
            });
            values[i] = task;
            return true;
        }
        if (constantType.equals("CONSTANT")) {
            AnalysisType cEntryPointerLiteralPointerType = this.metaAccess.lookupJavaType(CEntryPointLiteralCodePointer.class);
            String methodName = (String)constantValue;
            Class definingClass = this.lookupBaseLayerTypeInHostVM((String)constantData.get(2));
            List parameters = (List)SVMImageLayerLoader.cast((Object)constantData.get(3));
            Class[] parameterTypes = parameters.stream().map(arg_0 -> ((SVMImageLayerLoader)this).lookupBaseLayerTypeInHostVM(arg_0)).toList().toArray(new Class[0]);
            values[i] = new RelocatableConstant((RelocatedPointer)new CEntryPointLiteralCodePointer(definingClass, methodName, parameterTypes), cEntryPointerLiteralPointerType);
            return true;
        }
        return super.delegateProcessing(constantType, constantValue, constantData, values, i);
    }

    protected JavaConstant lookupHostedObject(EconomicMap<String, Object> baseLayerConstant, Class<?> clazz) {
        Integer tid;
        if (clazz.equals(Class.class) && (tid = (Integer)SVMImageLayerLoader.get(baseLayerConstant, (String)"class id")) != null) {
            return this.getDynamicHub(tid);
        }
        return super.lookupHostedObject(baseLayerConstant, clazz);
    }

    private JavaConstant getDynamicHub(int tid) {
        AnalysisType type = this.getAnalysisType(tid);
        DynamicHub hub = ((SVMHost)this.universe.hostVM()).dynamicHub((ResolvedJavaType)type);
        return this.hostedValuesProvider.forObject((Object)hub);
    }

    protected void injectIdentityHashCode(Object object, Integer identityHashCode) {
        if (object == null || identityHashCode == null) {
            return;
        }
        boolean result = IdentityHashCodeUtil.injectIdentityHashCode(object, identityHashCode);
        if (!result && SubstrateOptions.LoggingHashCodeInjection.getValue().booleanValue()) {
            LogUtils.warning((String)"Object of type %s already had an hash code: %s", (Object[])new Object[]{object.getClass(), object});
        }
    }

    public void ensureHubInitialized(ImageHeapConstant constant) {
        JavaConstant javaConstant = constant.getHostedObject();
        if (constant.getType().getJavaClass().equals(Class.class)) {
            DynamicHub hub = (DynamicHub)this.universe.getHostedValuesProvider().asObject(DynamicHub.class, javaConstant);
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(hub);
            SVMImageLayerLoader.ensureHubInitialized(type);
            if (((ImageHeapInstance)constant).getFieldValue(this.metaAccess.lookupJavaField(this.dynamicHubArrayHubField)) != JavaConstant.NULL_POINTER && hub.getArrayHub() == null) {
                AnalysisType arrayClass = type.getArrayClass();
                SVMImageLayerLoader.ensureHubInitialized(arrayClass);
            }
        }
    }

    private static void ensureHubInitialized(AnalysisType type) {
        type.registerAsReachable((Object)"persisted");
        type.getInitializeMetaDataTask().ensureDone();
    }

    public void rescanHub(AnalysisType type, Object hubObject) {
        DynamicHub hub = (DynamicHub)hubObject;
        this.universe.getHeapScanner().rescanObject((Object)hub);
        this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.classInitializationInfo);
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray()) {
                this.universe.getHeapScanner().rescanField((Object)hub.getComponentHub(), SVMImageLayerSnapshotUtil.arrayHub);
            }
            this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.interfacesEncoding);
            if (type.isEnum()) {
                this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.enumConstantsReference);
            }
        }
    }

    protected boolean hasValueForObject(Object object) {
        if (object instanceof DynamicHub) {
            DynamicHub dynamicHub = (DynamicHub)object;
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(dynamicHub);
            return this.typeToConstant.containsKey(type.getId());
        }
        return super.hasValueForObject(object);
    }

    protected ImageHeapConstant getValueForObject(Object object) {
        if (object instanceof DynamicHub) {
            DynamicHub dynamicHub = (DynamicHub)object;
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(dynamicHub);
            int id = (Integer)this.typeToConstant.get(type.getId());
            return this.getOrCreateConstant(id);
        }
        return super.getValueForObject(object);
    }

    public Map<Object, Set<Class<?>>> loadImageSingletons(Object forbiddenObject) {
        this.openFilesAndLoadJsonMap();
        return this.loadImageSingletons0(forbiddenObject);
    }

    private Map<Object, Set<Class<?>>> loadImageSingletons0(Object forbiddenObject) {
        List singletonObjects = (List)SVMImageLayerLoader.cast((Object)this.jsonMap.get((Object)"image singleton objects"));
        HashMap<Integer, Object> idToObjectMap = new HashMap<Integer, Object>();
        for (Object entry : singletonObjects) {
            Object result;
            List list = (List)SVMImageLayerLoader.cast(entry);
            Integer id = (Integer)SVMImageLayerLoader.cast(list.get(0));
            String className = (String)SVMImageLayerLoader.cast(list.get(1));
            EconomicMap keyStore = (EconomicMap)SVMImageLayerLoader.cast(list.get(2));
            try {
                Class<?> clazz = this.lookupClass(false, className);
                Method createMethod = ReflectionUtil.lookupMethod(clazz, (String)"createFromLoader", (Class[])new Class[]{ImageSingletonLoader.class});
                result = createMethod.invoke(null, new ImageSingletonLoaderImpl((UnmodifiableEconomicMap<String, Object>)keyStore, this.imageClassLoader));
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere("Failed to recreate image singleton", t);
            }
            idToObjectMap.put(id, result);
        }
        HashMap singletonInitializationMap = new HashMap();
        List singletonKeys = (List)SVMImageLayerLoader.cast((Object)this.jsonMap.get((Object)"image singleton keys"));
        for (Object entry : singletonKeys) {
            List list = (List)SVMImageLayerLoader.cast(entry);
            String key = (String)SVMImageLayerLoader.cast(list.get(0));
            LayeredImageSingleton.PersistFlags persistInfo = LayeredImageSingleton.PersistFlags.values()[(Integer)list.get(1)];
            int id = (Integer)SVMImageLayerLoader.cast(list.get(2));
            if (persistInfo == LayeredImageSingleton.PersistFlags.CREATE) {
                assert (id != -1) : "Create image singletons should be linked to an object";
                Object singletonObject = idToObjectMap.get(id);
                Class<?> clazz = this.lookupClass(false, key);
                singletonInitializationMap.computeIfAbsent(singletonObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(singletonObject)).add(clazz);
                continue;
            }
            if (persistInfo == LayeredImageSingleton.PersistFlags.FORBIDDEN) {
                assert (id == -1) : "Unrestored image singleton should not be linked to an object";
                Class<?> clazz = this.lookupClass(false, key);
                singletonInitializationMap.computeIfAbsent(forbiddenObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(forbiddenObject)).add(clazz);
                continue;
            }
            assert (persistInfo == LayeredImageSingleton.PersistFlags.NOTHING) : "Unexpected PersistFlags value: " + String.valueOf((Object)persistInfo);
            assert (id == -1) : "Unrestored image singleton should not be linked to an object";
        }
        return singletonInitializationMap;
    }
}

