/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.lir.RedundantMoveElimination;
import jdk.graal.compiler.lir.alloc.RegisterAllocationPhase;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.BoxNodeOptimizationPhase;
import jdk.graal.compiler.phases.common.FixReadsPhase;
import jdk.graal.compiler.phases.common.FloatingReadPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.graal.compiler.virtual.phases.ea.ReadEliminationPhase;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class DeoptimizationUtils {
    public static final NodePredicate RUNTIME_COMPILATION_INVALID_NODES = n -> NodePredicates.isA(StackValueNode.class).or((Predicate)NodePredicates.isA(EnsureClassInitializedNode.class)).test(n);
    public static final NodePredicate AOT_COMPILATION_INVALID_NODES = n -> NodePredicates.isA(StackValueNode.class).test(n);

    static void insertDeoptTests(HostedMethod method, StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            if (!(node instanceof FixedWithNextNode) || !(node instanceof StateSplit) || node instanceof InvokeNode || node instanceof ForeignCallNode || node instanceof DeoptTestNode || method.isSynchronized() && node instanceof StartNode) continue;
            FixedWithNextNode fixedWithNext = (FixedWithNextNode)node;
            FixedNode next = fixedWithNext.next();
            DeoptTestNode testNode = (DeoptTestNode)graph.add((Node)new DeoptTestNode());
            fixedWithNext.setNext(null);
            testNode.setNext(next);
            fixedWithNext.setNext((FixedNode)testNode);
            if (((StateSplit)node).hasSideEffect() && ((StateSplit)node).stateAfter() != null) {
                testNode.setStateAfter(((StateSplit)node).stateAfter().duplicateWithVirtualState());
                continue;
            }
            testNode.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)node)).duplicateWithVirtualState());
        }
    }

    public static boolean canDeoptForTesting(AnalysisMethod method, boolean deoptimizeAll, Supplier<Boolean> graphChecker) {
        if (SubstrateCompilationDirectives.singleton().isRegisteredForDeoptTesting((ResolvedJavaMethod)method)) {
            return true;
        }
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getAnnotation(DeoptTest.class) != null) {
            return true;
        }
        if (!deoptimizeAll) {
            return false;
        }
        if (!graphChecker.get().booleanValue()) {
            return false;
        }
        if (method.isEntryPoint()) {
            return false;
        }
        if (method.isNative()) {
            return false;
        }
        if (method.isIntrinsicMethod()) {
            return false;
        }
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method)) {
            return false;
        }
        if (method.getAnnotation(RestrictHeapAccess.class) != null) {
            return false;
        }
        if (StubCallingConvention.Utils.hasStubCallingConvention((ResolvedJavaMethod)method)) {
            return false;
        }
        String className = method.getDeclaringClass().getName();
        if (className.contains("/svm/core/code/CodeInfoEncoder") || className.contains("com/oracle/svm/core/thread/JavaThreads") || className.contains("com/oracle/svm/core/thread/PlatformThreads") || className.contains("com/oracle/svm/core/heap/") || className.contains("com/oracle/svm/core/genscavenge/") || className.contains("com/oracle/svm/core/thread/VMOperationControl") || className.contains("debug/internal/DebugValueMap") && method.getName().equals("registerTopLevel")) {
            return false;
        }
        return method.getCode() != null;
    }

    private static boolean containsStackValueNode(HostedUniverse universe, HostedMethod method) {
        return universe.getBigBang().getHostVM().containsStackValueNode(method.wrapped);
    }

    static boolean canDeoptForTesting(HostedUniverse universe, HostedMethod method, boolean deoptimizeAll) {
        return DeoptimizationUtils.canDeoptForTesting(method.wrapped, deoptimizeAll, () -> DeoptimizationUtils.containsStackValueNode(universe, method));
    }

    static void removeDeoptTargetOptimizations(Suites suites) {
        GraalConfiguration.hostedInstance().removeDeoptTargetOptimizations(suites);
        PhaseSuite highTier = suites.getHighTier();
        highTier.removePhase(PartialEscapePhase.class);
        highTier.removePhase(ReadEliminationPhase.class);
        highTier.removePhase(BoxNodeOptimizationPhase.class);
        PhaseSuite midTier = suites.getMidTier();
        midTier.removePhase(FloatingReadPhase.class);
        PhaseSuite lowTier = suites.getLowTier();
        ListIterator it = lowTier.findPhase(FixReadsPhase.class);
        if (it != null) {
            FixReadsPhase fixReads = (FixReadsPhase)it.previous();
            it.remove();
            boolean replaceInputsWithConstants = false;
            it.add(new FixReadsPhase(replaceInputsWithConstants, fixReads.getSchedulePhase()));
        }
    }

    static void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
        ListIterator it = lirSuites.getPostAllocationOptimizationStage().findPhase(RedundantMoveElimination.class);
        if (it != null) {
            it.remove();
        }
        ((RegisterAllocationPhase)lirSuites.getAllocationStage().findPhaseInstance(RegisterAllocationPhase.class)).setNeverSpillConstants(true);
    }

    public static boolean isDeoptEntry(HostedMethod method, CompilationResult compilation, Infopoint infopoint) {
        BytecodeFrame topFrame;
        BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
        while (rootFrame.caller() != null) {
            rootFrame = rootFrame.caller();
        }
        assert (rootFrame.getMethod().equals((Object)method));
        boolean isBciDeoptEntry = method.compilationInfo.isDeoptEntry(rootFrame.getBCI(), FrameState.StackState.of((BytecodeFrame)rootFrame));
        if (isBciDeoptEntry) {
            assert (topFrame == rootFrame) : "Deoptimization target has inlined frame: " + String.valueOf(topFrame);
            if (topFrame.duringCall) {
                VMError.guarantee(infopoint instanceof Call, "Unexpected infopoint type: %s%nFrame: %s", infopoint, topFrame);
                return compilation.isValidCallDeoptimizationState((Call)infopoint);
            }
            return infopoint instanceof DeoptEntryInfopoint;
        }
        return false;
    }

    static boolean verifyDeoptTarget(HostedMethod method, StructuredGraph graph, CompilationResult result) {
        HashMap<Long, BytecodeFrame> encodedBciMap = new HashMap<Long, BytecodeFrame>();
        assert (graph != null) : "Deopt target must have a graph.";
        assert (DeoptimizationUtils.createGraphChecker(graph, AOT_COMPILATION_INVALID_NODES).get().booleanValue()) : "Invalid nodes in deopt target: " + String.valueOf(graph);
        for (Infopoint infopoint : result.getInfopoints()) {
            DebugInfo debugInfo;
            if (infopoint.debugInfo == null || !(debugInfo = infopoint.debugInfo).hasFrame() || !DeoptimizationUtils.isDeoptEntry(method, result, infopoint)) continue;
            BytecodeFrame frame = debugInfo.frame();
            long encodedBci = FrameInfoEncoder.encodeBci(frame.getBCI(), FrameState.StackState.of((BytecodeFrame)frame));
            BytecodeFrame previous = encodedBciMap.put(encodedBci, frame);
            assert (previous == null) : "duplicate encoded bci " + encodedBci + " in deopt target " + String.valueOf(method) + " found.\n\n" + String.valueOf(frame) + "\n\n" + String.valueOf(previous);
        }
        return true;
    }

    static boolean canBeUsedForInlining(HostedUniverse universe, HostedMethod caller, HostedMethod callee, int bci) {
        boolean callerDeoptForTesting = caller.compilationInfo.canDeoptForTesting();
        if (callerDeoptForTesting && Modifier.isNative(callee.getModifiers())) {
            return false;
        }
        if (callerDeoptForTesting && DeoptimizationUtils.containsStackValueNode(universe, callee)) {
            return false;
        }
        if (callerDeoptForTesting != callee.compilationInfo.canDeoptForTesting()) {
            return false;
        }
        if (caller.isDeoptTarget()) {
            if (caller.compilationInfo.isDeoptEntry(bci, FrameState.StackState.AfterPop)) {
                return false;
            }
            if (SubstrateCompilationDirectives.singleton().isDeoptInliningExclude(callee)) {
                return false;
            }
        }
        return true;
    }

    public static void registerDeoptEntriesForDeoptTesting(PointsToAnalysis bb, StructuredGraph graph, PointsToAnalysisMethod aMethod) {
        assert (aMethod.isOriginalMethod());
        Collection<ResolvedJavaMethod> recomputeMethods = DeoptimizationUtils.registerDeoptEntries(graph, true, deoptEntryMethod -> ((PointsToAnalysisMethod)deoptEntryMethod).getOrCreateMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD));
        AnalysisMethod deoptMethod = aMethod.getMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
        if (deoptMethod != null && SubstrateCompilationDirectives.singleton().isRegisteredDeoptTarget((ResolvedJavaMethod)deoptMethod)) {
            SubstrateCompilationDirectives.singleton().registerForDeoptTesting((ResolvedJavaMethod)aMethod);
        }
        for (ResolvedJavaMethod method : recomputeMethods) {
            assert (SubstrateCompilationDirectives.isDeoptTarget(method));
            ((PointsToAnalysisMethod)method).getTypeFlow().updateFlowsGraph(bb, MethodFlowsGraph.GraphKind.FULL, null, true);
        }
    }

    public static Collection<ResolvedJavaMethod> registerDeoptEntries(StructuredGraph graph, boolean isRoot, DeoptTargetRetriever deoptRetriever) {
        ResolvedJavaMethod method;
        Invoke invoke;
        HashSet<ResolvedJavaMethod> changedMethods = new HashSet<ResolvedJavaMethod>();
        for (FrameState frameState : graph.getNodes(FrameState.TYPE)) {
            if (frameState.hasExactlyOneUsage()) {
                Node usage = frameState.usages().first();
                if (!isRoot && usage == graph.start()) continue;
                if (usage instanceof Invoke && (invoke = (Invoke)usage).stateAfter() == frameState) {
                    FixedNode next = invoke.next();
                    while (next instanceof AbstractBeginNode) {
                        next = ((AbstractBeginNode)next).next();
                    }
                    if (next instanceof LoweredDeadEndNode) continue;
                }
            }
            for (FrameState inlineState = frameState; inlineState != null; inlineState = inlineState.outerFrameState()) {
                if (inlineState.bci < 0) continue;
                method = deoptRetriever.getDeoptTarget(inlineState.getMethod());
                if (!SubstrateCompilationDirectives.singleton().registerDeoptEntry(inlineState, method)) continue;
                changedMethods.add(method);
            }
        }
        for (Node n : graph.getNodes()) {
            FrameState stateDuring = null;
            if (n instanceof Invoke) {
                invoke = (Invoke)n;
                stateDuring = invoke.stateAfter().duplicateModifiedDuringCall(invoke.bci(), invoke.asNode().getStackKind());
            } else if (n instanceof MacroInvokable) {
                MacroInvokable macro = (MacroInvokable)n;
                stateDuring = macro.stateAfter().duplicateModifiedDuringCall(macro.bci(), macro.asNode().getStackKind());
            }
            if (stateDuring == null) continue;
            assert (stateDuring.getStackState() == FrameState.StackState.AfterPop) : stateDuring;
            method = deoptRetriever.getDeoptTarget(stateDuring.getMethod());
            if (!SubstrateCompilationDirectives.singleton().registerDeoptEntry(stateDuring, method)) continue;
            changedMethods.add(method);
        }
        return changedMethods;
    }

    public static Supplier<Boolean> createGraphChecker(StructuredGraph graph, NodePredicate invalidNodes) {
        return () -> {
            if (!graph.method().getDeclaringClass().isInitialized()) {
                return false;
            }
            if (graph.getNodes().filter(invalidNodes).isNotEmpty()) {
                return false;
            }
            return true;
        };
    }

    public static interface DeoptTargetRetriever {
        public ResolvedJavaMethod getDeoptTarget(ResolvedJavaMethod var1);
    }
}

