/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formattable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

public class ClassInitializationSupport
implements RuntimeClassInitializationSupport {
    final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    final ConcurrentMap<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private static final Set<Class<?>> alwaysReachedTypes = Set.of(Object.class, Class.class, String.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Enum.class, Cloneable.class, Formattable.class, Throwable.class, Serializable.class, AutoCloseable.class, Runnable.class, Iterable.class, Collection.class, Set.class, List.class, Map.class, System.class, Thread.class, Reference.class, SoftReference.class, StackWalker.class, ReferenceQueue.class);
    final Set<Class<?>> typesRequiringReachability = ConcurrentHashMap.newKeySet();
    boolean configurationSealed;
    final ImageClassLoader loader;
    final MetaAccessProvider metaAccess;

    public static ClassInitializationSupport singleton() {
        return (ClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
    }

    public ClassInitializationSupport(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
    }

    public void setConfigurationSealed(boolean sealed) {
        this.configurationSealed = sealed;
        if (this.configurationSealed && ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
            List<ClassOrPackageConfig> allConfigs = this.classInitializationConfiguration.allConfigs();
            allConfigs.sort(Comparator.comparing(ClassOrPackageConfig::getName));
            ReportUtils.report((String)"class initialization configuration", (String)SubstrateOptions.reportsPath(), (String)"class_initialization_configuration", (String)"csv", writer -> {
                writer.println("Class or Package Name, Initialization Kind, Reasons");
                for (ClassOrPackageConfig config : allConfigs) {
                    writer.append(config.getName()).append(", ").append(config.getKind().toString()).append(", ").append(String.join((CharSequence)" and ", config.getReasons())).append(System.lineSeparator());
                }
            });
        }
    }

    InitKind specifiedInitKindFor(Class<?> clazz) {
        return (InitKind)((Object)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getLeft());
    }

    Boolean isStrictlyDefined(Class<?> clazz) {
        return (Boolean)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getRight();
    }

    Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean maybeInitializeAtBuildTime(ResolvedJavaType type) {
        AnalysisType analysisType;
        ResolvedJavaType resolvedJavaType;
        if (type instanceof AnalysisType && (resolvedJavaType = (analysisType = (AnalysisType)type).getWrapped()) instanceof BaseLayerType) {
            BaseLayerType baseLayerType = (BaseLayerType)resolvedJavaType;
            return baseLayerType.initializedAtBuildTime();
        }
        return this.maybeInitializeAtBuildTime(OriginalClassProvider.getJavaClass((JavaType)type));
    }

    public boolean maybeInitializeAtBuildTime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) == InitKind.BUILD_TIME;
    }

    InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            this.loader.watchdog.recordActivity();
            Unsafe.getUnsafe().ensureClassInitialized(clazz);
            this.loader.watchdog.recordActivity();
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (allowErrors || !LinkAtBuildTimeSupport.singleton().linkAtBuildTime(clazz)) {
                return InitKind.RUN_TIME;
            }
            String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + LinkAtBuildTimeSupport.singleton().errorMessageFor(clazz) + " " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz);
            throw UserError.abort(ex, "%s", msg);
        }
        catch (Throwable t) {
            if (allowErrors) {
                return InitKind.RUN_TIME;
            }
            String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz);
            if (t instanceof ExceptionInInitializerError) {
                Throwable cause = t;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                msg = msg + " Exception thrown by the class initializer:" + System.lineSeparator() + System.lineSeparator() + String.valueOf(cause) + System.lineSeparator();
                for (StackTraceElement element : cause.getStackTrace()) {
                    if (this.getClass().getName().equals(element.getClassName())) {
                        msg = msg + "\t(internal stack frames of the image generator are omitted)" + System.lineSeparator();
                        break;
                    }
                    msg = msg + "\tat " + String.valueOf(element) + System.lineSeparator();
                }
                msg = msg + System.lineSeparator();
            }
            throw UserError.abort(t, "%s", msg);
        }
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time", true, true) + " to explicitly request initialization of this class at run time.";
    }

    public void initializeAtRunTime(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RUN_TIME, reason, true);
    }

    public void initializeAtRunTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, true);
            this.initializeAtRunTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, false);
        }
    }

    public void initializeAtBuildTime(Class<?> aClass, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.forceInitializeHosted(aClass, reason, false);
    }

    public void initializeAtBuildTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, true);
            this.initializeAtBuildTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, false);
        }
    }

    static boolean isClassListedInStringOption(AccumulatingLocatableMultiOptionValue.Strings option, Class<?> clazz) {
        return option.values().contains(clazz.getName());
    }

    private static boolean isObjectInstantiationForClassTracked(Class<?> clazz) {
        return SubstrateOptions.TraceObjectInstantiation.hasBeenSet() && ClassInitializationSupport.isClassListedInStringOption(SubstrateOptions.TraceObjectInstantiation.getValue(), clazz);
    }

    public String objectInstantiationTraceMessage(Object obj, String prefix, Function<String, String> action) {
        Map instantiatedObjects = ClassInitializationTracking.instantiatedObjects;
        if (ClassInitializationSupport.isProxyOrLambda(obj)) {
            return prefix + "If these objects should not be stored in the image heap, please try to infer from the source code how the culprit object got instantiated." + System.lineSeparator();
        }
        if (!ClassInitializationSupport.isObjectInstantiationForClassTracked(obj.getClass())) {
            return prefix + "If these objects should not be stored in the image heap, you can use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceObjectInstantiation, obj.getClass().getName(), true, true) + "to find classes that instantiate these objects. Once you found such a class, you can mark it explicitly for run time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<culprit>", "initialize-at-run-time", true, true) + "to prevent the instantiation of the object." + System.lineSeparator();
        }
        if (instantiatedObjects.containsKey(obj)) {
            StackTraceElement[] trace;
            String culprit = null;
            for (StackTraceElement stackTraceElement : trace = (StackTraceElement[])instantiatedObjects.get(obj)) {
                if (!stackTraceElement.getMethodName().equals("<clinit>")) continue;
                culprit = stackTraceElement.getClassName();
            }
            if (culprit != null) {
                return prefix + action.apply(culprit) + System.lineSeparator() + "The culprit object has been instantiated by the '" + culprit + "' class initializer with the following trace:" + System.lineSeparator() + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj));
            }
            return prefix + action.apply(culprit) + System.lineSeparator() + "The culprit object has been instantiated with the following trace:" + System.lineSeparator() + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj)) + String.valueOf(action);
        }
        return prefix + "Object has been initialized in a core JDK class that is not instrumented for class initialization tracking. Therefore, a stack trace cannot be provided." + System.lineSeparator() + "Please try to infer from the source code how the culprit object got instantiated." + System.lineSeparator();
    }

    static boolean isProxyOrLambda(Object obj) {
        return obj.getClass().getName().contains("$$Lambda") || Proxy.isProxyClass(obj.getClass());
    }

    static String getTraceString(StackTraceElement[] trace) {
        StringBuilder b = new StringBuilder();
        for (StackTraceElement stackTraceElement : trace) {
            b.append("\tat ").append(stackTraceElement.toString()).append("\n");
        }
        return b.toString();
    }

    public void forceInitializeHosted(Class<?> clazz, String reason, boolean allowInitializationErrors) {
        if (clazz == null) {
            return;
        }
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.BUILD_TIME, reason, true);
        InitKind initKind = this.ensureClassInitialized(clazz, allowInitializationErrors);
        this.classInitKinds.put(clazz, initKind);
        this.forceInitializeHosted(clazz.getSuperclass(), "super type of " + clazz.getTypeName(), allowInitializationErrors);
        if (!clazz.isInterface()) {
            this.forceInitializeInterfaces(clazz.getInterfaces(), "super type of " + clazz.getTypeName());
        }
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (this.metaAccess.lookupJavaType(iface).declaresDefaultMethods()) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason, true);
                this.ensureClassInitialized(iface, false);
                this.classInitKinds.put(iface, InitKind.BUILD_TIME);
            }
            this.forceInitializeInterfaces(iface.getInterfaces(), "super type of " + iface.getTypeName());
        }
    }

    InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize) {
        InitKind existing = (InitKind)((Object)this.classInitKinds.get(clazz));
        if (existing != null) {
            return existing;
        }
        if (clazz.isPrimitive()) {
            this.forceInitializeHosted(clazz, "primitive types are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isArray()) {
            this.forceInitializeHosted(clazz, "arrays are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        InitKind specifiedInitKind = this.specifiedInitKindFor(clazz);
        InitKind clazzResult = specifiedInitKind != null ? specifiedInitKind : InitKind.RUN_TIME;
        InitKind superResult = InitKind.BUILD_TIME;
        if (clazz.getSuperclass() != null) {
            superResult = superResult.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize));
        }
        if ((superResult = superResult.max(this.processInterfaces(clazz, memoize))) == InitKind.BUILD_TIME && (Proxy.isProxyClass(clazz) || LambdaUtils.isLambdaType((ResolvedJavaType)this.metaAccess.lookupJavaType(clazz)))) {
            boolean allInterfacesSpecifiedAsBuildTime = true;
            for (Class iface : ClassInitializationSupport.allInterfaces(clazz)) {
                if (this.specifiedInitKindFor(iface) == InitKind.BUILD_TIME) continue;
                allInterfacesSpecifiedAsBuildTime = false;
                break;
            }
            if (allInterfacesSpecifiedAsBuildTime) {
                this.forceInitializeHosted(clazz, "proxy/lambda classes with all interfaces explicitly marked as --initialize-at-build-time are also initialized at build time", false);
                return InitKind.BUILD_TIME;
            }
        }
        InitKind result = superResult.max(clazzResult);
        if (memoize) {
            InitKind previous;
            if (result != InitKind.RUN_TIME) {
                result = result.max(this.ensureClassInitialized(clazz, false));
            }
            if ((previous = this.classInitKinds.putIfAbsent(clazz, result)) != null && previous != result) {
                throw VMError.shouldNotReachHere("Conflicting class initialization kind: " + String.valueOf((Object)previous) + " != " + String.valueOf((Object)result) + " for " + String.valueOf(clazz));
            }
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = InitKind.BUILD_TIME;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = this.metaAccess.lookupJavaType(iface).declaresDefaultMethods() ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    String reasonForClass(Class<?> clazz) {
        InitKind initKind = (InitKind)((Object)this.classInitKinds.get(clazz));
        String reason = this.classInitializationConfiguration.lookupReason(clazz.getTypeName());
        if (initKind == InitKind.RUN_TIME) {
            return "classes are initialized at run time by default";
        }
        if (reason != null) {
            return reason;
        }
        throw VMError.shouldNotReachHere("Must be either proven or specified");
    }

    public static EconomicSet<Class<?>> allInterfaces(Class<?> clazz) {
        EconomicSet result = EconomicSet.create();
        ClassInitializationSupport.addAllInterfaces(clazz, result);
        return result;
    }

    private static void addAllInterfaces(Class<?> clazz, EconomicSet<Class<?>> result) {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!result.add(interf)) continue;
            ClassInitializationSupport.addAllInterfaces(interf, result);
        }
    }

    public void addForTypeReachedTracking(Class<?> clazz) {
        if (ConfigurationFiles.Options.TrackTypeReachedOnInterfaces.getValue().booleanValue() && clazz.isInterface() && !this.metaAccess.lookupJavaType(clazz).declaresDefaultMethods()) {
            LogUtils.info((String)"Detected 'typeReached' on interface type without default methods: %s", (String)clazz.getName());
        }
        if (!this.isAlwaysReached(clazz)) {
            UserError.guarantee(!this.configurationSealed || this.typesRequiringReachability.contains(clazz), "It is not possible to register types for reachability tracking after the analysis has started if they were not registered before analysis started. Trying to register: %s", clazz.getName());
            this.typesRequiringReachability.add(clazz);
        }
    }

    public boolean isAlwaysReached(Class<?> jClass) {
        Set<String> jdkModules = Set.of("java.base", "jdk.management", "java.management", "org.graalvm.collections");
        String classModuleName = jClass.getModule().getName();
        boolean alwaysReachedModule = classModuleName != null && (ModuleSupport.SYSTEM_MODULES.contains(classModuleName) || jdkModules.contains(classModuleName));
        return jClass.isPrimitive() || jClass.isArray() || alwaysReachedModule || alwaysReachedTypes.contains(jClass);
    }

    public boolean requiresInitializationNodeForTypeReached(ResolvedJavaType type) {
        if (type == null) {
            return false;
        }
        Class jClass = OriginalClassProvider.getJavaClass((JavaType)type);
        if (this.isAlwaysReached(jClass)) {
            return false;
        }
        if (ConfigurationFiles.Options.TreatAllUserSpaceTypesAsTrackedForTypeReached.getValue().booleanValue()) {
            return true;
        }
        if (this.typesRequiringReachability.contains(jClass) || this.requiresInitializationNodeForTypeReached(type.getSuperclass())) {
            return true;
        }
        for (ResolvedJavaType anInterface : type.getInterfaces()) {
            if (!this.requiresInitializationNodeForTypeReached(anInterface)) continue;
            return true;
        }
        return false;
    }
}

