/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SamplerStatistics {
    private final UninterruptibleUtils.AtomicLong missedSamples = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong unparseableSamples = new UninterruptibleUtils.AtomicLong(0L);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SamplerStatistics() {
    }

    @Fold
    public static SamplerStatistics singleton() {
        return (SamplerStatistics)ImageSingletons.lookup(SamplerStatistics.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void addMissedSamples(long delta) {
        this.missedSamples.addAndGet(delta);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void addUnparseableSamples(long delta) {
        this.unparseableSamples.addAndGet(delta);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getMissedSamples() {
        return this.missedSamples.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getUnparseableSamples() {
        return this.unparseableSamples.get();
    }
}

