/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class LinuxGOTHeapSupport
extends GOTHeapSupport {
    private static final String FILE_NAME_PREFIX = "/ni-got-";
    private static final int FILE_NAME_PREFIX_LEN = "/ni-got-".length();
    private static final CGlobalData<WordPointer> memoryViewFd = CGlobalDataFactory.createWord((WordBase)WordFactory.signed((int)-1));
    private static final CGlobalData<CCharPointer> fileNamePrefix = CGlobalDataFactory.createCString("/ni-got-");

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int initialize(WordPointer gotStartAddress) {
        int temp;
        int pid = Unistd.NoTransitions.getpid();
        int pidLen = 0;
        for (temp = pid; temp != 0; temp /= 10) {
            ++pidLen;
        }
        CCharPointer nameStr = (CCharPointer)StackValue.get((int)(64 * SizeOf.get(CCharPointer.class)));
        LibC.memcpy(nameStr, (PointerBase)fileNamePrefix.get(), WordFactory.unsigned((int)FILE_NAME_PREFIX_LEN));
        int iter = FILE_NAME_PREFIX_LEN + pidLen;
        nameStr.write(iter, (byte)0);
        for (temp = pid; temp != 0; temp /= 10) {
            nameStr.write(--iter, (byte)(48 + temp % 10));
        }
        int fd = -1;
        for (int i = 0; i < 10; ++i) {
            fd = Mman.NoTransitions.shm_open(nameStr, Fcntl.O_CREAT() | Fcntl.O_EXCL() | Fcntl.O_RDWR(), 0);
            if (fd != -1) {
                Mman.NoTransitions.shm_unlink(nameStr);
                break;
            }
            int errno = LibC.errno();
            if (errno != Errno.EEXIST()) {
                return 25;
            }
            VMThreads.singleton().nativeSleep(5);
        }
        if (fd == -1) {
            return 31;
        }
        UnsignedWord gotPageAlignedSize = LinuxGOTHeapSupport.getPageAlignedGotSize();
        if (Unistd.NoTransitions.ftruncate(fd, WordFactory.signed((long)gotPageAlignedSize.rawValue())) != 0) {
            Unistd.NoTransitions.close(fd);
            return 26;
        }
        Pointer gotMemory = Mman.NoTransitions.mmap(WordFactory.nullPointer(), gotPageAlignedSize, Mman.PROT_READ() | Mman.PROT_WRITE(), Mman.MAP_SHARED(), fd, 0L);
        if (gotMemory.isNull()) {
            Unistd.NoTransitions.close(fd);
            return 27;
        }
        Pointer gotStartInMemory = gotMemory.add(LinuxGOTHeapSupport.getGotOffsetFromStartOfMapping());
        LibC.memcpy(gotStartInMemory, IMAGE_GOT_BEGIN.get(), LinuxGOTHeapSupport.getGotSectionSize());
        memoryViewFd.get().write((WordBase)WordFactory.signed((int)fd));
        gotStartAddress.write((WordBase)gotMemory);
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int mapGot(Pointer start) {
        SignedWord memViewFd = (SignedWord)memoryViewFd.get().read();
        if (memViewFd.lessThan(0)) {
            return 30;
        }
        Pointer mappedAddress = VirtualMemoryProvider.get().mapFile((PointerBase)start, LinuxGOTHeapSupport.getPageAlignedGotSize(), (WordBase)memViewFd, (UnsignedWord)WordFactory.zero(), 1);
        if (mappedAddress.isNull()) {
            return 28;
        }
        return 0;
    }
}

