/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.pltgot;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.code.DynamicMethodAddressResolutionHeapSupport;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.PauseNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class GOTHeapSupport
extends DynamicMethodAddressResolutionHeapSupport {
    public static final String IMAGE_GOT_END_SYMBOL_NAME = "__svm_got_end";
    public static final CGlobalData<Pointer> IMAGE_GOT_END = CGlobalDataFactory.forSymbol("__svm_got_end");
    public static final String IMAGE_GOT_BEGIN_SYMBOL_NAME = "__svm_got_begin";
    public static final CGlobalData<Pointer> IMAGE_GOT_BEGIN = CGlobalDataFactory.forSymbol("__svm_got_begin");
    private static final SignedWord GOT_UNINITIALIZED = WordFactory.signed((int)-1);
    private static final SignedWord GOT_INITIALIZATION_IN_PROGRESS = WordFactory.signed((int)-2);
    private static final CGlobalData<Pointer> GOT_STATUS = CGlobalDataFactory.createWord((WordBase)GOT_UNINITIALIZED);
    static final CGlobalData<WordPointer> GOT_START_ADDRESS = CGlobalDataFactory.createWord();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getGotSectionSize() {
        return IMAGE_GOT_END.get().subtract((UnsignedWord)IMAGE_GOT_BEGIN.get());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getPageAlignedGotSize() {
        UnsignedWord gotSectionSize = GOTHeapSupport.getGotSectionSize();
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        return PointerUtils.roundUp((PointerBase)gotSectionSize, pageSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getGotOffsetFromStartOfMapping() {
        return GOTHeapSupport.getPageAlignedGotSize().subtract(GOTHeapSupport.getGotSectionSize());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getRequiredPreHeapMemoryInBytes() {
        return GOTHeapSupport.getPageAlignedGotSize();
    }

    @Fold
    public static GOTHeapSupport get() {
        return (GOTHeapSupport)ImageSingletons.lookup(DynamicMethodAddressResolutionHeapSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void makeGOTWritable() {
        GOTHeapSupport.changeGOTMappingProtection(true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void makeGOTReadOnly() {
        GOTHeapSupport.changeGOTMappingProtection(false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract int mapGot(Pointer var1);

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int install(Pointer heapBase) {
        return this.mapGot(this.getPreHeapMappingStartAddress((PointerBase)heapBase));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Pointer getPreHeapMappingStartAddress() {
        return this.getPreHeapMappingStartAddress((PointerBase)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Pointer getPreHeapMappingStartAddress(PointerBase heapBase) {
        return ((Pointer)heapBase).subtract(this.getRequiredPreHeapMemoryInBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void changeGOTMappingProtection(boolean writable) {
        int ret;
        Pointer gotMappingStartAddress = (Pointer)GOT_START_ADDRESS.get().read();
        VMError.guarantee(gotMappingStartAddress.isNonNull());
        int access = 1;
        if (writable) {
            access |= 2;
        }
        VMError.guarantee((ret = VirtualMemoryProvider.get().protect((PointerBase)gotMappingStartAddress, GOTHeapSupport.getPageAlignedGotSize(), access)) == 0, "Failed to change GOT protection.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int initialize() {
        boolean isFirstIsolate = GOT_STATUS.get().logicCompareAndSwapWord(0, (WordBase)GOT_UNINITIALIZED, (WordBase)GOT_INITIALIZATION_IN_PROGRESS, LocationIdentity.ANY_LOCATION);
        if (!isFirstIsolate) {
            while (true) {
                SignedWord status;
                if ((status = (SignedWord)GOT_STATUS.get().readWordVolatile(0, LocationIdentity.ANY_LOCATION)).notEqual(GOT_INITIALIZATION_IN_PROGRESS)) {
                    long rawStatus = status.rawValue();
                    assert (rawStatus == (long)((int)rawStatus));
                    return (int)rawStatus;
                }
                PauseNode.pause();
            }
        }
        int ret = this.initialize(GOT_START_ADDRESS.get());
        if (ret == 0) {
            this.makeGOTReadOnly();
        }
        GOT_STATUS.get().writeWordVolatile(0, (WordBase)WordFactory.signed((int)ret));
        return ret;
    }

    protected abstract int initialize(WordPointer var1);
}

