/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_MethodHandle;
import com.oracle.svm.core.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.core.methodhandles.Util_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import jdk.internal.reflect.FieldAccessor;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

final class Util_java_lang_invoke_MethodHandle {
    Util_java_lang_invoke_MethodHandle() {
    }

    static Object linkTo(Object ... args) throws Throwable {
        assert (args.length > 0);
        Target_java_lang_invoke_MemberName memberName = (Target_java_lang_invoke_MemberName)args[args.length - 1];
        MethodType methodType = memberName.getInvocationType();
        return MethodHandleUtils.cast(Util_java_lang_invoke_MethodHandle.invokeInternal(memberName, methodType, Arrays.copyOf(args, args.length - 1)), methodType.returnType());
    }

    static Object invokeInternal(Target_java_lang_invoke_MemberName memberName, MethodType methodType, Object ... args) throws Throwable {
        if (memberName.reflectAccess == null && memberName.intrinsic == null) {
            Util_java_lang_invoke_MethodHandleNatives.resolve(memberName, null, false);
        }
        if (memberName.intrinsic != null) {
            VMError.guarantee(memberName.reflectAccess == null);
            return memberName.intrinsic.execute(args);
        }
        try {
            byte refKind = memberName.getReferenceKind();
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField) {
                Util_java_lang_invoke_MethodHandle.checkArgs(args, 1, "getField");
                Object receiver = args[0];
                FieldAccessor field = Util_java_lang_invoke_MethodHandle.asField(memberName, false);
                return field.get(receiver);
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic) {
                Util_java_lang_invoke_MethodHandle.checkArgs(args, 0, "getStatic");
                FieldAccessor field = Util_java_lang_invoke_MethodHandle.asField(memberName, true);
                return field.get(null);
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putField) {
                Util_java_lang_invoke_MethodHandle.checkArgs(args, 2, "putField");
                Object receiver = args[0];
                Object value = args[1];
                FieldAccessor field = Util_java_lang_invoke_MethodHandle.asField(memberName, false);
                field.set(receiver, value);
                return null;
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putStatic) {
                Util_java_lang_invoke_MethodHandle.checkArgs(args, 1, "putStatic");
                Object value = args[0];
                FieldAccessor field = Util_java_lang_invoke_MethodHandle.asField(memberName, true);
                field.set(null, value);
                return null;
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeVirtual || refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeInterface) {
                Util_java_lang_invoke_MethodHandle.convertArgs(args, methodType);
                Object receiver = args[0];
                Object[] invokeArgs = Arrays.copyOfRange(args, 1, args.length);
                SubstrateMethodAccessor method = Util_java_lang_invoke_MethodHandle.asMethod(memberName, false);
                return method.invoke(receiver, invokeArgs);
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeStatic) {
                Util_java_lang_invoke_MethodHandle.convertArgs(args, methodType);
                SubstrateMethodAccessor method = Util_java_lang_invoke_MethodHandle.asMethod(memberName, true);
                return method.invoke(null, args);
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeSpecial) {
                Util_java_lang_invoke_MethodHandle.convertArgs(args, methodType);
                Object receiver = args[0];
                Object[] invokeArgs = Arrays.copyOfRange(args, 1, args.length);
                SubstrateAccessor accessor = Util_java_lang_invoke_MethodHandle.getAccessor(memberName);
                Object returnValue = accessor.invokeSpecial(receiver, invokeArgs);
                return methodType.returnType() == Void.TYPE ? null : returnValue;
            }
            if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_newInvokeSpecial) {
                Util_java_lang_invoke_MethodHandle.convertArgs(args, methodType);
                SubstrateConstructorAccessor constructor = Util_java_lang_invoke_MethodHandle.asConstructor(memberName);
                return constructor.newInstance(args);
            }
            throw VMError.shouldNotReachHere("Unknown method handle reference kind: " + refKind);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static FieldAccessor asField(Target_java_lang_invoke_MemberName memberName, boolean isStatic) {
        VMError.guarantee(memberName.isField(), "Cannot perform field operations on an executable");
        Field field = (Field)memberName.reflectAccess;
        Util_java_lang_invoke_MethodHandle.checkMember(field, isStatic);
        return Util_java_lang_invoke_MethodHandle.getFieldAccessor(field);
    }

    private static FieldAccessor getFieldAccessor(Field field) {
        return SubstrateUtil.cast(SubstrateUtil.cast(field, Target_java_lang_reflect_Field.class).acquireOverrideFieldAccessor(), FieldAccessor.class);
    }

    private static SubstrateMethodAccessor asMethod(Target_java_lang_invoke_MemberName memberName, boolean isStatic) {
        VMError.guarantee(memberName.isMethod(), "Cannot perform method operations on a field or constructor");
        Method method = (Method)memberName.reflectAccess;
        Util_java_lang_invoke_MethodHandle.checkMember(method, isStatic);
        return Util_java_lang_invoke_MethodHandle.getMethodAccessor(method);
    }

    private static SubstrateMethodAccessor getMethodAccessor(Method method) {
        Target_java_lang_reflect_Method internalMethod = SubstrateUtil.cast(method, Target_java_lang_reflect_Method.class);
        Target_jdk_internal_reflect_MethodAccessor methodAccessor = internalMethod.methodAccessor;
        Target_jdk_internal_reflect_MethodAccessor result = methodAccessor == null ? internalMethod.acquireMethodAccessor() : methodAccessor;
        return SubstrateUtil.cast(result, SubstrateMethodAccessor.class);
    }

    private static SubstrateConstructorAccessor asConstructor(Target_java_lang_invoke_MemberName memberName) {
        VMError.guarantee(memberName.isConstructor(), "Cannot perform constructor operations on a field or constructor");
        Constructor constructor = (Constructor)memberName.reflectAccess;
        return Util_java_lang_invoke_MethodHandle.getConstructorAccessor(constructor);
    }

    private static SubstrateConstructorAccessor getConstructorAccessor(Constructor<?> constructor) {
        return SubstrateUtil.cast(SubstrateUtil.cast(constructor, Target_java_lang_reflect_Constructor.class).acquireConstructorAccessor(), SubstrateConstructorAccessor.class);
    }

    private static <T extends AccessibleObject> void checkMember(T member, boolean isStatic) {
        VMError.guarantee(Modifier.isStatic(((Member)((Object)member)).getModifiers()) == isStatic, "Cannot perform %s operation on a %s member".formatted(isStatic ? "static" : "non-static", isStatic ? "non-static" : "static"));
    }

    private static SubstrateAccessor getAccessor(Target_java_lang_invoke_MemberName memberName) {
        VMError.guarantee(memberName.isInvocable(), "Cannot perform invokeSpecial on a field");
        return memberName.isMethod() ? Util_java_lang_invoke_MethodHandle.getMethodAccessor((Method)memberName.reflectAccess) : Util_java_lang_invoke_MethodHandle.getConstructorAccessor((Constructor)memberName.reflectAccess);
    }

    private static void checkArgs(Object[] args, int expectedLength, String methodName) {
        VMError.guarantee(expectedLength == 0 && args == null || args.length == expectedLength, "%s requires exactly %d arguments".formatted(methodName, expectedLength));
    }

    private static void convertArgs(Object[] args, MethodType methodType) throws Throwable {
        assert (args.length == methodType.parameterCount());
        for (int i = 0; i < args.length; ++i) {
            Wrapper srcWrapper;
            Wrapper destWrapper;
            TypeDescriptor.OfField expectedParamType = methodType.parameterType(i);
            if (!((Class)expectedParamType).isPrimitive() || (destWrapper = Wrapper.forPrimitiveType(expectedParamType)) == (srcWrapper = Wrapper.forWrapperType(args[i].getClass()))) continue;
            Target_java_lang_invoke_MethodHandle typeConverter = SubstrateUtil.cast(ValueConversions.convertPrimitive(srcWrapper, destWrapper), Target_java_lang_invoke_MethodHandle.class);
            args[i] = typeConverter.invokeBasic(args[i]);
        }
    }
}

