/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.JNIOnLoadFunctionPointer;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jni.headers.JNIVersion;
import com.oracle.svm.core.util.ImageHeapMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class JNILibraryInitializer
implements NativeLibrarySupport.LibraryInitializer {
    private final EconomicMap<String, CGlobalData<PointerBase>> onLoadCGlobalDataMap = ImageHeapMap.create(Equivalence.IDENTITY);

    private static String getOnLoadName(String libName, boolean isBuiltIn) {
        String name = "JNI_OnLoad";
        if (isBuiltIn) {
            return name + "_" + libName;
        }
        return name;
    }

    public boolean fillCGlobalDataMap(Collection<String> staticLibNames) {
        List<String> libsWithOnLoad = Arrays.asList("net", "java", "nio", "zip", "sunec", "jaas", "sctp", "extnet", "j2gss", "j2pkcs11", "j2pcsc", "prefs", "verify", "awt", "awt_xawt", "awt_headless", "lcms", "fontmanager", "javajpeg", "mlib_image");
        ArrayList<String> localStaticLibNames = new ArrayList<String>(staticLibNames);
        localStaticLibNames.retainAll(libsWithOnLoad);
        if (Platform.includedIn(Platform.WINDOWS.class)) {
            localStaticLibNames.remove("extnet");
        }
        boolean mapIsChanged = false;
        for (String libName : localStaticLibNames) {
            if (this.onLoadCGlobalDataMap.containsKey((Object)libName)) continue;
            CGlobalData onLoadCGlobalData = CGlobalDataFactory.forSymbol(JNILibraryInitializer.getOnLoadName(libName, true), true);
            this.onLoadCGlobalDataMap.put((Object)libName, onLoadCGlobalData);
            mapIsChanged = true;
        }
        return mapIsChanged;
    }

    @Override
    public boolean isBuiltinLibrary(String libName) {
        if (PlatformNativeLibrarySupport.singleton().isBuiltinLibrary(libName)) {
            return true;
        }
        String onLoadName = JNILibraryInitializer.getOnLoadName(libName, true);
        PointerBase onLoad = PlatformNativeLibrarySupport.singleton().findBuiltinSymbol(onLoadName);
        return onLoad.isNonNull();
    }

    @Override
    public void initialize(PlatformNativeLibrarySupport.NativeLibrary lib) {
        JNIOnLoadFunctionPointer onLoad;
        int expected;
        PointerBase onLoadFunction;
        String libName = lib.getCanonicalIdentifier();
        if (lib.isBuiltin()) {
            onLoadFunction = this.getOnLoadSymbolAddress(libName);
            if (onLoadFunction.isNull() && (onLoadFunction = lib.findSymbol(symbolName = JNILibraryInitializer.getOnLoadName(libName, true))).isNull()) {
                throw new UnsatisfiedLinkError("Missing mandatory function for statically linked JNI library: " + symbolName);
            }
        } else {
            symbolName = JNILibraryInitializer.getOnLoadName(libName, false);
            onLoadFunction = lib.findSymbol(symbolName);
        }
        if (onLoadFunction.isNonNull() && !JNIVersion.isSupported(expected = (onLoad = (JNIOnLoadFunctionPointer)onLoadFunction).invoke(JNIFunctionTables.singleton().getGlobalJavaVM(), (VoidPointer)WordFactory.nullPointer()), lib.isBuiltin())) {
            throw new UnsatisfiedLinkError("Unsupported JNI version 0x" + Integer.toHexString(expected) + ", required by " + libName);
        }
    }

    private PointerBase getOnLoadSymbolAddress(String libName) {
        CGlobalData symbol = (CGlobalData)this.onLoadCGlobalDataMap.get((Object)libName);
        return symbol == null ? WordFactory.nullPointer() : symbol.get();
    }
}

