/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.handles.ObjectHandlesImpl;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIObjectRefType;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

final class JNIGlobalHandles {
    static final SignedWord MIN_VALUE = WordFactory.signed((long)Long.MIN_VALUE);
    static final SignedWord MAX_VALUE = JNIObjectHandles.nullHandle().subtract(1);
    private static final int HANDLE_BITS_COUNT = 31;
    private static final SignedWord HANDLE_BITS_MASK;
    private static final int VALIDATION_BITS_SHIFT = 31;
    private static final int VALIDATION_BITS_COUNT = 32;
    private static final SignedWord VALIDATION_BITS_MASK;
    private static final SignedWord MSB;
    private static final ObjectHandlesImpl globalHandles;

    JNIGlobalHandles() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isInRange(JNIObjectHandle handle) {
        return MIN_VALUE.lessOrEqual((SignedWord)handle) && MAX_VALUE.greaterThan((SignedWord)handle);
    }

    private static Word isolateHash() {
        int isolateHash = Long.hashCode(CurrentIsolate.getIsolate().rawValue());
        return (Word)WordFactory.unsigned((int)isolateHash);
    }

    private static JNIObjectHandle encode(ObjectHandle handle) {
        Word h = (Word)handle;
        if (JNIObjectHandles.haveAssertions()) {
            assert (h.and(HANDLE_BITS_MASK).equal((SignedWord)h)) : "unencoded handle must fit in range";
            Word v = JNIGlobalHandles.isolateHash().shiftLeft(31);
            assert (v.and(VALIDATION_BITS_MASK).equal(v)) : "validation value must fit in its range";
            h = h.or((SignedWord)v);
        }
        h = h.or(MSB);
        assert (JNIGlobalHandles.isInRange((JNIObjectHandle)h));
        return (JNIObjectHandle)h;
    }

    private static ObjectHandle decode(JNIObjectHandle handle) {
        assert (JNIGlobalHandles.isInRange(handle));
        assert (((Word)handle).and(VALIDATION_BITS_MASK).unsignedShiftRight(31).equal(JNIGlobalHandles.isolateHash())) : "mismatching validation value -- passed a handle from a different isolate?";
        return (ObjectHandle)HANDLE_BITS_MASK.and((SignedWord)((Word)handle));
    }

    static <T> T getObject(JNIObjectHandle handle) {
        return globalHandles.get(JNIGlobalHandles.decode(handle));
    }

    static JNIObjectRefType getHandleType(JNIObjectHandle handle) {
        assert (JNIGlobalHandles.isInRange(handle));
        if (globalHandles.isWeak(JNIGlobalHandles.decode(handle))) {
            return JNIObjectRefType.WeakGlobal;
        }
        return JNIObjectRefType.Global;
    }

    static JNIObjectHandle create(Object obj) {
        return JNIGlobalHandles.encode(globalHandles.create(obj));
    }

    static void destroy(JNIObjectHandle handle) {
        globalHandles.destroy(JNIGlobalHandles.decode(handle));
    }

    static JNIObjectHandle createWeak(Object obj) {
        return JNIGlobalHandles.encode(globalHandles.createWeak(obj));
    }

    static void destroyWeak(JNIObjectHandle weakRef) {
        globalHandles.destroyWeak(JNIGlobalHandles.decode(weakRef));
    }

    public static long computeCurrentCount() {
        return globalHandles.computeCurrentCount();
    }

    static {
        assert (JNIObjectHandles.nullHandle().equal((SignedWord)WordFactory.zero()));
        HANDLE_BITS_MASK = WordFactory.signed((long)Integer.MAX_VALUE);
        VALIDATION_BITS_MASK = WordFactory.signed((long)0xFFFFFFFFL).shiftLeft(31);
        MSB = WordFactory.signed((long)Long.MIN_VALUE);
        globalHandles = new ObjectHandlesImpl(JNIObjectHandles.nullHandle().add(1), HANDLE_BITS_MASK, (SignedWord)JNIObjectHandles.nullHandle());
    }
}

