/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.oldobject;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.collections.UninterruptibleLinkedList;
import com.oracle.svm.core.collections.UninterruptiblePriorityQueue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.OldObjectSampleEvent;
import com.oracle.svm.core.jfr.oldobject.JfrOldObject;
import com.oracle.svm.core.thread.JavaThreads;
import org.graalvm.word.UnsignedWord;

final class JfrOldObjectSampler {
    private final UninterruptiblePriorityQueue queue;
    private final UninterruptibleLinkedList usedList;
    private final UninterruptibleLinkedList freeList;
    private UnsignedWord totalAllocated;
    private UnsignedWord totalInQueue;

    JfrOldObjectSampler(int queueSize) {
        this.queue = new UninterruptiblePriorityQueue(new JfrOldObject[queueSize]);
        this.usedList = new UninterruptibleLinkedList();
        this.freeList = new UninterruptibleLinkedList();
        for (int i = 0; i < queueSize; ++i) {
            this.freeList.append(new JfrOldObject());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean sample(Object obj, UnsignedWord allocatedSize, int arrayLength) {
        this.totalAllocated = this.totalAllocated.add(allocatedSize);
        UnsignedWord span = this.totalAllocated.subtract(this.totalInQueue);
        if (this.queue.isFull()) {
            assert (this.freeList.isEmpty());
            JfrOldObject peek = this.getObjectWithSmallestSpan();
            if (peek.getSpan().aboveThan(span)) {
                int numDead = this.scavenge();
                if (numDead == 0) {
                    return false;
                }
            } else {
                this.evict();
            }
        }
        this.store(obj, span, allocatedSize, arrayLength);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int scavenge() {
        int numDead = 0;
        JfrOldObject cur = this.getOldestObject();
        while (cur != null) {
            JfrOldObject next = (JfrOldObject)cur.getNext();
            if (!cur.isAlive()) {
                this.remove(cur);
                ++numDead;
            }
            cur = next;
        }
        return numDead;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void remove(JfrOldObject sample) {
        JfrOldObject next = (JfrOldObject)sample.getNext();
        if (next != null) {
            this.queue.remove(next);
            next.increaseSpan(sample.getSpan());
            this.queue.add(next);
        } else {
            this.totalInQueue = this.totalInQueue.subtract(sample.getSpan());
            assert (this.totalInQueue.aboveOrEqual(0));
        }
        this.queue.remove(sample);
        this.release(sample);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void evict() {
        JfrOldObject sample = (JfrOldObject)this.queue.poll();
        this.release(sample);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void release(JfrOldObject sample) {
        this.usedList.remove(sample);
        this.freeList.append(sample);
        sample.reset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void store(Object obj, UnsignedWord span, UnsignedWord allocatedSize, int arrayLength) {
        Thread thread = JavaThreads.getCurrentThreadOrNull();
        long threadId = thread == null ? 0L : JavaThreads.getThreadId(thread);
        long stackTraceId = thread == null ? 0L : SubstrateJVM.get().getStackTraceId(JfrEvent.OldObjectSample, 0);
        UnsignedWord heapUsedAfterLastGC = Heap.getHeap().getUsedMemoryAfterLastGC();
        JfrOldObject sample = (JfrOldObject)this.freeList.pop();
        sample.initialize(obj, span, allocatedSize, threadId, stackTraceId, heapUsedAfterLastGC, arrayLength);
        this.queue.add(sample);
        this.usedList.append(sample);
        this.totalInQueue = this.totalInQueue.add(span);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void emit(long cutoff, boolean emitAll, boolean skipBFS) {
        if (cutoff <= 0L) {
            this.emitUnchained();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void emitUnchained() {
        long startTicks = JfrTicks.elapsedTicks();
        for (JfrOldObject cur = this.getOldestObject(); cur != null; cur = (JfrOldObject)cur.getNext()) {
            Object obj = cur.getReferent();
            if (obj == null) continue;
            long objectId = SubstrateJVM.getOldObjectRepository().serializeOldObject(obj);
            UnsignedWord objectSize = cur.getObjectSize();
            long allocationTicks = cur.getAllocationTicks();
            long threadId = cur.getThreadId();
            long stackTraceId = cur.getStackTraceId();
            UnsignedWord heapUsedAfterLastGC = cur.getHeapUsedAfterLastGC();
            int arrayLength = cur.getArrayLength();
            OldObjectSampleEvent.emit(startTicks, objectId, objectSize, allocationTicks, threadId, stackTraceId, heapUsedAfterLastGC, arrayLength);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    JfrOldObject getOldestObject() {
        return (JfrOldObject)this.usedList.getHead();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private JfrOldObject getObjectWithSmallestSpan() {
        return (JfrOldObject)this.queue.peek();
    }
}

