/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrArgumentParser;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_dcmd_AbstractDCmd;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_dcmd_DCmdStart;
import com.oracle.svm.core.jfr.events.EndChunkNativePeriodicEvents;
import com.oracle.svm.core.jfr.events.EveryChunkNativePeriodicEvents;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.jfr.FlightRecorder;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrManager {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    final boolean hostedEnabled;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrManager(boolean hostedEnabled) {
        this.hostedEnabled = hostedEnabled;
    }

    @Fold
    public static JfrManager get() {
        return (JfrManager)ImageSingletons.lookup(JfrManager.class);
    }

    public static RuntimeSupport.Hook initializationHook() {
        return isFirstIsolate -> {
            JfrManager.parseFlightRecorderLogging();
            JfrManager.parseFlightRecorderOptions();
        };
    }

    public static RuntimeSupport.Hook startupHook() {
        return isFirstIsolate -> {
            boolean startRecording;
            JfrManager.periodicEventSetup();
            boolean bl = startRecording = SubstrateOptions.FlightRecorder.getValue() != false || !SubstrateOptions.StartFlightRecording.getValue().isEmpty();
            if (startRecording) {
                JfrManager.initRecording();
            }
        };
    }

    private static void parseFlightRecorderOptions() throws JfrArgumentParser.JfrArgumentParsingFailed {
        Map<JfrArgumentParser.JfrArgument, String> optionsArgs = JfrArgumentParser.parseJfrOptions(SubstrateOptions.FlightRecorderOptions, (JfrArgumentParser.JfrArgument[])JfrArgumentParser.FlightRecorderOptionsArgument.values());
        Long globalBufferSize = JfrArgumentParser.parseMaxSize(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.GlobalBufferSize);
        Long maxChunkSize = JfrArgumentParser.parseMaxSize(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.MaxChunkSize);
        Long memorySize = JfrArgumentParser.parseMaxSize(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.MemorySize);
        Integer oldObjectQueueSize = JfrArgumentParser.parseInteger(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.OldObjectQueueSize);
        String repositoryPath = optionsArgs.get(JfrArgumentParser.FlightRecorderOptionsArgument.RepositoryPath);
        Integer stackDepth = JfrArgumentParser.parseInteger(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.StackDepth);
        Boolean preserveRepository = JfrArgumentParser.parseBoolean(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.PreserveRepository);
        Long threadBufferSize = JfrArgumentParser.parseMaxSize(optionsArgs, JfrArgumentParser.FlightRecorderOptionsArgument.ThreadBufferSize);
        if (globalBufferSize != null) {
            Options.setGlobalBufferSize(globalBufferSize);
        }
        if (maxChunkSize != null) {
            Options.setMaxChunkSize(maxChunkSize);
        }
        if (memorySize != null) {
            Options.setMemorySize(memorySize);
        }
        if (oldObjectQueueSize != null) {
            if (oldObjectQueueSize >= 0) {
                SubstrateJVM.getOldObjectProfiler().configure(oldObjectQueueSize);
            } else {
                throw new JfrArgumentParser.JfrArgumentParsingFailed(JfrArgumentParser.FlightRecorderOptionsArgument.OldObjectQueueSize.getCmdLineKey() + " must be greater or equal 0.");
            }
        }
        if (repositoryPath != null) {
            try {
                SecuritySupport.SafePath repositorySafePath = new SecuritySupport.SafePath(repositoryPath);
                Repository.getRepository().setBasePath(repositorySafePath);
            }
            catch (Throwable e) {
                throw new JfrArgumentParser.JfrArgumentParsingFailed("Could not use " + repositoryPath + " as repository. " + e.getMessage(), e);
            }
        }
        if (stackDepth != null) {
            Options.setStackDepth(stackDepth);
        }
        if (preserveRepository != null) {
            Options.setPreserveRepository(preserveRepository);
        }
        if (threadBufferSize != null) {
            Options.setThreadBufferSize(threadBufferSize);
        }
    }

    public static RuntimeSupport.Hook shutdownHook() {
        return isFirstIsolate -> {
            FlightRecorder.removePeriodicEvent(EveryChunkNativePeriodicEvents::emit);
            FlightRecorder.removePeriodicEvent(EndChunkNativePeriodicEvents::emit);
        };
    }

    private static void parseFlightRecorderLogging() {
        String option = SubstrateOptions.FlightRecorderLogging.getValue();
        SubstrateJVM.getLogging().parseConfiguration(option);
    }

    private static void periodicEventSetup() throws SecurityException {
        FlightRecorder.addPeriodicEvent(EveryChunkNativePeriodicEvents.class, EveryChunkNativePeriodicEvents::emit);
        FlightRecorder.addPeriodicEvent(EndChunkNativePeriodicEvents.class, EndChunkNativePeriodicEvents::emit);
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/jfr/dcmd/jfrDcmds.cpp#L219-L247"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/jfr/dcmd/jfrDcmds.cpp#L146-L180"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/jfr/dcmd/jfrDcmds.cpp#L130-L144")})
    private static void initRecording() {
        Target_jdk_jfr_internal_dcmd_DCmdStart cmd = new Target_jdk_jfr_internal_dcmd_DCmdStart();
        CharSequence[] result = SubstrateUtil.cast(cmd, Target_jdk_jfr_internal_dcmd_AbstractDCmd.class).execute("internal", SubstrateOptions.StartFlightRecording.getValue(), ',');
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, String.join((CharSequence)System.lineSeparator(), result));
    }
}

