/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.jdk.BacktraceDecoder;
import java.util.ArrayList;

final class StackTraceBuilder
extends BacktraceDecoder {
    private final ArrayList<StackTraceElement> trace = new ArrayList();

    StackTraceBuilder() {
    }

    static StackTraceElement[] build(long[] backtrace) {
        StackTraceBuilder stackTraceBuilder = new StackTraceBuilder();
        stackTraceBuilder.visitBacktrace(backtrace, Integer.MAX_VALUE, SubstrateOptions.maxJavaStackTraceDepth());
        return stackTraceBuilder.trace.toArray(new StackTraceElement[0]);
    }

    @Override
    protected void processSourceReference(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber) {
        StackTraceElement sourceReference = FrameSourceInfo.getSourceReference(sourceClass, sourceMethodName, sourceLineNumber);
        this.trace.add(sourceReference);
    }
}

