/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.riscv64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.nativeimage.Platform;

public class SubstrateRISCV64RegisterConfig
implements SubstrateRegisterConfig {
    private final TargetDescription target;
    private final int nativeParamsStackOffset;
    private final RegisterArray generalParameterRegs;
    private final RegisterArray fpParameterRegs;
    private final RegisterArray allocatableRegs;
    private final RegisterArray calleeSaveRegisters;
    private final RegisterAttributes[] attributesMap;
    private final MetaAccessProvider metaAccess;

    public SubstrateRISCV64RegisterConfig(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, boolean preserveFramePointer) {
        this.target = target;
        this.metaAccess = metaAccess;
        this.generalParameterRegs = new RegisterArray(new Register[]{RISCV64.x10, RISCV64.x11, RISCV64.x12, RISCV64.x13, RISCV64.x14, RISCV64.x15, RISCV64.x16, RISCV64.x17});
        this.fpParameterRegs = new RegisterArray(new Register[]{RISCV64.f10, RISCV64.f11, RISCV64.f12, RISCV64.f13, RISCV64.f14, RISCV64.f15, RISCV64.f16, RISCV64.f17});
        this.nativeParamsStackOffset = 0;
        ArrayList regs = new ArrayList(RISCV64.allRegisters.asList());
        regs.remove(RISCV64.x2);
        regs.remove(RISCV64.x0);
        if (preserveFramePointer) {
            regs.remove(RISCV64.x8);
        }
        regs.remove(ReservedRegisters.singleton().getHeapBaseRegister());
        regs.remove(ReservedRegisters.singleton().getThreadRegister());
        regs.remove(RISCV64.x1);
        regs.remove(RISCV64.x3);
        this.allocatableRegs = new RegisterArray(regs);
        switch (config) {
            case NORMAL: {
                this.calleeSaveRegisters = new RegisterArray(new Register[0]);
                break;
            }
            case NATIVE_TO_JAVA: {
                this.calleeSaveRegisters = new RegisterArray(new Register[]{RISCV64.x2, RISCV64.x8, RISCV64.x9, RISCV64.x18, RISCV64.x19, RISCV64.x20, RISCV64.x21, RISCV64.x22, RISCV64.x23, RISCV64.x24, RISCV64.x25, RISCV64.x26, RISCV64.x27, RISCV64.f8, RISCV64.f9, RISCV64.f18, RISCV64.f19, RISCV64.f20, RISCV64.f21, RISCV64.f22, RISCV64.f23, RISCV64.f24, RISCV64.f25, RISCV64.f26, RISCV64.f27});
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)config);
            }
        }
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)RISCV64.allRegisters);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: 
            case Object: {
                return RISCV64.x10;
            }
            case Float: 
            case Double: {
                return RISCV64.f10;
            }
            case Void: {
                return null;
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(kind);
    }

    public RegisterArray getAllocatableRegisters() {
        return this.allocatableRegs;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return this.calleeSaveRegisters;
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.getAllocatableRegisters();
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return true;
    }

    public RegisterAttributes[] getAttributesMap() {
        return this.attributesMap;
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type t, JavaKind kind) {
        throw VMError.intentionallyUnimplemented();
    }

    private int javaStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        ValueKind valueKind = valueKindFactory.getValueKind(kind.getStackKind());
        int alignment = Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        locations[index] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return currentStackOffset + alignment;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type t, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        SubstrateCallingConventionType type = (SubstrateCallingConventionType)t;
        if (type.fixedParameterAssignment != null || type.returnSaving != null) {
            throw VMError.unsupportedFeature("Fixed parameter assignments and return saving are not yet supported on this platform.");
        }
        boolean isEntryPoint = type.nativeABI() && !type.outgoing;
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentFP = 0;
        int currentStackOffset = type.nativeABI() ? this.nativeParamsStackOffset : this.target.wordSize;
        JavaKind[] kinds = new JavaKind[locations.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind;
            kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, parameterTypes[i], this.metaAccess, this.target);
            Register register = null;
            if (type.kind == SubstrateCallingConventionKind.ForwardReturnValue) {
                VMError.guarantee(i == 0, "Method with calling convention ForwardReturnValue cannot have more than one parameter");
                register = this.getReturnRegister(kind);
            } else {
                switch (kind) {
                    case Boolean: 
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Int: 
                    case Long: 
                    case Object: {
                        if (currentGeneral >= this.generalParameterRegs.size()) break;
                        register = this.generalParameterRegs.get(currentGeneral++);
                        break;
                    }
                    case Float: 
                    case Double: {
                        if (currentFP >= this.fpParameterRegs.size()) break;
                        register = this.fpParameterRegs.get(currentFP++);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHereUnexpectedInput(kind);
                    }
                }
            }
            if (register != null) {
                boolean useJavaKind = isEntryPoint && Platform.includedIn(Platform.LINUX.class);
                locations[i] = register.asValue(valueKindFactory.getValueKind(useJavaKind ? kind : kind.getStackKind()));
                continue;
            }
            if (type.nativeABI()) {
                if (Platform.includedIn(Platform.LINUX.class)) {
                    ValueKind valueKind = valueKindFactory.getValueKind(type.outgoing ? kind.getStackKind() : kind);
                    int alignment = Math.max(kind.getByteCount(), this.target.wordSize);
                    locations[i] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!type.outgoing ? 1 : 0) != 0);
                    currentStackOffset += alignment;
                    continue;
                }
                throw VMError.unsupportedPlatform();
            }
            currentStackOffset = this.javaStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : ObjectLayout.getCallSignatureKind(isEntryPoint, returnType, this.metaAccess, this.target);
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new SubstrateCallingConvention(type, kinds, currentStackOffset, returnLocation, locations);
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        throw VMError.intentionallyUnimplemented();
    }
}

