/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.locale;

import com.oracle.svm.core.c.locale.LocaleDirectives;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

@CContext(value=LocaleDirectives.class)
@CLibrary(value="libchelper", requireStatic=true, dependsOn={"java"})
@BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+13/src/java.base/unix/native/libjava/locale_str.h"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+13/src/java.base/windows/native/libjava/locale_str.h")})
class LocaleCHelper {
    LocaleCHelper() {
    }

    @CConstant
    static native int SVM_LOCALE_INITIALIZATION_SUCCEEDED();

    @CConstant
    static native int SVM_LOCALE_INITIALIZATION_OUT_OF_MEMORY();

    @CFunction(value="svm_initialize_locale", transition=CFunction.Transition.NO_TRANSITION)
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+17/src/java.base/unix/native/libjava/java_props_md.c#L71-L357"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+17/src/java.base/unix/native/libjava/java_props_md.c#L436-L460"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+24/src/java.base/windows/native/libjava/java_props_md.c#L254-L713")})
    static native int initializeLocale();

    @CFunction(value="svm_get_locale", transition=CFunction.Transition.NO_TRANSITION)
    static native LocaleProps getLocale();

    @CStruct(value="svm_locale_props_t")
    static interface LocaleProps
    extends PointerBase {
        @CField(value="display_language")
        public CCharPointer displayLanguage();

        @CField(value="display_script")
        public CCharPointer displayScript();

        @CField(value="display_country")
        public CCharPointer displayCountry();

        @CField(value="display_variant")
        public CCharPointer displayVariant();

        @CField(value="format_language")
        public CCharPointer formatLanguage();

        @CField(value="format_script")
        public CCharPointer formatScript();

        @CField(value="format_country")
        public CCharPointer formatCountry();

        @CField(value="format_variant")
        public CCharPointer formatVariant();
    }
}

