/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.util.CPUTypeAArch64;
import com.oracle.svm.hosted.util.CPUTypeAMD64;
import com.oracle.svm.hosted.util.CPUTypeRISCV64;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.graalvm.nativeimage.Platform;

public interface CPUType {
    public String getName();

    public String getSpecificFeaturesString();

    public CPUType getParent();

    public static void printList() {
        String arch;
        switch (arch = SubstrateUtil.getArchitectureName()) {
            case "amd64": {
                CPUType.print("AMD64", CPUTypeAMD64.values());
                break;
            }
            case "aarch64": {
                CPUType.print("AArch64", CPUTypeAArch64.values());
                CPUTypeAArch64.printFeatureModifiers();
                break;
            }
            case "riscv64": {
                CPUType.print("RISCV64", CPUTypeRISCV64.values());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported platform: " + arch);
            }
        }
    }

    private static void print(String name, CPUType[] values) {
        Arrays.sort(values, Comparator.comparing(CPUType::getName));
        System.out.printf("On %s, the following machine types are available:%n%n", name);
        for (CPUType m : values) {
            Object parentText;
            String specificFeatures = m.getSpecificFeaturesString();
            if (m.getParent() != null) {
                Object object = parentText = m.getParent() == null ? "" : "all of '" + m.getParent().getName() + "'";
                if (!specificFeatures.isEmpty()) {
                    parentText = (String)parentText + " + ";
                }
            } else {
                parentText = "";
            }
            System.out.printf("'%s'%n  CPU features: %s%s%n", m.getName(), parentText, specificFeatures);
        }
        System.out.println();
    }

    public static String getSelectedOrDefaultMArch() {
        String userValue = NativeImageOptions.MicroArchitecture.getValue();
        if (userValue != null) {
            return userValue;
        }
        if (Platform.includedIn(Platform.AMD64.class)) {
            return CPUTypeAMD64.getDefaultName(false);
        }
        if (Platform.includedIn(Platform.AARCH64.class)) {
            return CPUTypeAArch64.getDefaultName(false);
        }
        if (Platform.includedIn(Platform.RISCV64.class)) {
            return CPUTypeRISCV64.getDefaultName();
        }
        return "unknown";
    }

    public static List<String> toNames(CPUType[] values) {
        return Arrays.stream(values).map(CPUType::getName).toList();
    }
}

