/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LayerArchiveSupport {
    protected static final String MODULE_OPTION = "module";
    protected static final String PACKAGE_OPTION = "package";
    private static final int LAYER_FILE_FORMAT_VERSION_MAJOR = 0;
    private static final int LAYER_FILE_FORMAT_VERSION_MINOR = 1;
    protected static final String LAYER_INFO_MESSAGE_PREFIX = "Native Image Layers";
    protected static final String LAYER_TEMP_DIR_PREFIX = "layerRoot-";
    protected static final String LAYER_FILE_EXTENSION = ".nil";
    protected final LayerProperties layerProperties;
    protected final ArchiveSupport archiveSupport;
    protected static final Path layerPropertiesFileName = Path.of("META-INF/nilayer.properties", new String[0]);

    public LayerArchiveSupport(ArchiveSupport archiveSupport) {
        this.archiveSupport = archiveSupport;
        this.layerProperties = new LayerProperties();
    }

    private static String platform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase(Locale.ROOT);
    }

    protected static void info(String format, Object ... args) {
        LogUtils.prefixInfo((String)LAYER_INFO_MESSAGE_PREFIX, (String)format, (Object[])args);
    }

    public final class LayerProperties {
        private static final String PROPERTY_KEY_LAYER_FILE_VERSION_MAJOR = "LayerFileVersionMajor";
        private static final String PROPERTY_KEY_LAYER_FILE_VERSION_MINOR = "LayerFileVersionMinor";
        private static final String PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP = "LayerFileCreationTimestamp";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_PLATFORM = "NativeImagePlatform";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_VENDOR = "NativeImageVendor";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_VERSION = "NativeImageVersion";
        private static final String PROPERTY_KEY_IMAGE_LAYER_NAME = "LayerName";
        private final Map<String, String> properties = new HashMap<String, String>();

        LayerProperties() {
        }

        void loadAndVerify(Path inputLayerLocation, Path expandedInputLayerDir) {
            Path layerFileName = inputLayerLocation.getFileName();
            Path layerPropertiesFile = expandedInputLayerDir.resolve(layerPropertiesFileName);
            if (!Files.isReadable(layerPropertiesFile)) {
                throw UserError.abort("The given layer file " + String.valueOf(layerFileName) + " does not contain a layer properties file", new Object[0]);
            }
            this.properties.putAll(ArchiveSupport.loadProperties(layerPropertiesFile));
            this.verifyVersion(layerFileName);
            String niVendor = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_VENDOR, "unknown");
            String javaVmVendor = System.getProperty("java.vm.vendor");
            Object currentVendor = niVendor.equals(javaVmVendor) ? "" : " != '" + javaVmVendor + "'";
            String niVersion = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_VERSION, "unknown");
            String javaVmVersion = System.getProperty("java.vm.version");
            Object currentVersion = niVersion.equals(javaVmVersion) ? "" : " != '" + javaVmVersion + "'";
            String niPlatform = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_PLATFORM, "unknown");
            Object currentPlatform = niPlatform.equals(LayerArchiveSupport.platform()) ? "" : " != '" + LayerArchiveSupport.platform() + "'";
            String layerCreationTimestamp = this.properties.getOrDefault(PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP, "");
            LayerArchiveSupport.info("Loaded layer from %s", layerFileName);
            LayerArchiveSupport.info("Layer created at '%s'", ArchiveSupport.parseTimestamp(layerCreationTimestamp));
            LayerArchiveSupport.info("Using version: '%s'%s (vendor '%s'%s) on platform: '%s'%s", niVersion, currentVersion, niVendor, currentVendor, niPlatform, currentPlatform);
        }

        private void verifyVersion(Path layerFileName) {
            String fileVersionKey = PROPERTY_KEY_LAYER_FILE_VERSION_MAJOR;
            try {
                int major = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                fileVersionKey = PROPERTY_KEY_LAYER_FILE_VERSION_MINOR;
                int minor = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                String message = String.format("The given layer file %s was created with a newer layer-file-format version %d.%d (current %d.%d). Update to the latest version of native-image.", layerFileName, major, minor, 0, 1);
                if (major > 0) {
                    throw UserError.abort(message, new Object[0]);
                }
                if (major == 0 && minor > 1) {
                    LogUtils.warning((String)message);
                }
            }
            catch (NumberFormatException e) {
                throw VMError.shouldNotReachHere(fileVersionKey + " in " + String.valueOf(layerPropertiesFileName) + " is missing or ill-defined", e);
            }
        }

        void write() {
            this.properties.put(PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP, ArchiveSupport.currentTime());
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_PLATFORM, LayerArchiveSupport.platform());
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_VENDOR, System.getProperty("java.vm.vendor"));
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_VERSION, System.getProperty("java.vm.version"));
            Path layerPropertiesFile = NativeImageGenerator.getOutputDirectory().resolve(layerPropertiesFileName);
            Path parent = layerPropertiesFile.getParent();
            if (parent == null) {
                throw VMError.shouldNotReachHere("The layer properties file " + String.valueOf(layerPropertiesFile) + " doesn't have a parent directory.");
            }
            LayerArchiveSupport.this.archiveSupport.ensureDirectoryExists(parent);
            try (OutputStream outputStream = Files.newOutputStream(layerPropertiesFile, new OpenOption[0]);){
                Properties p = new Properties();
                p.putAll(this.properties);
                p.store(outputStream, "Native Image Layer file properties");
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Creating layer properties file " + String.valueOf(layerPropertiesFile) + " failed", e);
            }
        }

        public void writeLayerName(String layerName) {
            this.properties.put(PROPERTY_KEY_IMAGE_LAYER_NAME, layerName);
        }

        public String layerName() {
            VMError.guarantee(!this.properties.isEmpty(), "Property file is no loaded.");
            String name = this.properties.get(PROPERTY_KEY_IMAGE_LAYER_NAME);
            VMError.guarantee(name != null, "Property LayerName must be set.");
            return name;
        }
    }
}

