/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.target.EncodedRuntimeMetadataSupplier;
import com.oracle.svm.core.sampler.CallStackFrameMethodInfo;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.code.CodeSectionLayouter;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.image.HostedInstantReferenceAdjuster;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.DataSection;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class NativeImageCodeCache {
    private final Map<Constant, Object> embeddedConstants = new HashMap<Constant, Object>();
    private int codeAreaSize;
    protected final NativeImageHeap imageHeap;
    private final Map<HostedMethod, CompilationResult> compilations;
    private final List<Pair<HostedMethod, CompilationResult>> orderedCompilations;
    protected final Platform targetPlatform;
    private final DataSection dataSection;
    private final Map<Constant, String> constantReasons = new HashMap<Constant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        this(compilationResultMap, imageHeap, (Platform)ImageSingletons.lookup(Platform.class));
    }

    public void purge() {
        this.compilations.clear();
        this.orderedCompilations.clear();
    }

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
        this.targetPlatform = targetPlatform;
        this.orderedCompilations = this.computeCompilationOrder(compilations);
    }

    public abstract int getCodeCacheSize();

    public int getCodeAreaSize() {
        assert (this.codeAreaSize >= 0);
        return this.codeAreaSize;
    }

    public void setCodeAreaSize(int codeAreaSize) {
        this.codeAreaSize = codeAreaSize;
    }

    public Pair<HostedMethod, CompilationResult> getFirstCompilation() {
        return this.orderedCompilations.getFirst();
    }

    public Pair<HostedMethod, CompilationResult> getLastCompilation() {
        return this.orderedCompilations.getLast();
    }

    protected List<Pair<HostedMethod, CompilationResult>> computeCompilationOrder(Map<HostedMethod, CompilationResult> compilationMap) {
        List<HostedMethod> orderedMethods = ((CodeSectionLayouter)ImageSingletons.lookup(CodeSectionLayouter.class)).layout(compilationMap);
        return orderedMethods.stream().map(hm -> Pair.create((Object)hm, (Object)this.compilations.get(hm))).collect(Collectors.toList());
    }

    public List<Pair<HostedMethod, CompilationResult>> getOrderedCompilations() {
        return this.orderedCompilations;
    }

    public abstract int codeSizeFor(HostedMethod var1);

    public CompilationResult compilationResultFor(HostedMethod method) {
        return this.compilations.get(method);
    }

    public abstract void layoutMethods(DebugContext var1, BigBang var2);

    public void layoutConstants() {
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            JavaConstant constant;
            CompilationResult compilation = (CompilationResult)pair.getRight();
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put((Constant)constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
            for (DataPatch patch : compilation.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                constant = ((ConstantReference)patch.reference).getConstant();
                this.constantReasons.put((Constant)constant, compilation.getName());
            }
        }
        this.dataSection.close(HostedOptionValues.singleton(), 1);
    }

    public Map<Constant, Object> initAndGetEmbeddedConstants() {
        VMError.guarantee(BuildPhaseProvider.isCompilationFinished(), "Code cache embedded constants are available only after compilation.");
        VMError.guarantee(this.embeddedConstants.isEmpty(), "Embedded constants are already computed.");
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            SubstrateDataBuilder.ObjectData objectData = (SubstrateDataBuilder.ObjectData)data;
            this.embeddedConstants.put((Constant)objectData.getConstant(), (Object)NativeImageHeap.HeapInclusionReason.DataSection);
        }
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition((ResolvedJavaMethod)((HostedMethod)pair.getLeft()).getWrapped());
            CompilationResult compilationResult = (CompilationResult)pair.getRight();
            for (DataPatch patch : compilationResult.getDataPatches()) {
                Reference reference = patch.reference;
                if (!(reference instanceof ConstantReference)) continue;
                ConstantReference ref = (ConstantReference)reference;
                this.embeddedConstants.put((Constant)ref.getConstant(), position);
            }
            for (CompilationResult.CodeAnnotation codeAnnotation : compilationResult.getCodeAnnotations()) {
                if (!(codeAnnotation instanceof HostedImageHeapConstantPatch)) continue;
                HostedImageHeapConstantPatch patch = (HostedImageHeapConstantPatch)codeAnnotation;
                this.embeddedConstants.put((Constant)patch.constant, position);
            }
        }
        return this.embeddedConstants;
    }

    public Map<Constant, Object> getEmbeddedConstants() {
        VMError.guarantee(!this.embeddedConstants.isEmpty(), "Embedded constants should already be computed.");
        return Collections.unmodifiableMap(this.embeddedConstants);
    }

    public void addConstantsToHeap() {
        this.getEmbeddedConstants().forEach((constant, reason) -> {
            Object object;
            if (reason instanceof BytecodePosition) {
                BytecodePosition position = (BytecodePosition)reason;
                object = position.getMethod().getName();
            } else {
                object = reason;
            }
            this.addConstantToHeap((Constant)constant, object);
        });
    }

    private void addConstantToHeap(Constant constant, Object reason) {
        if (constant instanceof SubstrateMethodPointerConstant) {
            return;
        }
        HostedType hostedType = this.imageHeap.hMetaAccess.lookupJavaType((JavaConstant)constant);
        if (!hostedType.isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + hostedType.getName() + "." + (String)(reason != null ? " Method: " + String.valueOf(reason) : ""));
        }
        this.imageHeap.addConstant((JavaConstant)constant, false, reason != null ? reason : this.constantReasons.get(constant));
    }

    protected int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public void buildRuntimeMetadata(DebugContext debug, SnippetReflectionProvider snippetReflectionProvider) {
        this.buildRuntimeMetadata(debug, snippetReflectionProvider, new MethodPointer((ResolvedJavaMethod)this.getFirstCompilation().getLeft(), true), (UnsignedWord)WordFactory.signed((int)this.getCodeAreaSize()));
    }

    protected void buildRuntimeMetadata(DebugContext debug, SnippetReflectionProvider snippetReflection, CFunctionPointer firstMethod, UnsignedWord codeSize) {
        int modifiers;
        String name;
        HostedType declaringType;
        HostedFrameInfoCustomization frameInfoCustomization = new HostedFrameInfoCustomization();
        CodeInfoEncoder.Encoders encoders = new CodeInfoEncoder.Encoders(true, clazz -> {
            if (clazz != null) {
                Optional<HostedType> hostedType = this.imageHeap.hMetaAccess.optionalLookupJavaType((Class<?>)clazz);
                if (hostedType.isPresent()) {
                    boolean reachable = hostedType.get().getWrapped().isReachable();
                    VMError.guarantee(reachable, "Type added to the runtime metadata was seen by the analysis, but not marked as reachable: %s", clazz);
                } else {
                    throw VMError.shouldNotReachHere("Type added to the runtime metadata without being seen by the analysis: %s", clazz);
                }
            }
        });
        HostedConstantAccess hostedConstantAccess = new HostedConstantAccess(snippetReflection);
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization, encoders, hostedConstantAccess);
        DeadlockWatchdog watchdog = (DeadlockWatchdog)ImageSingletons.lookup(DeadlockWatchdog.class);
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            this.encodeMethod(codeInfoEncoder, pair);
            watchdog.recordActivity();
        }
        HostedUniverse hUniverse = this.imageHeap.hUniverse;
        HostedMetaAccess hMetaAccess = this.imageHeap.hMetaAccess;
        RuntimeMetadataEncoder runtimeMetadataEncoder = ((ReflectionMetadataEncoderFactory)ImageSingletons.lookup(ReflectionMetadataEncoderFactory.class)).create(hUniverse.getSnippetReflection(), encoders);
        ReflectionHostedSupport reflectionSupport = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        Map<Class<?>, Set<Class<?>>> innerClasses = reflectionSupport.getReflectionInnerClasses();
        Set<?> heapDynamicHubs = reflectionSupport.getHeapDynamicHubs();
        for (HostedType type : hUniverse.getTypes()) {
            if (!type.getWrapped().isReachable() || type.getWrapped().isInBaseLayer() || !heapDynamicHubs.contains(type.getHub())) continue;
            Class[] typeInnerClasses = innerClasses.getOrDefault(type.getJavaClass(), Collections.emptySet()).toArray(new Class[0]);
            runtimeMetadataEncoder.addClassMetadata((MetaAccessProvider)hMetaAccess, type, typeInnerClasses);
        }
        reflectionSupport.getClassLookupErrors().forEach((clazz, error) -> {
            ResolvedJavaType type = hMetaAccess.lookupJavaType((Class)clazz);
            runtimeMetadataEncoder.addClassLookupError((HostedType)type, (Throwable)error);
        });
        reflectionSupport.getFieldLookupErrors().forEach((clazz, error) -> {
            ResolvedJavaType type = hMetaAccess.lookupJavaType((Class)clazz);
            runtimeMetadataEncoder.addFieldLookupError((HostedType)type, (Throwable)error);
        });
        reflectionSupport.getMethodLookupErrors().forEach((clazz, error) -> {
            ResolvedJavaType type = hMetaAccess.lookupJavaType((Class)clazz);
            runtimeMetadataEncoder.addMethodLookupError((HostedType)type, (Throwable)error);
        });
        reflectionSupport.getConstructorLookupErrors().forEach((clazz, error) -> {
            ResolvedJavaType type = hMetaAccess.lookupJavaType((Class)clazz);
            runtimeMetadataEncoder.addConstructorLookupError((HostedType)type, (Throwable)error);
        });
        HashSet<AnalysisField> includedFields = new HashSet<AnalysisField>();
        HashSet<AnalysisMethod> includedMethods = new HashSet<AnalysisMethod>();
        Map<AnalysisType, Map<AnalysisField, ConditionalRuntimeValue<Field>>> configurationFields = reflectionSupport.getReflectionFields();
        Map<AnalysisType, Map<AnalysisMethod, ConditionalRuntimeValue<Executable>>> configurationExecutables = reflectionSupport.getReflectionExecutables();
        reflectionSupport.getHeapReflectionFields().forEach((analysisField, reflectField) -> {
            if (includedFields.add((AnalysisField)analysisField)) {
                HostedField hostedField = hUniverse.lookup((JavaField)analysisField);
                runtimeMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedField, (AccessibleObject)reflectField, configurationFields.getOrDefault(analysisField.getDeclaringClass(), Collections.emptyMap()).containsKey(analysisField));
            }
        });
        reflectionSupport.getHeapReflectionExecutables().forEach((analysisMethod, reflectMethod) -> {
            if (includedMethods.add((AnalysisMethod)analysisMethod)) {
                HostedMethod hostedMethod = hUniverse.lookup((JavaMethod)analysisMethod);
                runtimeMetadataEncoder.addHeapAccessibleObjectMetadata((MetaAccessProvider)hMetaAccess, (WrappedElement)hostedMethod, (AccessibleObject)reflectMethod, configurationExecutables.getOrDefault(analysisMethod.getDeclaringClass(), Collections.emptyMap()).containsKey(analysisMethod));
            }
        });
        configurationFields.forEach((declaringClass, classFields) -> classFields.forEach((analysisField, reflectField) -> {
            if (includedFields.add((AnalysisField)analysisField)) {
                HostedField hostedField = hUniverse.lookup((JavaField)analysisField);
                runtimeMetadataEncoder.addReflectionFieldMetadata((MetaAccessProvider)hMetaAccess, hostedField, (ConditionalRuntimeValue<Field>)reflectField);
            }
        }));
        configurationExecutables.forEach((declaringClass, classMethods) -> classMethods.forEach((analysisMethod, reflectMethod) -> {
            if (includedMethods.add((AnalysisMethod)analysisMethod)) {
                HostedMethod method = hUniverse.lookup((JavaMethod)analysisMethod);
                Object accessor = reflectionSupport.getAccessor((AnalysisMethod)analysisMethod);
                runtimeMetadataEncoder.addReflectionExecutableMetadata((MetaAccessProvider)hMetaAccess, method, (ConditionalRuntimeValue<Executable>)reflectMethod, accessor);
            }
        }));
        for (Object obj : reflectionSupport.getHidingReflectionFields()) {
            AnalysisField analysisField2 = (AnalysisField)obj;
            if (!includedFields.add(analysisField2)) continue;
            declaringType = hUniverse.lookup((JavaType)analysisField2.getDeclaringClass());
            name = analysisField2.getName();
            HostedType type = hUniverse.lookup((JavaType)analysisField2.getType());
            modifiers = analysisField2.getModifiers();
            runtimeMetadataEncoder.addHidingFieldMetadata(analysisField2, declaringType, name, type, modifiers);
        }
        for (Object obj : reflectionSupport.getHidingReflectionMethods()) {
            AnalysisMethod analysisMethod2 = (AnalysisMethod)obj;
            if (!includedMethods.add(analysisMethod2)) continue;
            declaringType = hUniverse.lookup((JavaType)analysisMethod2.getDeclaringClass());
            name = analysisMethod2.getName();
            HostedType[] parameterTypes = (HostedType[])analysisMethod2.getSignature().toParameterList(null).stream().map(hUniverse::lookup).toArray(HostedType[]::new);
            modifiers = analysisMethod2.getModifiers();
            HostedType returnType = hUniverse.lookup((JavaType)analysisMethod2.getSignature().getReturnType());
            runtimeMetadataEncoder.addHidingMethodMetadata(analysisMethod2, declaringType, name, parameterTypes, modifiers, returnType);
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (HostedField hostedField : hUniverse.getFields()) {
                if (!hostedField.isAccessed() || hostedField.getWrapped().isInBaseLayer() || includedFields.contains(hostedField.getWrapped())) continue;
                runtimeMetadataEncoder.addReachableFieldMetadata(hostedField);
            }
            for (HostedMethod hostedMethod : hUniverse.getMethods()) {
                if (!hostedMethod.getWrapped().isReachable() || hostedMethod.getWrapped().isInBaseLayer() || hostedMethod.getWrapped().isIntrinsicMethod() || includedMethods.contains(hostedMethod.getWrapped())) continue;
                runtimeMetadataEncoder.addReachableExecutableMetadata(hostedMethod);
            }
        }
        if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            reflectionSupport.getNegativeFieldQueries().forEach((analysisType, fields) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (String field : fields) {
                        runtimeMetadataEncoder.addNegativeFieldQueryMetadata(hostedType, field);
                    }
                }
            });
            reflectionSupport.getNegativeMethodQueries().forEach((analysisType, methodSignatures) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (AnalysisMethod.Signature methodSignature : methodSignatures) {
                        HostedType[] parameterTypes = hUniverse.optionalLookup((JavaType[])methodSignature.parameterTypes());
                        if (parameterTypes == null) continue;
                        runtimeMetadataEncoder.addNegativeMethodQueryMetadata(hostedType, methodSignature.name(), parameterTypes);
                    }
                }
            });
            reflectionSupport.getNegativeConstructorQueries().forEach((analysisType, constructorSignatures) -> {
                HostedType hostedType = hUniverse.optionalLookup((JavaType)analysisType);
                if (hostedType != null) {
                    for (AnalysisType[] analysisParameterTypes : constructorSignatures) {
                        HostedType[] parameterTypes = hUniverse.optionalLookup((JavaType[])analysisParameterTypes);
                        if (parameterTypes == null) continue;
                        runtimeMetadataEncoder.addNegativeConstructorQueryMetadata(hostedType, parameterTypes);
                    }
                }
            });
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
            System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
        }
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = this.installCodeInfo(snippetReflection, firstMethod, codeSize, codeInfoEncoder, runtimeMetadataEncoder, watchdog);
        if (ImageSingletons.contains(CallStackFrameMethodInfo.class)) {
            ((CallStackFrameMethodInfo)ImageSingletons.lookup(CallStackFrameMethodInfo.class)).initialize(encoders, (MetaAccessProvider)hMetaAccess);
        }
        if (InterpreterSupport.isEnabled()) {
            InterpreterSupport.singleton().buildMethodIdMapping(encoders.getEncodedMethods());
        }
        if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
            System.out.println("****Start Code Info Encoder Counters****");
            for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                System.out.println(counter.getName() + " ; " + counter.getValue());
            }
            System.out.println("****End Code Info Encoder Counters****");
        }
        if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
            this.verifyDeoptEntries(imageCodeInfo, hostedConstantAccess);
        }
        assert (this.verifyMethods(debug, hUniverse, codeInfoEncoder, imageCodeInfo, hostedConstantAccess));
    }

    protected ImageCodeInfo.HostedImageCodeInfo installCodeInfo(SnippetReflectionProvider snippetReflection, CFunctionPointer firstMethod, UnsignedWord codeSize, CodeInfoEncoder codeInfoEncoder, RuntimeMetadataEncoder runtimeMetadataEncoder, DeadlockWatchdog watchdog) {
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache().getHostedImageCodeInfo();
        codeInfoEncoder.encodeAllAndInstall(imageCodeInfo, new HostedInstantReferenceAdjuster(snippetReflection), watchdog::recordActivity);
        runtimeMetadataEncoder.encodeAllAndInstall();
        imageCodeInfo.setCodeStart((CodePointer)firstMethod);
        imageCodeInfo.setCodeSize(codeSize);
        imageCodeInfo.setDataOffset(codeSize);
        imageCodeInfo.setDataSize((UnsignedWord)WordFactory.zero());
        imageCodeInfo.setCodeAndDataMemorySize(codeSize);
        return imageCodeInfo;
    }

    protected void encodeMethod(CodeInfoEncoder codeInfoEncoder, Pair<HostedMethod, CompilationResult> pair) {
        HostedMethod method = (HostedMethod)pair.getLeft();
        CompilationResult compilation = (CompilationResult)pair.getRight();
        codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset(), this.codeSizeFor(method));
    }

    private void verifyDeoptEntries(CodeInfo codeInfo, FrameInfoDecoder.ConstantAccess constantAccess) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Map<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Map<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo>>>(SubstrateCompilationDirectives.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort(Comparator.comparing(e -> ((AnalysisMethod)e.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.hUniverse.lookup((JavaMethod)((AnalysisMethod)entry.getKey()).getMultiMethod(MultiMethod.ORIGINAL_METHOD));
            if (method.hasCalleeSavedRegisters()) {
                System.out.println("DeoptEntry has callee saved registers: " + method.format("%H.%n(%p)"));
                hasError = true;
            }
            ArrayList sourceFrameInfos = new ArrayList(((Map)entry.getValue()).entrySet());
            sourceFrameInfos.sort(Comparator.comparingLong(Map.Entry::getKey));
            for (Map.Entry entry2 : sourceFrameInfos) {
                hasError = NativeImageCodeCache.verifyDeoptEntry(codeInfo, method, entry2, constantAccess) || hasError;
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(CodeInfo codeInfo, HostedMethod method, Map.Entry<Long, SubstrateCompilationDirectives.DeoptSourceFrameInfo> sourceFrameInfo, FrameInfoDecoder.ConstantAccess constantAccess) {
        int deoptOffsetInImage = method.getImageCodeDeoptOffset();
        long encodedBci = sourceFrameInfo.getKey();
        if (sourceFrameInfo.getValue() == SubstrateCompilationDirectives.DeoptSourceFrameInfo.INVALID_DEOPT_SOURCE_FRAME) {
            return NativeImageCodeCache.error(method, encodedBci, "Incompatible source frames; multiple frames with different sizes of locals, locks, and/or stack values exist");
        }
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(codeInfo, deoptOffsetInImage, encodedBci, result, constantAccess);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        FrameInfoQueryResult targetFrame = result.getFrameInfo();
        if (targetFrame == null || !targetFrame.isDeoptEntry() || targetFrame.getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        boolean hasExceptionHandler = result.getExceptionOffset() != 0L;
        switch (targetFrame.getStackState()) {
            case BeforePop: 
            case AfterPop: {
                if (hasExceptionHandler) break;
                return NativeImageCodeCache.error(method, encodedBci, "no exception handler registered for deopt entry");
            }
            case Rethrow: {
                if (!hasExceptionHandler) break;
                return NativeImageCodeCache.error(method, encodedBci, "exception handler registered for rethrowException");
            }
            default: {
                return NativeImageCodeCache.error(method, encodedBci, "invalid encoded bci");
            }
        }
        SubstrateCompilationDirectives.DeoptSourceFrameInfo sourceFrame = sourceFrameInfo.getValue();
        FrameInfoQueryResult.ValueInfo[] targetValues = targetFrame.getValueInfos();
        List<JavaKind> sourceKinds = Arrays.asList(sourceFrame.expectedKinds);
        if (targetFrame.getNumLocals() != sourceFrame.numLocals || targetFrame.getNumStack() != sourceFrame.numStack || targetFrame.getNumLocks() != sourceFrame.numLocks) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Mismatch between number of expected values in target and source.").append(System.lineSeparator());
            errorMessage.append(String.format("Target: locals-%d, stack-%d, locks-%d.%n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            errorMessage.append(String.format("Source: locals-%d, stack-%d, locks-%d.%n", sourceFrame.numLocals, sourceFrame.numStack, sourceFrame.numLocks));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        boolean validTarget = true;
        for (int i = 0; i < targetValues.length; ++i) {
            JavaKind targetKind = targetValues[i].getKind();
            if (targetKind == JavaKind.Illegal || targetKind == sourceKinds.get(i)) continue;
            validTarget = false;
            break;
        }
        if (!validTarget) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(String.format("Deoptimization source frame is not a superset of the target frame.%n", new Object[0]));
            NativeImageCodeCache.appendFrameInfo(errorMessage, true, Arrays.stream(targetValues).map(FrameInfoQueryResult.ValueInfo::getKind).collect(Collectors.toList()));
            NativeImageCodeCache.appendFrameInfo(errorMessage, false, sourceKinds);
            return NativeImageCodeCache.error(method, encodedBci, errorMessage.toString());
        }
        return false;
    }

    private static void appendFrameInfo(StringBuilder builder, boolean isTarget, List<JavaKind> javaKinds) {
        builder.append(String.format("***%s Frame***%n", isTarget ? "Target" : "Source"));
        for (int i = 0; i < javaKinds.size(); ++i) {
            builder.append(String.format("index %d: %s%n", i, javaKinds.get(i)));
        }
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "):" + System.lineSeparator() + msg);
        return true;
    }

    protected boolean verifyMethods(DebugContext debug, HostedUniverse hUniverse, CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo, FrameInfoDecoder.ConstantAccess constantAccess) {
        Inflation bb = hUniverse.getBigBang();
        CompletionExecutor executor = new CompletionExecutor(debug, (BigBang)bb);
        try {
            executor.init();
            executor.start();
            for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
                HostedMethod method = (HostedMethod)pair.getLeft();
                executor.execute(ignore -> CodeInfoEncoder.verifyMethod(method, (CompilationResult)pair.getRight(), method.getCodeAddressOffset(), this.codeSizeFor(method), codeInfo, constantAccess));
            }
            executor.complete();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere("Failed to verify methods");
        }
        codeInfoEncoder.verifyFrameInfo(codeInfo);
        return true;
    }

    public abstract void patchMethods(DebugContext var1, RelocatableBuffer var2, ObjectFile var3);

    public abstract void writeCode(RelocatableBuffer var1);

    public void writeConstants(NativeImageHeapWriter writer, RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getByteBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> writer.writeReference(buffer, position, (JavaConstant)constant, "VMConstant: " + String.valueOf(constant)));
    }

    public abstract NativeImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer var1, ObjectFile var2, NativeImageCodeCache var3);

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        return new Path[]{tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix())};
    }

    public abstract List<ObjectFile.Symbol> getSymbols(ObjectFile var1);

    public void printCompilationResults() {
        String reportsPath = SubstrateOptions.reportsPath();
        ReportUtils.report((String)"compilation results", (String)reportsPath, (String)"universe_compilation", (String)"txt", this::printCompilationResults);
    }

    private void printCompilationResults(PrintWriter writer) {
        writer.println("--- compiled methods");
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CompilationResult result = (CompilationResult)pair.getRight();
            writer.format("%8d %5d %s: frame %d%n", method.getCodeAddressOffset(), result.getTargetCodeSize(), method.getQualifiedName(), result.getTotalFrameSize());
        }
        writer.println("--- vtables:");
        for (HostedType type : this.imageHeap.hUniverse.getTypes()) {
            HostedMethod[] vtable = type.getVTable();
            for (int i = 0; i < vtable.length; ++i) {
                CompilationResult comp;
                HostedMethod method = vtable[i];
                if (method == null || (comp = this.compilationResultFor(vtable[i])) == null) continue;
                writer.format("%d %s @ %d: %s = 0x%x%n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    private static class HostedFrameInfoCustomization
    extends FrameInfoEncoder.SourceFieldsFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private HostedFrameInfoCustomization() {
        }

        @Override
        protected Class<?> getDeclaringJavaClass(ResolvedJavaMethod method) {
            HostedType type = (HostedType)method.getDeclaringClass();
            assert (type.getWrapped().isReachable()) : "Declaring class not marked as used, therefore the DynamicHub is not initialized properly: " + method.format("%H.%n(%p)");
            return type.getJavaClass();
        }

        @Override
        protected boolean storeDeoptTargetMethod() {
            return false;
        }

        @Override
        protected void recordFrame(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
            super.recordFrame(method, infopoint, isDeoptEntry);
            if (isDeoptEntry) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput(infopoint);
                }
            }
        }

        @Override
        protected boolean includeLocalValues(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
            BytecodeFrame topFrame;
            if (isDeoptEntry || ((HostedMethod)method).compilationInfo.canDeoptForTesting()) {
                return true;
            }
            for (BytecodeFrame frame = topFrame = infopoint.debugInfo.frame(); frame != null; frame = frame.caller()) {
                if (!SubstrateCompilationDirectives.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, CompilationResult compilation, Infopoint infopoint) {
            return DeoptimizationUtils.isDeoptEntry((HostedMethod)method, compilation, infopoint);
        }
    }

    static class HostedConstantAccess
    extends FrameInfoDecoder.ConstantAccess {
        private final SnippetReflectionProvider snippetReflection;

        HostedConstantAccess(SnippetReflectionProvider snippetReflection) {
            this.snippetReflection = snippetReflection;
        }

        @Override
        public JavaConstant forObject(Object object, boolean isCompressedReference) {
            CompressibleConstant compressible;
            if (object == null) {
                return isCompressedReference ? CompressedNullConstant.COMPRESSED_NULL : JavaConstant.NULL_POINTER;
            }
            JavaConstant constant = this.snippetReflection.forObject(object);
            if (constant instanceof CompressibleConstant && isCompressedReference != (compressible = (CompressibleConstant)constant).isCompressed()) {
                return isCompressedReference ? compressible.compress() : compressible.uncompress();
            }
            return constant;
        }

        @Override
        public Object asObject(JavaConstant constant) {
            return this.snippetReflection.asObject(Object.class, constant);
        }
    }

    public static interface ReflectionMetadataEncoderFactory {
        public RuntimeMetadataEncoder create(SnippetReflectionProvider var1, CodeInfoEncoder.Encoders var2);
    }

    public static interface RuntimeMetadataEncoder
    extends EncodedRuntimeMetadataSupplier {
        public static final Method getRoot = ReflectionUtil.lookupMethod(AccessibleObject.class, (String)"getRoot", (Class[])new Class[0]);

        public void addClassMetadata(MetaAccessProvider var1, HostedType var2, Class<?>[] var3);

        public void addReflectionFieldMetadata(MetaAccessProvider var1, HostedField var2, ConditionalRuntimeValue<Field> var3);

        public void addReflectionExecutableMetadata(MetaAccessProvider var1, HostedMethod var2, ConditionalRuntimeValue<Executable> var3, Object var4);

        public void addHeapAccessibleObjectMetadata(MetaAccessProvider var1, WrappedElement var2, AccessibleObject var3, boolean var4);

        public void addHidingFieldMetadata(AnalysisField var1, HostedType var2, String var3, HostedType var4, int var5);

        public void addHidingMethodMetadata(AnalysisMethod var1, HostedType var2, String var3, HostedType[] var4, int var5, HostedType var6);

        public void addReachableFieldMetadata(HostedField var1);

        public void addReachableExecutableMetadata(HostedMethod var1);

        public void addNegativeFieldQueryMetadata(HostedType var1, String var2);

        public void addNegativeMethodQueryMetadata(HostedType var1, String var2, HostedType[] var3);

        public void addNegativeConstructorQueryMetadata(HostedType var1, HostedType[] var2);

        public void addClassLookupError(HostedType var1, Throwable var2);

        public void addFieldLookupError(HostedType var1, Throwable var2);

        public void addMethodLookupError(HostedType var1, Throwable var2);

        public void addConstructorLookupError(HostedType var1, Throwable var2);

        public void encodeAllAndInstall();

        public static AccessibleObject getHolder(AccessibleObject accessibleObject) {
            try {
                AccessibleObject root = (AccessibleObject)getRoot.invoke((Object)accessibleObject, new Object[0]);
                return root == null ? accessibleObject : root;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

