/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointBuiltins;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CInterfaceWrapper;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public final class CEntryPointCallStubMethod
extends EntryPointCallStubMethod {
    private final CEntryPointData entryPointData;
    private final ResolvedJavaMethod targetMethod;
    private final ResolvedSignature<AnalysisType> targetSignature;

    static CEntryPointCallStubMethod create(BigBang bb, AnalysisMethod targetMethod, CEntryPointData entryPointData) {
        MetaAccessProvider originalMetaAccess = GraalAccess.getOriginalProviders().getMetaAccess();
        ResolvedJavaType declaringClass = originalMetaAccess.lookupJavaType(IsolateEnterStub.class);
        ConstantPool constantPool = IsolateEnterStub.getConstantPool(originalMetaAccess);
        return new CEntryPointCallStubMethod(entryPointData, targetMethod, declaringClass, constantPool, bb.getMetaAccess());
    }

    private CEntryPointCallStubMethod(CEntryPointData entryPointData, AnalysisMethod targetMethod, ResolvedJavaType holderClass, ConstantPool holderConstantPool, AnalysisMetaAccess metaAccess) {
        super(SubstrateUtil.uniqueStubName(targetMethod.getWrapped()), holderClass, (Signature)CEntryPointCallStubMethod.createSignature(targetMethod, metaAccess), holderConstantPool);
        this.entryPointData = entryPointData;
        this.targetMethod = targetMethod.getWrapped();
        this.targetSignature = targetMethod.getSignature();
    }

    private static ResolvedSignature<ResolvedJavaType> createSignature(AnalysisMethod method, AnalysisMetaAccess metaAccess) {
        NativeLibraries nativeLibraries = NativeLibraries.singleton();
        AnalysisType[] args = (AnalysisType[])method.toParameterList().toArray(AnalysisType[]::new);
        ResolvedJavaType[] patchedArgs = new ResolvedJavaType[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (CInterfaceEnumTool.isPrimitiveOrWord(args[i])) {
                patchedArgs[i] = args[i].getWrapped();
                continue;
            }
            EnumInfo enumInfo = CEntryPointCallStubMethod.getEnumInfo(nativeLibraries, (ResolvedJavaMethod)method, args[i], false);
            patchedArgs[i] = CInterfaceEnumTool.getCEnumValueType(enumInfo, metaAccess).getWrapped();
        }
        AnalysisType patchedReturnType = (AnalysisType)method.getSignature().getReturnType();
        if (!CInterfaceEnumTool.isPrimitiveOrWord(patchedReturnType)) {
            assert (CEntryPointCallStubMethod.getEnumInfo(nativeLibraries, (ResolvedJavaMethod)method, patchedReturnType, true) != null);
            patchedReturnType = (AnalysisType)nativeLibraries.getWordTypes().getWordImplType();
        }
        return ResolvedSignature.fromArray((ResolvedJavaType[])patchedArgs, (ResolvedJavaType)patchedReturnType.getWrapped());
    }

    @Override
    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.targetMethod.getParameters();
    }

    AnalysisMethod lookupTargetMethod(AnalysisMetaAccess metaAccess) {
        return metaAccess.getUniverse().lookup((JavaMethod)this.targetMethod);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode invokePrologue;
        if (this.entryPointData.getBuiltin() != CEntryPointData.DEFAULT_BUILTIN) {
            return this.buildBuiltinGraph(debug, method, providers);
        }
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        NativeLibraries nativeLibraries = NativeLibraries.singleton();
        ArrayList<AnalysisType> parameterTypes = new ArrayList<AnalysisType>(this.targetSignature.toParameterList(null));
        ArrayList<AnalysisType> parameterLoadTypes = new ArrayList<AnalysisType>(parameterTypes);
        EnumInfo[] parameterEnumInfos = this.adaptParameterTypes(nativeLibraries, kit, parameterTypes, parameterLoadTypes);
        ValueNode[] args = kit.getInitialArguments().toArray(ValueNode.EMPTY_ARRAY);
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCEntryPointPrologue(kit, (ResolvedJavaMethod)method);
        }
        if ((invokePrologue = this.generatePrologue(kit, parameterLoadTypes, this.targetMethod.getParameterAnnotations(), args)) != null) {
            ResolvedJavaMethod prologueMethod = invokePrologue.callTarget().targetMethod();
            JavaKind prologueReturnKind = prologueMethod.getSignature().getReturnKind();
            if (prologueReturnKind == JavaKind.Int) {
                kit.startIf((LogicNode)kit.unique((FloatingNode)new IntegerEqualsNode((ValueNode)invokePrologue, (ValueNode)ConstantNode.forInt((int)0, (StructuredGraph)kit.getGraph()))), BranchProbabilityNode.VERY_FAST_PATH_PROFILE);
                kit.thenPart();
                kit.elsePart();
                Class<?> bailoutCustomizer = this.entryPointData.getPrologueBailout();
                JavaKind targetMethodReturnKind = this.targetMethod.getSignature().getReturnKind();
                boolean createdReturnNode = false;
                if (bailoutCustomizer == CEntryPointOptions.AutomaticPrologueBailout.class) {
                    if (targetMethodReturnKind == JavaKind.Int) {
                        kit.createReturn((ValueNode)invokePrologue, JavaKind.Int);
                        createdReturnNode = true;
                    } else if (targetMethodReturnKind == JavaKind.Void) {
                        kit.createReturn(null, JavaKind.Void);
                        createdReturnNode = true;
                    } else {
                        VMError.shouldNotReachHere("@CEntryPointOptions on " + String.valueOf(this.targetMethod) + " must specify a custom prologue bailout as the method's return type is neither int nor void.");
                    }
                }
                if (!createdReturnNode) {
                    AnalysisMethod[] bailoutMethods = kit.getMetaAccess().lookupJavaType(bailoutCustomizer).getDeclaredMethods(false);
                    UserError.guarantee(bailoutMethods.length == 1 && bailoutMethods[0].isStatic(), "Prologue bailout customization class must declare exactly one static method: %s -> %s", this.targetMethod, bailoutCustomizer);
                    InvokeWithExceptionNode invokeBailoutCustomizer = CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, bailoutMethods[0], new ValueNode[]{invokePrologue});
                    VMError.guarantee(bailoutMethods[0].getSignature().getReturnKind() == method.getSignature().getReturnKind(), "Return type mismatch: %s is incompatible with %s", bailoutMethods[0], this.targetMethod);
                    kit.createReturn((ValueNode)invokeBailoutCustomizer, this.targetMethod.getSignature().getReturnKind());
                }
                kit.endIf();
            } else {
                VMError.guarantee(prologueReturnKind == JavaKind.Void, "%s is a prologue method and must therefore either return int or void.", prologueMethod);
            }
        }
        CEntryPointCallStubMethod.adaptArgumentValues(kit, parameterTypes, parameterEnumInfos, args);
        AnalysisMethod aTargetMethod = kit.getMetaAccess().getUniverse().lookup((JavaMethod)this.targetMethod);
        kit.emitEnsureInitializedCall((ResolvedJavaType)aTargetMethod.getDeclaringClass());
        int invokeBci = kit.bci();
        CallTargetNode.InvokeKind invokeKind = aTargetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        ValueNode[] invokeArgs = args;
        if (invokeKind != CallTargetNode.InvokeKind.Static) {
            invokeArgs = new ValueNode[args.length + 1];
            invokeArgs[0] = kit.createObject(null);
            System.arraycopy(args, 0, invokeArgs, 1, args.length);
        }
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((ResolvedJavaMethod)aTargetMethod, invokeKind, kit.getFrameState(), invokeBci, invokeArgs);
        CEntryPointCallStubMethod.patchNodeSourcePosition(invoke);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler((ResolvedJavaMethod)method, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        this.generateEpilogueAndReturn((ResolvedJavaMethod)method, kit, (ValueNode)invoke);
        return kit.finalizeGraph();
    }

    private void generateEpilogueAndReturn(ResolvedJavaMethod method, HostedGraphKit kit, ValueNode value) {
        ValueNode returnValue = this.adaptReturnValue(kit, value);
        this.generateEpilogue(kit);
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCEntryPointEpilogue(kit, method);
        }
        kit.createReturn(returnValue, returnValue.getStackKind());
    }

    private static void patchNodeSourcePosition(InvokeWithExceptionNode invoke) {
        NodeSourcePosition position = invoke.getNodeSourcePosition();
        if (position != null && position.getBCI() == -6) {
            invoke.setNodeSourcePosition(new NodeSourcePosition(position.getCaller(), position.getMethod(), invoke.bci()));
        }
    }

    private StructuredGraph buildBuiltinGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers) {
        int index;
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        AnalysisMethod aTargetMethod = kit.getMetaAccess().getUniverse().lookup((JavaMethod)this.targetMethod);
        UserError.guarantee(this.entryPointData.getPrologue() == CEntryPointData.DEFAULT_PROLOGUE, "@%s method declared as built-in must not have a custom prologue: %s", CEntryPoint.class.getSimpleName(), aTargetMethod);
        UserError.guarantee(this.entryPointData.getEpilogue() == CEntryPointData.DEFAULT_EPILOGUE, "@%s method declared as built-in must not have a custom epilogue: %s", CEntryPoint.class.getSimpleName(), aTargetMethod);
        UserError.guarantee(this.entryPointData.getExceptionHandler() == CEntryPointData.DEFAULT_EXCEPTION_HANDLER, "@%s method declared as built-in must not have a custom exception handler: %s", CEntryPoint.class.getSimpleName(), aTargetMethod);
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCEntryPointPrologue(kit, (ResolvedJavaMethod)method);
        }
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(kit, aTargetMethod.toParameterList(), aTargetMethod.getParameterAnnotations());
        CEntryPoint.Builtin builtin = this.entryPointData.getBuiltin();
        AnalysisMethod builtinCallee = null;
        for (AnalysisMethod candidate : kit.getMetaAccess().lookupJavaType(CEntryPointBuiltins.class).getDeclaredMethods(false)) {
            CEntryPointBuiltins.CEntryPointBuiltinImplementation annotation = (CEntryPointBuiltins.CEntryPointBuiltinImplementation)candidate.getAnnotation(CEntryPointBuiltins.CEntryPointBuiltinImplementation.class);
            if (annotation == null || !annotation.builtin().equals((Object)builtin)) continue;
            VMError.guarantee(builtinCallee == null, "More than one candidate for @%s built-in %s", CEntryPoint.class.getSimpleName(), builtin);
            builtinCallee = candidate;
        }
        VMError.guarantee(builtinCallee != null, "No candidate for @%s built-in %s", CEntryPoint.class.getSimpleName(), builtin);
        AnalysisType isolateType = kit.getMetaAccess().lookupJavaType(Isolate.class);
        AnalysisType threadType = kit.getMetaAccess().lookupJavaType(IsolateThread.class);
        int builtinIsolateIndex = -1;
        int builtinThreadIndex = -1;
        List builtinParamTypes = builtinCallee.toParameterList();
        for (int i = 0; i < builtinParamTypes.size(); ++i) {
            AnalysisType type = (AnalysisType)builtinParamTypes.get(i);
            if (isolateType.isAssignableFrom((ResolvedJavaType)type)) {
                VMError.guarantee(builtinIsolateIndex == -1, "@%s built-in with more than one %s parameter: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), builtinCallee);
                builtinIsolateIndex = i;
                continue;
            }
            if (threadType.isAssignableFrom((ResolvedJavaType)type)) {
                VMError.guarantee(builtinThreadIndex == -1, "@%s built-in with more than one %s parameter: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), builtinCallee);
                builtinThreadIndex = i;
                continue;
            }
            VMError.shouldNotReachHere("@%s built-in currently may have only %s or %s parameters: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), IsolateThread.class.getSimpleName(), builtinCallee);
        }
        ValueNode[] args = kit.getInitialArguments().toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] builtinArgs = new ValueNode[builtinParamTypes.size()];
        if (builtinIsolateIndex != -1) {
            VMError.guarantee(executionContext.designatedIsolateIndex != -1 || executionContext.isolateCount == 1, "@%s built-in %s needs exactly one %s parameter: %s", CEntryPoint.class.getSimpleName(), this.entryPointData.getBuiltin(), Isolate.class.getSimpleName(), builtinCallee);
            index = executionContext.designatedIsolateIndex != -1 ? executionContext.designatedIsolateIndex : executionContext.lastIsolateIndex;
            builtinArgs[builtinIsolateIndex] = args[index];
        }
        if (builtinThreadIndex != -1) {
            VMError.guarantee(executionContext.designatedThreadIndex != -1 || executionContext.threadCount == 1, "@%s built-in %s needs exactly one %s parameter: %s", CEntryPoint.class.getSimpleName(), this.entryPointData.getBuiltin(), IsolateThread.class.getSimpleName(), builtinCallee);
            index = executionContext.designatedThreadIndex != -1 ? executionContext.designatedThreadIndex : executionContext.lastThreadIndex;
            builtinArgs[builtinThreadIndex] = args[index];
        }
        int invokeBci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((ResolvedJavaMethod)builtinCallee, CallTargetNode.InvokeKind.Static, kit.getFrameState(), invokeBci, builtinArgs);
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        this.generateExceptionHandler((ResolvedJavaMethod)method, kit, exception, invoke.getStackKind());
        kit.endInvokeWithException();
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCEntryPointEpilogue(kit, (ResolvedJavaMethod)method);
        }
        kit.createReturn((ValueNode)invoke, aTargetMethod.getSignature().getReturnKind());
        return kit.finalizeGraph();
    }

    private EnumInfo[] adaptParameterTypes(NativeLibraries nativeLibraries, HostedGraphKit kit, List<AnalysisType> parameterTypes, List<AnalysisType> parameterLoadTypes) {
        EnumInfo[] parameterEnumInfos = null;
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (CInterfaceEnumTool.isPrimitiveOrWord(parameterTypes.get(i))) continue;
            EnumInfo enumInfo = CEntryPointCallStubMethod.getEnumInfo(nativeLibraries, this.targetMethod, parameterTypes.get(i), false);
            UserError.guarantee(enumInfo.hasCEnumLookupMethods(), "Enum class %s needs a method that is annotated with @%s because it is used as a parameter of an entry point method: %s", parameterTypes.get(i), CEnumLookup.class.getSimpleName(), this.targetMethod);
            if (parameterEnumInfos == null) {
                parameterEnumInfos = new EnumInfo[parameterTypes.size()];
            }
            parameterEnumInfos[i] = enumInfo;
            AnalysisType paramType = CInterfaceEnumTool.getCEnumValueType(enumInfo, kit.getMetaAccess());
            parameterLoadTypes.set(i, paramType);
            int parameterIndex = i;
            FrameState initialState = kit.getGraph().start().stateAfter();
            Iterator matchingNodes = initialState.values().filter(node -> ((ParameterNode)node).index() == parameterIndex).iterator();
            ValueNode parameterNode = (ValueNode)matchingNodes.next();
            assert (!matchingNodes.hasNext() && parameterNode.usages().filter(n -> n != initialState).isEmpty());
            parameterNode.setStamp(StampFactory.forKind((JavaKind)paramType.getJavaKind()));
        }
        return parameterEnumInfos;
    }

    private static EnumInfo getEnumInfo(NativeLibraries nativeLibraries, ResolvedJavaMethod method, AnalysisType type, boolean isReturnType) {
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)type);
        if (typeInfo instanceof EnumInfo) {
            EnumInfo enumInfo = (EnumInfo)typeInfo;
            return enumInfo;
        }
        if (isReturnType) {
            throw UserError.abort("Entry point method return types are restricted to primitive types, word types and enumerations (@%s): %s, given type was %s", CEnum.class.getSimpleName(), method, type);
        }
        throw UserError.abort("Entry point method parameter types are restricted to primitive types, word types and enumerations (@%s): %s, given type was %s", CEnum.class.getSimpleName(), method, type);
    }

    private static void adaptArgumentValues(HostedGraphKit kit, List<AnalysisType> parameterTypes, EnumInfo[] parameterEnumInfos, ValueNode[] args) {
        if (parameterEnumInfos != null) {
            for (int i = 0; i < parameterEnumInfos.length; ++i) {
                if (parameterEnumInfos[i] == null) continue;
                args[i] = CInterfaceEnumTool.singleton().createInvokeLookupEnum(kit, parameterTypes.get(i), parameterEnumInfos[i], args[i]);
            }
        }
    }

    private InvokeWithExceptionNode generatePrologue(HostedGraphKit kit, List<AnalysisType> parameterTypes, Annotation[][] parameterAnnotations, ValueNode[] args) {
        Class<Object> prologueClass = this.entryPointData.getPrologue();
        if (prologueClass == CEntryPointOptions.NoPrologue.class) {
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)this.targetMethod), "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoPrologue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return null;
        }
        if (prologueClass != CEntryPointOptions.AutomaticPrologue.class) {
            AnalysisType prologue = kit.getMetaAccess().lookupJavaType(prologueClass);
            AnalysisMethod[] prologueMethods = prologue.getDeclaredMethods(false);
            UserError.guarantee(prologueMethods.length == 1 && prologueMethods[0].isStatic(), "Prologue class must declare exactly one static method: %s -> %s", this.targetMethod, prologue);
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)prologueMethods[0]), "Prologue method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), prologueMethods[0]);
            ValueNode[] prologueArgs = this.matchPrologueParameters(kit, parameterTypes, args, prologueMethods[0]);
            return CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, prologueMethods[0], prologueArgs);
        }
        ExecutionContextParameters executionContext = this.findExecutionContextParameters(kit, parameterTypes, parameterAnnotations);
        int contextIndex = -1;
        if (executionContext.designatedThreadIndex != -1) {
            contextIndex = executionContext.designatedThreadIndex;
        } else if (executionContext.threadCount == 1) {
            contextIndex = executionContext.lastThreadIndex;
        } else {
            UserError.abort("@%s requires exactly one execution context parameter of type %s: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
        }
        ValueNode contextValue = args[contextIndex];
        prologueClass = CEntryPointSetup.EnterPrologue.class;
        AnalysisMethod[] prologueMethods = kit.getMetaAccess().lookupJavaType(prologueClass).getDeclaredMethods(false);
        assert (prologueMethods.length == 1 && prologueMethods[0].isStatic()) : "Prologue class must declare exactly one static method";
        return CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, prologueMethods[0], contextValue);
    }

    private static InvokeWithExceptionNode generatePrologueOrEpilogueInvoke(SubstrateGraphKit kit, AnalysisMethod method, ValueNode ... args) {
        VMError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method), "The method %s must be uninterruptible as it is used for a prologue or epilogue.", method);
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((ResolvedJavaMethod)method, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), args);
        kit.exceptionPart();
        kit.append((Node)new DeadEndNode());
        kit.endInvokeWithException();
        return invoke;
    }

    private ExecutionContextParameters findExecutionContextParameters(HostedGraphKit kit, List<AnalysisType> parameterTypes, Annotation[][] parameterAnnotations) {
        AnalysisType isolateType = kit.getMetaAccess().lookupJavaType(Isolate.class);
        AnalysisType threadType = kit.getMetaAccess().lookupJavaType(IsolateThread.class);
        ExecutionContextParameters result = new ExecutionContextParameters();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            AnalysisType declaredType = parameterTypes.get(i);
            boolean isIsolate = isolateType.isAssignableFrom((ResolvedJavaType)declaredType);
            boolean isThread = threadType.isAssignableFrom((ResolvedJavaType)declaredType);
            boolean isLong = declaredType.getJavaKind() == JavaKind.Long;
            boolean designated = false;
            for (Annotation ann : parameterAnnotations[i]) {
                if (ann.annotationType() == CEntryPoint.IsolateContext.class) {
                    UserError.guarantee(isIsolate || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateContext.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                    designated = true;
                    isIsolate = true;
                    continue;
                }
                if (ann.annotationType() != CEntryPoint.IsolateThreadContext.class) continue;
                UserError.guarantee(isThread || isLong, "@%s parameter %d is annotated with @%s, but does not have type %s: %s", CEntryPoint.class.getSimpleName(), i, CEntryPoint.IsolateThreadContext.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
                designated = true;
                isThread = true;
            }
            UserError.guarantee(!isIsolate || !isThread, "@%s parameter %d has a type as both an %s and a %s: %s", CEntryPoint.class.getSimpleName(), i, Isolate.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            if (isIsolate) {
                result.lastIsolateIndex = i;
                ++result.isolateCount;
                if (!designated) continue;
                UserError.guarantee(result.designatedIsolateIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), Isolate.class.getSimpleName(), this.targetMethod);
                result.designatedIsolateIndex = i;
                continue;
            }
            if (!isThread) continue;
            result.lastThreadIndex = i;
            ++result.threadCount;
            if (!designated) continue;
            UserError.guarantee(result.designatedThreadIndex == -1, "@%s has more than one designated %s parameter: %s", CEntryPoint.class.getSimpleName(), IsolateThread.class.getSimpleName(), this.targetMethod);
            result.designatedThreadIndex = i;
        }
        return result;
    }

    private ValueNode[] matchPrologueParameters(HostedGraphKit kit, List<AnalysisType> types, ValueNode[] values, AnalysisMethod prologueMethod) {
        ValueNode[] prologueValues = new ValueNode[prologueMethod.getSignature().getParameterCount(false)];
        int i = 0;
        for (int p = 0; p < prologueValues.length; ++p) {
            AnalysisType prologueType = (AnalysisType)prologueMethod.getSignature().getParameterType(p);
            UserError.guarantee(prologueType.isPrimitive() || kit.getWordTypes().isWord((JavaType)prologueType), "Prologue method parameter types are restricted to primitive types and word types: %s -> %s", this.targetMethod, prologueMethod);
            while (i < types.size() && !prologueType.isAssignableFrom((ResolvedJavaType)types.get(i))) {
                ++i;
            }
            if (i >= types.size()) {
                throw UserError.abort("Unable to match signature of entry point method to that of prologue method: %s -> %s", this.targetMethod, prologueMethod);
            }
            prologueValues[p] = values[i];
            ++i;
        }
        return prologueValues;
    }

    private void generateExceptionHandler(ResolvedJavaMethod method, HostedGraphKit kit, ExceptionObjectNode exception, JavaKind returnKind) {
        if (this.entryPointData.getExceptionHandler() == CEntryPoint.FatalExceptionHandler.class) {
            CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)exception);
            kit.append((Node)leave);
            kit.append((Node)new LoweredDeadEndNode());
        } else {
            AnalysisType throwable = kit.getMetaAccess().lookupJavaType(Throwable.class);
            AnalysisType handler = kit.getMetaAccess().lookupJavaType(this.entryPointData.getExceptionHandler());
            AnalysisMethod[] handlerMethods = handler.getDeclaredMethods(false);
            UserError.guarantee(handlerMethods.length == 1 && handlerMethods[0].isStatic(), "Exception handler class must declare exactly one static method: %s -> %s", this.targetMethod, handler);
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)handlerMethods[0]), "Exception handler method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), handlerMethods[0]);
            List handlerParameterTypes = handlerMethods[0].toParameterList();
            UserError.guarantee(handlerParameterTypes.size() == 1 && ((AnalysisType)handlerParameterTypes.get(0)).isAssignableFrom((ResolvedJavaType)throwable), "Exception handler method must have exactly one parameter of type Throwable: %s -> %s", this.targetMethod, handlerMethods[0]);
            InvokeWithExceptionNode handlerInvoke = kit.startInvokeWithException((ResolvedJavaMethod)handlerMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{exception});
            kit.noExceptionPart();
            InvokeWithExceptionNode returnValue = handlerInvoke;
            if (handlerInvoke.getStackKind() != returnKind) {
                JavaKind fromKind = handlerInvoke.getStackKind();
                if (fromKind == JavaKind.Float && returnKind == JavaKind.Double) {
                    returnValue = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.F2D, (ValueNode)returnValue));
                } else if (fromKind.isUnsigned() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new ZeroExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else if (fromKind.isNumericInteger() && returnKind.isNumericInteger() && returnKind.getBitCount() > fromKind.getBitCount()) {
                    returnValue = kit.unique((FloatingNode)new SignExtendNode((ValueNode)returnValue, returnKind.getBitCount()));
                } else {
                    throw UserError.abort("Exception handler method return type must be assignable to entry point method return type: %s -> %s", this.targetMethod, handlerMethods[0]);
                }
            }
            this.generateEpilogueAndReturn(method, kit, (ValueNode)returnValue);
            kit.exceptionPart();
            kit.append((Node)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
            kit.append((Node)new LoweredDeadEndNode());
            kit.endInvokeWithException();
        }
    }

    private ValueNode adaptReturnValue(HostedGraphKit kit, ValueNode value) {
        if (value.getStackKind().isPrimitive()) {
            return value;
        }
        AnalysisType returnType = (AnalysisType)this.targetSignature.getReturnType();
        NativeLibraries nativeLibraries = NativeLibraries.singleton();
        EnumInfo enumInfo = CEntryPointCallStubMethod.getEnumInfo(nativeLibraries, this.targetMethod, returnType, true);
        ValueNode result = CInterfaceEnumTool.singleton().startInvokeWithExceptionEnumToValue(kit, enumInfo, CInterfaceEnumTool.getCEnumValueType(enumInfo, kit.getMetaAccess()), value);
        result = (ValueNode)kit.getGraph().unique((Node)new ZeroExtendNode(result, kit.getWordTypes().getWordKind().getBitCount()));
        kit.exceptionPart();
        kit.append((Node)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
        kit.append((Node)new LoweredDeadEndNode());
        kit.endInvokeWithException();
        return result;
    }

    private void generateEpilogue(HostedGraphKit kit) {
        Class<?> epilogueClass = this.entryPointData.getEpilogue();
        if (epilogueClass == CEntryPointOptions.NoEpilogue.class) {
            UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)this.targetMethod), "%s.%s is allowed only for methods annotated with @%s: %s", CEntryPointOptions.class.getSimpleName(), CEntryPointOptions.NoEpilogue.class.getSimpleName(), Uninterruptible.class.getSimpleName(), this.targetMethod);
            return;
        }
        AnalysisType epilogue = kit.getMetaAccess().lookupJavaType(epilogueClass);
        AnalysisMethod[] epilogueMethods = epilogue.getDeclaredMethods(false);
        UserError.guarantee(epilogueMethods.length == 1 && epilogueMethods[0].isStatic() && epilogueMethods[0].getSignature().getParameterCount(false) == 0, "Epilogue class must declare exactly one static method without parameters: %s -> %s", this.targetMethod, epilogue);
        UserError.guarantee(Uninterruptible.Utils.isUninterruptible((AnnotatedElement)epilogueMethods[0]), "Epilogue method must be annotated with @%s: %s", Uninterruptible.class.getSimpleName(), epilogueMethods[0]);
        CEntryPointCallStubMethod.generatePrologueOrEpilogueInvoke(kit, epilogueMethods[0], new ValueNode[0]);
    }

    public boolean isNotPublished() {
        return this.entryPointData.getPublishAs().equals((Object)CEntryPoint.Publish.NotPublished);
    }

    private static class ExecutionContextParameters {
        int isolateCount = 0;
        int lastIsolateIndex = -1;
        int designatedIsolateIndex = -1;
        int threadCount = 0;
        int lastThreadIndex = -1;
        int designatedThreadIndex = -1;

        private ExecutionContextParameters() {
        }
    }
}

