/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.c.enums.CEnumRuntimeData;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.impl.CConstantValueSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class CConstantValueSupportImpl
implements CConstantValueSupport {
    private final NativeLibraries nativeLibraries;
    private final MetaAccessProvider metaAccess;

    public CConstantValueSupportImpl(NativeLibraries nativeLibraries) {
        this.nativeLibraries = nativeLibraries;
        this.metaAccess = nativeLibraries.getMetaAccess();
    }

    public <T> T getCConstantValue(Class<?> declaringClass, String methodName, Class<T> returnType) {
        ResolvedJavaMethod method = this.getAnnotatedMethod(declaringClass, methodName, CConstant.class);
        ConstantInfo constantInfo = (ConstantInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)method);
        Object value = constantInfo.getValue();
        switch (constantInfo.getKind()) {
            case INTEGER: 
            case POINTER: {
                return (T)CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(this.nativeLibraries, returnType, (long)((Long)value), constantInfo.getSizeInBytes() * 8, constantInfo.isUnsigned());
            }
            case FLOAT: {
                if (returnType == Float.class) {
                    return returnType.cast(Float.valueOf(((Double)value).floatValue()));
                }
                return returnType.cast(value);
            }
            case STRING: 
            case BYTEARRAY: {
                return returnType.cast(value);
            }
        }
        throw VMError.shouldNotReachHere("Unexpected returnType: " + returnType.getName());
    }

    public <T> T getCEnumValue(Enum<?> cEnum, String methodName) {
        Class<?> declaringType = cEnum.getDeclaringClass();
        if (declaringType.getAnnotation(CEnum.class) == null) {
            throw VMError.shouldNotReachHere("Type " + String.valueOf(declaringType) + " is not annotated with @" + ClassUtil.getUnqualifiedName(CEnum.class));
        }
        ResolvedJavaMethod method = this.getAnnotatedMethod(declaringType, methodName, CEnumValue.class);
        ResolvedJavaType enumType = this.metaAccess.lookupJavaType(declaringType);
        EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)enumType);
        ResolvedJavaType returnType = (ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass());
        return (T)this.getCEnumValue(cEnum, returnType, enumInfo.getRuntimeData());
    }

    private Object getCEnumValue(Enum<?> cEnum, ResolvedJavaType returnType, CEnumRuntimeData data) {
        if (!this.nativeLibraries.isIntegerType(returnType)) {
            throw VMError.shouldNotReachHere("Unsupported return type: " + String.valueOf(returnType));
        }
        if (this.nativeLibraries.isWordBase(returnType)) {
            if (this.nativeLibraries.isSigned(returnType)) {
                return data.enumToSignedWord(cEnum);
            }
            return data.enumToUnsignedWord(cEnum);
        }
        JavaKind returnKind = returnType.getJavaKind();
        return switch (returnKind) {
            case JavaKind.Boolean -> data.enumToBoolean(cEnum);
            case JavaKind.Byte -> Byte.valueOf(data.enumToByte(cEnum));
            case JavaKind.Short -> Short.valueOf(data.enumToShort(cEnum));
            case JavaKind.Char -> Character.valueOf(data.enumToChar(cEnum));
            case JavaKind.Int -> Integer.valueOf(data.enumToInt(cEnum));
            case JavaKind.Long -> Long.valueOf(data.enumToLong(cEnum));
            default -> throw VMError.shouldNotReachHere("Unsupported return type: " + String.valueOf(returnType));
        };
    }

    private ResolvedJavaMethod getAnnotatedMethod(Class<?> declaringClass, String methodName, Class<? extends Annotation> annotationClass) {
        ResolvedJavaMethod method;
        try {
            method = this.metaAccess.lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(declaringClass, (String)methodName, (Class[])new Class[0]));
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            throw VMError.shouldNotReachHere("Method not found: " + declaringClass.getName() + "." + methodName);
        }
        if (method.getAnnotation(annotationClass) == null) {
            throw VMError.shouldNotReachHere("Method " + declaringClass.getName() + "." + methodName + " is not annotated with @" + ClassUtil.getUnqualifiedName(annotationClass));
        }
        return method;
    }
}

