/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.BootLoaderSupport;
import com.oracle.svm.hosted.ClassLoaderFeature;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.jdk.HostedClassLoaderPackageManagement;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class DynamicHubInitializer {
    private final BigBang bb;
    private final SVMHost hostVM;
    private final AnalysisMetaAccess metaAccess;
    private final ConstantReflectionProvider constantReflection;
    private final Map<InterfacesEncodingKey, DynamicHub[]> interfacesEncodings;
    private final Field dynamicHubClassInitializationInfoField;
    private final Field dynamicHubArrayHubField;
    private final Field dynamicHubInterfacesEncodingField;
    private final Field dynamicHubAnnotationsEnumConstantsReferenceField;

    public DynamicHubInitializer(BigBang bb) {
        this.bb = bb;
        this.metaAccess = bb.getMetaAccess();
        this.hostVM = (SVMHost)bb.getHostVM();
        this.constantReflection = bb.getConstantReflectionProvider();
        this.interfacesEncodings = new ConcurrentHashMap<InterfacesEncodingKey, DynamicHub[]>();
        this.dynamicHubClassInitializationInfoField = ReflectionUtil.lookupField(DynamicHub.class, (String)"classInitializationInfo");
        this.dynamicHubArrayHubField = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");
        this.dynamicHubInterfacesEncodingField = ReflectionUtil.lookupField(DynamicHub.class, (String)"interfacesEncoding");
        this.dynamicHubAnnotationsEnumConstantsReferenceField = ReflectionUtil.lookupField(DynamicHub.class, (String)"enumConstantsReference");
    }

    public void initializeMetaData(ImageHeapScanner heapScanner, AnalysisType type) {
        assert (type.isReachable()) : "Type " + type.toJavaName(true) + " is not marked as reachable.";
        AnalysisError.guarantee((!BuildPhaseProvider.isAnalysisFinished() ? 1 : 0) != 0, (String)"Initializing type metadata after analysis for %s.", (Object[])new Object[]{type.toJavaName(true)});
        Class javaClass = type.getJavaClass();
        DynamicHub hub = this.hostVM.dynamicHub((ResolvedJavaType)type);
        if (!(type.getWrapped() instanceof BaseLayerType)) {
            DynamicHubInitializer.registerPackage(heapScanner, javaClass, hub);
        }
        boolean rescan = true;
        if (this.hostVM.useBaseLayer()) {
            ImageHeapConstant hubConstant = (ImageHeapConstant)heapScanner.createImageHeapConstant((Object)hub, ObjectScanner.OtherReason.HUB);
            boolean bl = rescan = hubConstant == null || !hubConstant.isInBaseLayer();
        }
        if (rescan) {
            heapScanner.rescanObject((Object)hub, ObjectScanner.OtherReason.HUB);
        }
        this.buildClassInitializationInfo(heapScanner, type, hub, rescan);
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray()) {
                AnalysisError.guarantee((hub.getComponentHub().getArrayHub() == null ? 1 : 0) != 0, (String)"Array hub already initialized for %s.", (Object[])new Object[]{type.getComponentType().toJavaName(true)});
                hub.getComponentHub().setArrayHub(hub);
                if (rescan) {
                    heapScanner.rescanField((Object)hub.getComponentHub(), this.dynamicHubArrayHubField);
                }
            }
            this.fillInterfaces(type, hub);
            if (rescan) {
                heapScanner.rescanField((Object)hub, this.dynamicHubInterfacesEncodingField);
            }
            if (type.isEnum()) {
                AnalysisError.guarantee((boolean)hub.shouldInitEnumConstants(), (String)"Enum constants already initialized for %s.", (Object[])new Object[]{type.toJavaName(true)});
                if (!this.hostVM.getClassInitializationSupport().maybeInitializeAtBuildTime((ResolvedJavaType)type)) {
                    hub.initEnumConstantsAtRuntime(javaClass);
                } else {
                    hub.initEnumConstants(this.retrieveEnumConstantArray(type, javaClass));
                }
                if (rescan) {
                    heapScanner.rescanField((Object)hub, this.dynamicHubAnnotationsEnumConstantsReferenceField);
                }
            }
        }
    }

    private static void registerPackage(ImageHeapScanner heapScanner, Class<?> javaClass, DynamicHub hub) {
        Package packageValue = javaClass.getPackage();
        if (packageValue != null) {
            ClassLoader runtimeClassLoader;
            ClassLoader classloader = javaClass.getClassLoader();
            if (classloader == null) {
                classloader = BootLoaderSupport.getBootLoader();
            }
            VMError.guarantee((runtimeClassLoader = ClassLoaderFeature.getRuntimeClassLoader(classloader)) != null, "Class loader missing for class %s", hub.getName());
            String packageName = hub.getPackageName();
            assert (packageName.equals(packageValue.getName())) : Assertions.errorMessage((Object[])new Object[]{"Package name mismatch:", packageName, packageValue.getName()});
            HostedClassLoaderPackageManagement.singleton().registerPackage(runtimeClassLoader, packageName, packageValue, arg_0 -> ((ImageHeapScanner)heapScanner).rescanObject(arg_0));
        }
    }

    private Enum<?>[] retrieveEnumConstantArray(AnalysisType type, Class<?> javaClass) {
        Enum[] enumConstants;
        AnalysisField found = null;
        for (ResolvedJavaField javaField : type.getStaticFields()) {
            AnalysisField f = (AnalysisField)javaField;
            if (!f.getName().endsWith("$VALUES")) continue;
            if (found != null) {
                found = null;
                break;
            }
            found = f;
        }
        if (found == null) {
            enumConstants = (Enum[])javaClass.getEnumConstants();
        } else {
            enumConstants = (Enum[])this.bb.getSnippetReflectionProvider().asObject(Enum[].class, this.constantReflection.readFieldValue(found, null));
            assert (enumConstants != null);
        }
        return enumConstants;
    }

    private void buildClassInitializationInfo(ImageHeapScanner heapScanner, AnalysisType type, DynamicHub hub, boolean rescan) {
        ClassInitializationInfo info;
        AnalysisError.guarantee((hub.getClassInitializationInfo() == null ? 1 : 0) != 0, (String)"Class initialization info already computed for %s.", (Object[])new Object[]{type.toJavaName(true)});
        boolean initializedAtBuildTime = SimulateClassInitializerSupport.singleton().trySimulateClassInitializer(this.bb, type);
        if (type.getWrapped() instanceof BaseLayerType) {
            info = HostedImageLayerBuildingSupport.singleton().getLoader().getClassInitializationInfo(type);
        } else {
            boolean typeReachedTracked = ClassInitializationSupport.singleton().requiresInitializationNodeForTypeReached((ResolvedJavaType)type);
            info = initializedAtBuildTime ? (type.getClassInitializer() == null ? ClassInitializationInfo.forNoInitializerInfo(typeReachedTracked) : ClassInitializationInfo.forInitializedInfo(typeReachedTracked)) : this.buildRuntimeInitializationInfo(type, typeReachedTracked);
        }
        hub.setClassInitializationInfo(info);
        if (rescan) {
            heapScanner.rescanField((Object)hub, this.dynamicHubClassInitializationInfoField);
        }
    }

    private ClassInitializationInfo buildRuntimeInitializationInfo(AnalysisType type, boolean typeReachedTracked) {
        assert (!type.isInitialized());
        try {
            type.link();
        }
        catch (VerifyError e) {
            AnalysisMethod throwVerifyError = this.metaAccess.lookupJavaMethod((Executable)ExceptionSynthesizer.throwExceptionMethod(VerifyError.class));
            this.bb.addRootMethod(throwVerifyError, true, (Object)("Class initialization error, registered in " + String.valueOf(DynamicHubInitializer.class)), new MultiMethod.MultiMethodKey[0]);
            return new ClassInitializationInfo(new MethodPointer((ResolvedJavaMethod)throwVerifyError), typeReachedTracked);
        }
        catch (Throwable t) {
            return ClassInitializationInfo.forFailedInfo(typeReachedTracked);
        }
        assert (type.isLinked());
        MethodPointer classInitializerFunction = null;
        AnalysisMethod classInitializer = type.getClassInitializer();
        if (classInitializer != null) {
            assert (classInitializer.getCode() != null);
            this.bb.addRootMethod(classInitializer, true, (Object)("Class initialization, registered in " + String.valueOf(DynamicHubInitializer.class)), new MultiMethod.MultiMethodKey[0]);
            classInitializerFunction = new MethodPointer((ResolvedJavaMethod)classInitializer);
        }
        return new ClassInitializationInfo(classInitializerFunction, typeReachedTracked);
    }

    private void fillInterfaces(AnalysisType type, DynamicHub hub) {
        AnalysisError.guarantee((hub.getInterfacesEncoding() == null ? 1 : 0) != 0, (String)"Interfaces already computed for %s.", (Object[])new Object[]{type.toJavaName(true)});
        AnalysisType[] aInterfaces = type.getInterfaces();
        if (aInterfaces.length == 0) {
            hub.setInterfacesEncoding(null);
        } else if (aInterfaces.length == 1) {
            hub.setInterfacesEncoding(this.hostVM.dynamicHub((ResolvedJavaType)aInterfaces[0]));
        } else {
            hub.setInterfacesEncoding(this.interfacesEncodings.computeIfAbsent(new InterfacesEncodingKey(aInterfaces), InterfacesEncodingKey::createHubs));
        }
    }

    class InterfacesEncodingKey {
        final AnalysisType[] aInterfaces;

        InterfacesEncodingKey(AnalysisType[] aInterfaces) {
            this.aInterfaces = aInterfaces;
        }

        DynamicHub[] createHubs() {
            DynamicHub[] hubs = new DynamicHub[this.aInterfaces.length];
            for (int i = 0; i < hubs.length; ++i) {
                hubs[i] = DynamicHubInitializer.this.hostVM.dynamicHub((ResolvedJavaType)this.aInterfaces[i]);
            }
            return hubs;
        }

        public boolean equals(Object obj) {
            return obj instanceof InterfacesEncodingKey && Arrays.equals(this.aInterfaces, ((InterfacesEncodingKey)obj).aInterfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.aInterfaces);
        }
    }
}

