/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class HostedDynamicHubFeature
implements InternalFeature {
    private AnalysisMetaAccess metaAccess;
    private SVMHost hostVM;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.metaAccess = access.getMetaAccess();
        this.hostVM = access.getHostVM();
        access.registerObjectReplacer(this::replace);
    }

    private Object replace(Object source) {
        if (source instanceof Class) {
            Class clazz = (Class)source;
            DynamicHub dynamicHub = this.hostVM.dynamicHub((ResolvedJavaType)this.metaAccess.lookupJavaType(clazz));
            return dynamicHub;
        }
        return source;
    }
}

