/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.module.Modules;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ClassLoaderSupportImpl
extends ClassLoaderSupport {
    private final NativeImageClassLoaderSupport classLoaderSupport;
    private final NativeImageClassLoader imageClassLoader;
    private final Map<String, Set<Module>> packageToModules;

    public ClassLoaderSupportImpl(NativeImageClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
        this.imageClassLoader = classLoaderSupport.getClassLoader();
        this.packageToModules = new HashMap<String, Set<Module>>();
        this.buildPackageToModulesMap(classLoaderSupport);
    }

    @Override
    protected boolean isNativeImageClassLoaderImpl(ClassLoader loader) {
        if (loader == this.imageClassLoader) {
            return true;
        }
        return loader instanceof NativeImageSystemClassLoader;
    }

    private static Stream<ResourceLookupInfo> extractModuleLookupData(ModuleLayer layer) {
        ArrayList<ResourceLookupInfo> data = new ArrayList<ResourceLookupInfo>(layer.configuration().modules().size());
        for (ResolvedModule m : layer.configuration().modules()) {
            Module module = layer.findModule(m.name()).orElse(null);
            ResourceLookupInfo info = new ResourceLookupInfo(m, module);
            data.add(info);
        }
        return data.stream();
    }

    @Override
    public void collectResources(ClassLoaderSupport.ResourceCollector resourceCollector) {
        ((Stream)NativeImageClassLoaderSupport.allLayers(this.classLoaderSupport.moduleLayerForImageBuild).stream().flatMap(ClassLoaderSupportImpl::extractModuleLookupData).parallel()).forEach(lookup -> this.collectResourceFromModule(resourceCollector, (ResourceLookupInfo)lookup));
        ((Stream)this.classLoaderSupport.classpath().stream().parallel()).forEach(classpathFile -> {
            boolean includeCurrent = this.classLoaderSupport.getJavaPathsToInclude().contains(classpathFile) || this.classLoaderSupport.includeAllFromClassPath();
            try {
                if (Files.isDirectory(classpathFile, new LinkOption[0])) {
                    ClassLoaderSupportImpl.scanDirectory(classpathFile, resourceCollector, includeCurrent);
                } else if (ClasspathUtils.isJar(classpathFile)) {
                    ClassLoaderSupportImpl.scanJar(classpathFile, resourceCollector, includeCurrent);
                }
            }
            catch (IOException ex) {
                throw UserError.abort("Unable to handle classpath element '%s'. Make sure that all classpath entries are either directories or valid jar files.", classpathFile);
            }
        });
    }

    private void collectResourceFromModule(ClassLoaderSupport.ResourceCollector resourceCollector, ResourceLookupInfo info) {
        ModuleReference moduleReference = info.resolvedModule.reference();
        try (ModuleReader moduleReader = moduleReference.open();){
            boolean includeCurrent = this.classLoaderSupport.getJavaModuleNamesToInclude().contains(info.resolvedModule().name());
            ArrayList resourcesFound = new ArrayList();
            moduleReader.list().forEach(resourceName -> {
                List<ClassLoaderSupport.ConditionWithOrigin> conditionsWithOrigins = ClassLoaderSupportImpl.shouldIncludeEntry(info.module, resourceCollector, resourceName, moduleReference.location().orElse(null), includeCurrent);
                for (ClassLoaderSupport.ConditionWithOrigin conditionWithOrigin : conditionsWithOrigins) {
                    resourcesFound.add(new ConditionalResource(conditionWithOrigin.condition(), (String)resourceName, conditionWithOrigin.origin()));
                }
            });
            for (ConditionalResource entry : resourcesFound) {
                String resName = entry.resourceName();
                if (resName.endsWith("/")) {
                    ClassLoaderSupportImpl.includeResource(resourceCollector, info.module, resName, entry.condition(), entry.origin());
                    continue;
                }
                Optional<InputStream> content = moduleReader.open(resName);
                if (content.isEmpty()) {
                    resourceCollector.registerNegativeQuery(info.module, resName);
                    continue;
                }
                ClassLoaderSupportImpl.includeResource(resourceCollector, info.module, resName, entry.condition(), entry.origin());
            }
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static void scanDirectory(Path root, ClassLoaderSupport.ResourceCollector collector, boolean includeCurrent) {
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.push(root);
        while (!queue.isEmpty()) {
            Path entry = (Path)queue.pop();
            String relativeFilePath = entry != root ? root.relativize(entry).toString().replace(File.separatorChar, '/') : String.valueOf('/');
            List<ClassLoaderSupport.ConditionWithOrigin> conditionsWithOrigins = ClassLoaderSupportImpl.shouldIncludeEntry(null, collector, relativeFilePath, Path.of(relativeFilePath, new String[0]).toUri(), includeCurrent);
            for (ClassLoaderSupport.ConditionWithOrigin conditionWithOrigin : conditionsWithOrigins) {
                ClassLoaderSupportImpl.includeResource(collector, null, relativeFilePath, conditionWithOrigin.condition(), conditionWithOrigin.origin());
            }
            if (!Files.isDirectory(entry, new LinkOption[0])) continue;
            if (conditionsWithOrigins.isEmpty()) {
                collector.registerNegativeQuery(null, relativeFilePath);
            }
            try {
                Stream<Path> pathStream = Files.list(entry);
                try {
                    Stream<Path> filtered = pathStream;
                    if (ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT.equals(entry)) {
                        filtered = filtered.filter(Predicate.not(ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES::contains));
                    }
                    filtered.forEach(queue::push);
                }
                finally {
                    if (pathStream == null) continue;
                    pathStream.close();
                }
            }
            catch (IOException resourceException) {
                collector.registerIOException(null, relativeFilePath, resourceException, LinkAtBuildTimeSupport.singleton().packageOrClassAtBuildTime(relativeFilePath));
            }
        }
    }

    private static void scanJar(Path jarPath, ClassLoaderSupport.ResourceCollector collector, boolean includeCurrent) throws IOException {
        try (JarFile jf = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    entryName = entryName.substring(0, entry.getName().length() - 1);
                }
                List<ClassLoaderSupport.ConditionWithOrigin> conditionsWithOrigins = ClassLoaderSupportImpl.shouldIncludeEntry(null, collector, entryName, jarPath.toUri(), includeCurrent);
                for (ClassLoaderSupport.ConditionWithOrigin conditionWithOrigin : conditionsWithOrigins) {
                    ClassLoaderSupportImpl.includeResource(collector, null, entryName, conditionWithOrigin.condition(), conditionWithOrigin.origin());
                }
            }
        }
    }

    private static void includeResource(ClassLoaderSupport.ResourceCollector collector, Module module, String name, ConfigurationCondition condition, Object origin) {
        collector.addResourceConditionally(module, name, condition, origin);
    }

    private static List<ClassLoaderSupport.ConditionWithOrigin> shouldIncludeEntry(Module module, ClassLoaderSupport.ResourceCollector collector, String fileName, URI uri, boolean includeCurrent) {
        if (includeCurrent && !fileName.endsWith(".class") && !fileName.endsWith(".jar")) {
            return Collections.singletonList(new ClassLoaderSupport.ConditionWithOrigin(ConfigurationCondition.alwaysTrue(), "Include all"));
        }
        return collector.isIncluded(module, fileName, uri);
    }

    @Override
    public List<ResourceBundle> getResourceBundle(String bundleSpec, Locale locale) {
        String bundleName;
        String moduleName;
        String[] specParts = bundleSpec.split(":", 2);
        if (specParts.length > 1) {
            moduleName = specParts[0];
            bundleName = specParts[1];
        } else {
            moduleName = null;
            bundleName = specParts[0];
        }
        bundleName = bundleName.replace("/", ".");
        String packageName = ClassLoaderSupportImpl.packageName(bundleName);
        Set<Module> modules = "ALL-UNNAMED".equals(moduleName) ? Collections.emptySet() : (moduleName != null ? this.classLoaderSupport.findModule(moduleName).stream().collect(Collectors.toSet()) : this.packageToModules.getOrDefault(packageName, Collections.emptySet()));
        if (modules.isEmpty()) {
            return Collections.singletonList(ResourceBundle.getBundle(bundleName, locale, this.imageClassLoader));
        }
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        Module builderModule = ClassLoaderSupportImpl.class.getModule();
        for (Module module : modules) {
            if (builderModule.isNamed()) {
                Modules.addOpens(module, packageName, builderModule);
            } else {
                Modules.addOpensToAllUnnamed(module, packageName);
            }
            resourceBundles.add(ResourceBundle.getBundle(bundleName, locale, module));
        }
        return resourceBundles;
    }

    @Override
    public Map<String, Set<Module>> getPackageToModules() {
        return this.packageToModules;
    }

    private static String packageName(String bundleName) {
        int classSep = bundleName.lastIndexOf(46);
        if (classSep == -1) {
            return "";
        }
        return bundleName.substring(0, classSep);
    }

    private void buildPackageToModulesMap(NativeImageClassLoaderSupport cls) {
        for (ModuleLayer layer : NativeImageClassLoaderSupport.allLayers(cls.moduleLayerForImageBuild)) {
            for (Module module : layer.modules()) {
                for (String packageName : module.getDescriptor().packages()) {
                    this.addToPackageNameModules(module, packageName);
                }
            }
        }
    }

    private void addToPackageNameModules(Module moduleName, String packageName) {
        Set<Module> prevValue = this.packageToModules.get(packageName);
        if (prevValue == null) {
            this.packageToModules.put(packageName, Collections.singleton(moduleName));
        } else if (prevValue.size() == 1) {
            HashSet<Module> newValue = new HashSet<Module>();
            newValue.add(prevValue.iterator().next());
            newValue.add(moduleName);
            this.packageToModules.put(packageName, newValue);
        } else if (prevValue.size() > 1) {
            prevValue.add(moduleName);
        }
    }

    private record ResourceLookupInfo(ResolvedModule resolvedModule, Module module) {
    }

    private record ConditionalResource(ConfigurationCondition condition, String resourceName, Object origin) {
    }
}

