/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

public class ByteFormattingUtil {
    private static final double BYTES_TO_KiB = 1024.0;
    private static final double BYTES_TO_MiB = 1048576.0;
    private static final double BYTES_TO_GiB = 1.073741824E9;

    public static String bytesToHuman(long bytes) {
        return ByteFormattingUtil.bytesToHuman("%4.2f", bytes);
    }

    public static String bytesToHuman(String format, long bytes) {
        if ((double)bytes < 1024.0) {
            return String.format(format, bytes) + "B";
        }
        if ((double)bytes < 1048576.0) {
            return String.format(format, ByteFormattingUtil.bytesToKiB(bytes)) + "kB";
        }
        if ((double)bytes < 1.073741824E9) {
            return String.format(format, ByteFormattingUtil.bytesToMiB(bytes)) + "MB";
        }
        return String.format(format, ByteFormattingUtil.bytesToGiB(bytes)) + "GB";
    }

    static double bytesToKiB(long bytes) {
        return (double)bytes / 1024.0;
    }

    static double bytesToGiB(long bytes) {
        return (double)bytes / 1.073741824E9;
    }

    static double bytesToMiB(long bytes) {
        return (double)bytes / 1048576.0;
    }
}

