/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.SignalHandlerSupport;
import com.oracle.svm.core.jdk.Target_jdk_internal_misc_Signal;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.WinBase;
import java.util.Locale;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={SignalHandlerSupport.class})
public class WindowsSignalHandlerSupport
implements SignalHandlerSupport {
    private static final int NEAR_MAX_PRIORITY = 9;
    private Thread dispatcherThread;
    private boolean initialized;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public WindowsSignalHandlerSupport() {
    }

    @Override
    public long installJavaSignalHandler(int sig, long nativeH) {
        assert (MonitorSupport.singleton().isLockedByCurrentThread(Target_jdk_internal_misc_Signal.class));
        this.ensureInitialized();
        return Jvm.JVM_RegisterSignal(sig, (VoidPointer)WordFactory.pointer((long)nativeH)).rawValue();
    }

    private void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        if (!Isolates.isCurrentFirst()) {
            throw new IllegalArgumentException("Only the first isolate can install signal handlers, as signal handling is global for the process.");
        }
        if (!WindowsSignalHandlerSupport.jdkMiscSignalInit()) {
            VMError.shouldNotReachHere("Native state initialization for jdk.internal.misc.Signal failed with error code: 0x" + Integer.toUnsignedString(WinBase.GetLastError(), 16).toUpperCase(Locale.ROOT));
        }
        this.startDispatcherThread();
        this.initialized = true;
    }

    private void startDispatcherThread() {
        this.dispatcherThread = new DispatcherThread();
        this.dispatcherThread.start();
    }

    @Override
    public void stopDispatcherThread() {
        if (!this.initialized) {
            return;
        }
        WindowsSignalHandlerSupport.osTerminateSignalThread();
        try {
            this.dispatcherThread.join();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void onIsolateTeardown() {
    }

    @CFunction(value="os__signal_wait")
    private static native int osSignalWait();

    @CFunction(value="os__sigexitnum_pd", transition=CFunction.Transition.NO_TRANSITION)
    private static native int osSigexitnumPd();

    @CFunction(value="jdk_misc_signal_init", transition=CFunction.Transition.NO_TRANSITION)
    private static native boolean jdkMiscSignalInit();

    @CFunction(value="os__terminate_signal_thread", transition=CFunction.Transition.NO_TRANSITION)
    private static native void osTerminateSignalThread();

    private static class DispatcherThread
    extends Thread {
        DispatcherThread() {
            super(PlatformThreads.singleton().systemGroup, "Signal Dispatcher");
            this.setPriority(9);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int sig;
            while ((sig = WindowsSignalHandlerSupport.osSignalWait()) != WindowsSignalHandlerSupport.osSigexitnumPd()) {
                Target_jdk_internal_misc_Signal.dispatch(sig);
            }
            return;
        }
    }
}

