/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class JavaFrameAnchors {
    static final SnippetRuntime.SubstrateForeignCallDescriptor VERIFY_FRAME_ANCHOR_STUB = SnippetRuntime.findForeignCall(JavaFrameAnchors.class, "verifyFrameAnchorStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final FastThreadLocalWord<JavaFrameAnchor> lastAnchorTL = (FastThreadLocalWord)FastThreadLocalFactory.createWord("JavaFrameAnchors.lastAnchor").setMaxOffset(127);
    private static final FastThreadLocalInt verificationInProgressTL = FastThreadLocalFactory.createInt("JavaFrameAnchors.verificationInProgress");

    public static void pushFrameAnchor(JavaFrameAnchor newAnchor) {
        if (SubstrateOptions.VerifyFrameAnchors.getValue().booleanValue()) {
            newAnchor.setMagicBefore(-81985529216486896L);
            newAnchor.setMagicAfter(-81985529216486896L);
        }
        newAnchor.setLastJavaIP((CodePointer)WordFactory.nullPointer());
        newAnchor.setLastJavaSP((Pointer)WordFactory.nullPointer());
        JavaFrameAnchor prev = lastAnchorTL.get();
        newAnchor.setPreviousAnchor(prev);
        lastAnchorTL.set(newAnchor);
        JavaFrameAnchors.verifyFrameAnchor(true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void popFrameAnchor() {
        JavaFrameAnchors.verifyFrameAnchor(false);
        JavaFrameAnchor cur = lastAnchorTL.get();
        JavaFrameAnchor prev = cur.getPreviousAnchor();
        lastAnchorTL.set(prev);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor() {
        return lastAnchorTL.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        return lastAnchorTL.get(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchor(boolean newAnchor) {
        if (SubstrateOptions.VerifyFrameAnchors.getValue().booleanValue()) {
            JavaFrameAnchors.call(VERIFY_FRAME_ANCHOR_STUB, newAnchor);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchorStub(boolean newAnchor) {
        if (verificationInProgressTL.get() != 0 || SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            return;
        }
        verificationInProgressTL.set(verificationInProgressTL.get() + 1);
        try {
            JavaFrameAnchor cur = lastAnchorTL.get();
            JavaFrameAnchors.verifyFrameAnchor(cur, newAnchor);
            JavaFrameAnchor prev = cur.getPreviousAnchor();
            if (prev.isNonNull()) {
                JavaFrameAnchors.verifyFrameAnchor(prev, false);
            }
        }
        finally {
            verificationInProgressTL.set(verificationInProgressTL.get() - 1);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchor(JavaFrameAnchor cur, boolean newAnchor) {
        VMError.guarantee(VMThreads.StatusSupport.getStatusVolatile() == 1, "Invalid thread status.");
        VMError.guarantee(((Pointer)cur).aboveOrEqual((UnsignedWord)KnownIntrinsics.readStackPointer()), "The frame anchor struct is outside of the used stack.");
        VMError.guarantee(cur.getMagicBefore() == -81985529216486896L, "Corrupt frame anchor: magic before");
        VMError.guarantee(cur.getMagicAfter() == -81985529216486896L, "Corrupt frame anchor: magic after");
        VMError.guarantee(newAnchor == cur.getLastJavaIP().isNull(), "Corrupt frame anchor: invalid IP");
        VMError.guarantee(newAnchor == cur.getLastJavaSP().isNull(), "Corrupt frame anchor: invalid SP");
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void call(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1);
}

