/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.UnreachableNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class ExceptionUnwind {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS = SnippetRuntime.findForeignCall(ExceptionUnwind.class, "unwindExceptionWithoutCalleeSavedRegisters", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS = SnippetRuntime.findForeignCall(ExceptionUnwind.class, "unwindExceptionWithCalleeSavedRegisters", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS, UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS};
    public static final FastThreadLocalObject<Throwable> currentException = FastThreadLocalFactory.createObject(Throwable.class, "ExceptionUnwind.currentException");

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean exceptionsAreFatal() {
        return !VMThreads.StatusSupport.isStatusJava();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not execute recurring callbacks or a stack overflow check.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when unwinding the stack.")
    private static void unwindExceptionWithoutCalleeSavedRegisters(Throwable exception, Pointer callerSP) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        ExceptionUnwind.unwindExceptionInterruptible(exception, callerSP, false);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not execute recurring callbacks or a stack overflow check.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when unwinding the stack.")
    private static void unwindExceptionWithCalleeSavedRegisters(Throwable exception, Pointer callerSP) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        ExceptionUnwind.unwindExceptionInterruptible(exception, callerSP, true);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when unwinding the stack.")
    private static void unwindExceptionInterruptible(Throwable exception, Pointer callerSP, boolean fromMethodWithCalleeSavedRegisters) {
        if (currentException.get() != null) {
            ExceptionUnwind.reportRecursiveUnwind(exception);
            return;
        }
        currentException.set(exception);
        if (ExceptionUnwind.exceptionsAreFatal()) {
            ExceptionUnwind.reportFatalUnwind(exception);
            return;
        }
        if (ImageSingletons.contains(ExceptionUnwind.class)) {
            ((ExceptionUnwind)ImageSingletons.lookup(ExceptionUnwind.class)).customUnwindException(callerSP);
        } else {
            ExceptionUnwind.defaultUnwindException(callerSP, fromMethodWithCalleeSavedRegisters);
        }
        ExceptionUnwind.reportUnhandledException(exception);
    }

    private static void reportRecursiveUnwind(Throwable exception) {
        Log.log().string("Fatal error: recursion in exception handling: ").string(exception.getClass().getName());
        Log.log().string(" thrown while unwinding ").string(currentException.get().getClass().getName()).newline().newline();
        VMError.shouldNotReachHere("Recursion in exception handling");
    }

    private static void reportFatalUnwind(Throwable exception) {
        Log.log().string("Fatal error: exception unwind while thread is not in Java state: ");
        Log.log().exception(exception).newline().newline();
        VMError.shouldNotReachHere("Exception unwind while thread is not in Java state");
    }

    private static void reportUnhandledException(Throwable exception) {
        Log.log().string("Fatal error: unhandled exception in isolate ").hex((WordBase)CurrentIsolate.getIsolate()).string(": ");
        Log.log().exception(exception).newline().newline();
        VMError.shouldNotReachHere("Unhandled exception");
    }

    protected abstract void customUnwindException(Pointer var1);

    @Uninterruptible(reason="Prevent deoptimization apart from the few places explicitly considered safe for deoptimization")
    private static void defaultUnwindException(Pointer startSP, boolean fromMethodWithCalleeSavedRegisters) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        boolean hasCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initialize(walk, thread, startSP);
        while (JavaStackWalker.advance(walk, thread)) {
            DeoptimizedFrame deoptFrame;
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Exception unwinding must not encounter unknown frame");
            Pointer sp = frame.getSP();
            if (DeoptimizationSupport.enabled() && (deoptFrame = Deoptimizer.checkDeoptimized(frame)) != null) {
                ExceptionUnwind.deoptTakeExceptionInterruptible(deoptFrame);
                ExceptionUnwind.jumpToHandler(sp, (CodePointer)DeoptimizationSupport.getDeoptStubPointer(), hasCalleeSavedRegisters);
                UnreachableNode.unreachable();
                return;
            }
            long exceptionOffset = frame.getExceptionOffset();
            if (exceptionOffset != 0L) {
                CodePointer handlerIP = (CodePointer)((UnsignedWord)frame.getIP()).add((UnsignedWord)WordFactory.signed((long)exceptionOffset));
                ExceptionUnwind.jumpToHandler(sp, handlerIP, hasCalleeSavedRegisters);
                UnreachableNode.unreachable();
                return;
            }
            VMError.guarantee(!JavaFrames.isEntryPoint(frame), "Entry point methods must have an exception handler.");
            hasCalleeSavedRegisters = CodeInfoQueryResult.hasCalleeSavedRegisters(frame.getEncodedFrameSize());
        }
    }

    @Uninterruptible(reason="Prevent deoptimization while dispatching to exception handler")
    private static void jumpToHandler(Pointer sp, CodePointer handlerIP, boolean hasCalleeSavedRegisters) {
        Throwable exception = currentException.get();
        currentException.set(null);
        StackOverflowCheck.singleton().protectYellowZone();
        if (hasCalleeSavedRegisters) {
            KnownIntrinsics.farReturn(exception, sp, handlerIP, true);
        } else {
            KnownIntrinsics.farReturn(exception, sp, handlerIP, false);
        }
    }

    @Uninterruptible(reason="Wrap call to interruptible code.", calleeMustBe=false)
    private static void deoptTakeExceptionInterruptible(DeoptimizedFrame deoptFrame) {
        deoptFrame.takeException();
    }
}

