/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.JNIThreadLocalEnvironment;
import com.oracle.svm.core.jni.JNIThreadLocalPendingException;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import org.graalvm.word.PointerBase;

public final class JNIGeneratedMethodSupport {
    static PointerBase nativeCallAddress(JNINativeLinkage linkage) {
        return linkage.getOrFindEntryPoint();
    }

    static int nativeCallPrologue() {
        return JNIObjectHandles.pushLocalFrame(16);
    }

    @Uninterruptible(reason="Must not throw any exceptions - otherwise, we might leak memory.")
    static void nativeCallEpilogue(int handleFrame) {
        JNIObjectHandles.popLocalFramesIncluding(handleFrame);
    }

    static JNIEnvironment environment() {
        return JNIThreadLocalEnvironment.getAddress();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static JNIObjectHandle boxObjectInLocalHandle(Object obj) {
        return JNIObjectHandles.createLocal(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Object unboxHandle(JNIObjectHandle handle) {
        return JNIObjectHandles.getObject(handle);
    }

    @Uninterruptible(reason="Must not throw any exceptions.")
    static void setPendingException(Throwable t) {
        JNIThreadLocalPendingException.set(t);
    }

    @Uninterruptible(reason="Must not throw any exceptions.")
    static Throwable getAndClearPendingException() {
        Throwable t = JNIThreadLocalPendingException.get();
        JNIThreadLocalPendingException.clear();
        return t;
    }

    @Uninterruptible(reason="Must not throw any exceptions, except for the pending exception.")
    static void rethrowPendingException() throws Throwable {
        Throwable t = JNIGeneratedMethodSupport.getAndClearPendingException();
        if (t != null) {
            throw t;
        }
    }
}

