/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.internal.misc.Unsafe;
import jdk.jfr.internal.event.EventWriter;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class JfrEventWriterAccess {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final Field VALID_FIELD = ReflectionUtil.lookupField(EventWriter.class, (String)"valid");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEventWriterAccess() {
    }

    public static Target_jdk_jfr_internal_event_EventWriter newEventWriter(JfrBuffer buffer, boolean isCurrentThreadExcluded) {
        assert (JfrBufferAccess.isEmpty(buffer)) : "a fresh JFR buffer must be empty";
        long committedPos = buffer.getCommittedPos().rawValue();
        long maxPos = JfrBufferAccess.getDataEnd(buffer).rawValue();
        long jfrThreadId = SubstrateJVM.getCurrentThreadId();
        if (JavaVersionUtil.JAVA_SPEC <= 21) {
            return new Target_jdk_jfr_internal_event_EventWriter(committedPos, maxPos, jfrThreadId, true, isCurrentThreadExcluded);
        }
        boolean pinVirtualThread = JavaThreads.isCurrentThreadVirtual();
        return new Target_jdk_jfr_internal_event_EventWriter(committedPos, maxPos, jfrThreadId, true, pinVirtualThread, isCurrentThreadExcluded);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void update(Target_jdk_jfr_internal_event_EventWriter writer, JfrBuffer buffer, int uncommittedSize, boolean valid) {
        assert (SubstrateJVM.getThreadLocal().getJavaBuffer() == buffer);
        assert (JfrBufferAccess.verify(buffer));
        Pointer committedPos = buffer.getCommittedPos();
        Pointer currentPos = committedPos.add(uncommittedSize);
        Pointer maxPos = JfrBufferAccess.getDataEnd(buffer);
        writer.startPosition = committedPos.rawValue();
        writer.currentPosition = currentPos.rawValue();
        writer.maxPosition = maxPos.rawValue();
        if (!valid) {
            JfrEventWriterAccess.markAsInvalid(writer);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void markAsInvalid(Target_jdk_jfr_internal_event_EventWriter writer) {
        U.putBooleanVolatile(writer, U.objectFieldOffset(VALID_FIELD), false);
    }
}

