/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.jdk.VarHandleSupport;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;

class VarHandleStaticBaseComputer
implements FieldValueTransformerWithAvailability {
    VarHandleStaticBaseComputer() {
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        ResolvedJavaField field = VarHandleSupport.singleton().findVarHandleField(receiver);
        return field.getType().getJavaKind().isPrimitive() ? StaticFieldsSupport.getStaticPrimitiveFields() : StaticFieldsSupport.getStaticObjectFields();
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        Object varHandle = providers.getSnippetReflection().asObject(Object.class, receiver);
        if (varHandle != null) {
            ResolvedJavaField field = VarHandleSupport.singleton().findVarHandleField(varHandle);
            return StaticFieldsSupport.createStaticFieldBaseNode(field.getType().getJavaKind().isPrimitive());
        }
        return null;
    }
}

