/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public class CEntryPointLeaveNode
extends DeoptimizingFixedWithNextNode
implements Simplifiable,
Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CEntryPointLeaveNode> TYPE = NodeClass.create(CEntryPointLeaveNode.class);
    protected final LeaveAction leaveAction;
    @Node.OptionalInput
    protected ValueNode exception;
    private boolean returnValueAnchored;

    public CEntryPointLeaveNode(LeaveAction leaveAction) {
        this(leaveAction, null);
    }

    public CEntryPointLeaveNode(LeaveAction leaveAction, ValueNode exception) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        assert (leaveAction == LeaveAction.ExceptionAbort == (exception != null));
        this.leaveAction = leaveAction;
        this.exception = exception;
    }

    public LeaveAction getLeaveAction() {
        return this.leaveAction;
    }

    public ValueNode getException() {
        return this.exception;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }

    public void simplify(SimplifierTool tool) {
        if (tool.allUsagesAvailable() && !this.returnValueAnchored) {
            this.returnValueAnchored = true;
            this.anchorReturnValue();
        }
    }

    private void anchorReturnValue() {
        if (this.graph().method().getSignature().getReturnKind() == JavaKind.Void) {
            return;
        }
        int nodesAnchored = this.anchorNodes((Node)this);
        if (this.leaveAction == LeaveAction.ExceptionAbort) {
            VMError.guarantee(nodesAnchored == 0, "Unexpected values were anchored in method %s as ExceptionAbort must not have any return value.", this.graph().method());
        } else {
            VMError.guarantee(nodesAnchored == 1, "An unexpected number of values was anchored in method %s", this.graph().method());
        }
    }

    private int anchorNodes(Node n) {
        int anchoredNodes = 0;
        Node cur = n;
        while (cur instanceof FixedWithNextNode) {
            cur = ((FixedWithNextNode)cur).next();
        }
        if (cur instanceof IfNode) {
            for (Node sux : cur.successors()) {
                anchoredNodes += this.anchorNodes(sux);
            }
        } else if (cur instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)cur;
            this.anchorValue((FixedNode)returnNode, returnNode.result());
            ++anchoredNodes;
        } else if (!(cur instanceof LoweredDeadEndNode)) {
            if (cur instanceof EndNode && CEntryPointLeaveNode.isAllowedMerge(((EndNode)cur).merge())) {
                MergeNode merge = (MergeNode)((EndNode)cur).merge();
                this.anchorValue((FixedNode)merge, (ValueNode)merge.phis().first());
                ++anchoredNodes;
            } else {
                throw VMError.shouldNotReachHere("Unexpected control flow structure after CEntryPointLeaveNode. Disallowed node " + String.valueOf(cur) + " in method " + ((StructuredGraph)cur.graph()).method().format("%H.%n(%p)"));
            }
        }
        return anchoredNodes;
    }

    private static boolean isAllowedMerge(AbstractMergeNode merge) {
        return merge instanceof MergeNode && merge.phis().count() == 1 && merge.next() instanceof ReturnNode;
    }

    private void anchorValue(FixedNode parent, ValueNode value) {
        assert (value != null) : "methods with return type void are already excluded";
        if (value != this) {
            FixedValueAnchorNode anchoredValue = (FixedValueAnchorNode)this.graph().add((Node)new FixedValueAnchorNode(value));
            this.graph().addBeforeFixed((FixedNode)this, (FixedWithNextNode)anchoredValue);
            parent.replaceAllInputs((Node)value, (Node)anchoredValue);
        }
    }

    public static enum LeaveAction {
        Leave,
        DetachThread,
        TearDownIsolate,
        ExceptionAbort;

    }
}

