/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public final class HeapAccounting {
    private final UninterruptibleUtils.AtomicUnsigned edenUsedBytes = new UninterruptibleUtils.AtomicUnsigned();
    private final UninterruptibleUtils.AtomicUnsigned youngUsedBytes = new UninterruptibleUtils.AtomicUnsigned();
    private final HeapSizes beforeGc = new HeapSizes();
    private boolean invalidData;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapAccounting() {
    }

    public void notifyBeforeCollection() {
        assert (VMOperation.isGCInProgress());
        assert (!this.invalidData);
        this.beforeGc.eden = this.getEdenUsedBytes();
        this.beforeGc.survivor = this.getSurvivorUsedBytes();
        this.beforeGc.old = this.getOldUsedBytes();
        this.beforeGc.free = this.getBytesInUnusedChunks();
        assert (((UnsignedWord)this.edenUsedBytes.get()).equal(HeapImpl.getHeapImpl().getYoungGeneration().getEden().getChunkBytes()));
        assert (((UnsignedWord)this.youngUsedBytes.get()).equal(HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes()));
        this.invalidData = true;
    }

    public void notifyAfterCollection() {
        assert (VMOperation.isGCInProgress()) : "would cause races otherwise";
        assert (this.invalidData);
        this.youngUsedBytes.set(HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes());
        this.edenUsedBytes.set(HeapImpl.getHeapImpl().getYoungGeneration().getEden().getChunkBytes());
        assert (((UnsignedWord)this.edenUsedBytes.get()).equal(0));
        this.invalidData = false;
    }

    HeapSizes getHeapSizesBeforeGc() {
        return this.beforeGc;
    }

    @Uninterruptible(reason="Must be done during TLAB registration to not race with a potential collection.", callerMustBe=true)
    public void increaseEdenUsedBytes(UnsignedWord value) {
        this.youngUsedBytes.addAndGet(value);
        this.edenUsedBytes.addAndGet(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getEdenUsedBytes() {
        assert (!this.invalidData) : "value is incorrect during a GC";
        return (UnsignedWord)this.edenUsedBytes.get();
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getSurvivorUsedBytes() {
        return HeapImpl.getHeapImpl().getYoungGeneration().getSurvivorChunkBytes();
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getSurvivorUsedBytes(int survivorIndex) {
        return HeapImpl.getHeapImpl().getYoungGeneration().getSurvivorChunkBytes(survivorIndex);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getYoungUsedBytes() {
        assert (!this.invalidData) : "value is incorrect during a GC";
        return (UnsignedWord)this.youngUsedBytes.get();
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getOldUsedBytes() {
        return HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getUsedBytes() {
        return this.getOldUsedBytes().add(this.getYoungUsedBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getBytesInUnusedChunks() {
        return HeapImpl.getChunkProvider().getBytesInUnusedChunks();
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getCommittedBytes() {
        return this.getUsedBytes().add(this.getBytesInUnusedChunks());
    }

    static class HeapSizes {
        UnsignedWord eden;
        UnsignedWord survivor;
        UnsignedWord old;
        UnsignedWord free;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        HeapSizes() {
        }

        public UnsignedWord totalUsed() {
            return this.eden.add(this.survivor).add(this.old);
        }
    }
}

