/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.TreeMap;
import jdk.graal.compiler.debug.Assertions;

public class ChunkedImageHeapPartition
implements ImageHeapPartition {
    private final String name;
    private final boolean writable;
    private final boolean hugeObjects;
    private final int startAlignment;
    private final int endAlignment;
    private final int minimumObjectSize;
    private final List<ImageHeapObject> objects = new ArrayList<ImageHeapObject>();
    Object firstObject;
    Object lastObject;
    long startOffset = -1L;
    long endOffset = -1L;

    ChunkedImageHeapPartition(String name, boolean writable, boolean hugeObjects, int startAlignment, int endAlignment) {
        this.name = name;
        this.writable = writable;
        this.hugeObjects = hugeObjects;
        this.startAlignment = startAlignment;
        this.endAlignment = endAlignment;
        this.minimumObjectSize = ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize();
    }

    void assign(ImageHeapObject obj) {
        assert (obj.getPartition() == this) : obj;
        this.objects.add(obj);
    }

    void layout(ChunkedImageHeapAllocator allocator) {
        if (this.hugeObjects) {
            this.layoutInUnalignedChunks(allocator);
        } else {
            this.layoutInAlignedChunks(allocator);
        }
    }

    private void layoutInUnalignedChunks(ChunkedImageHeapAllocator allocator) {
        allocator.finishAlignedChunk();
        allocator.alignBetweenChunks(this.getStartAlignment());
        this.startOffset = allocator.getPosition();
        for (ImageHeapObject info : this.objects) {
            this.appendAllocatedObject(info, allocator.allocateUnalignedChunkForObject(info, this.isWritable()));
        }
        allocator.alignBetweenChunks(this.getEndAlignment());
        this.endOffset = allocator.getPosition();
    }

    private void layoutInAlignedChunks(ChunkedImageHeapAllocator allocator) {
        allocator.maybeStartAlignedChunk();
        allocator.alignInAlignedChunk(this.getStartAlignment());
        this.startOffset = allocator.getPosition();
        this.allocateObjectsInAlignedChunks(allocator);
        allocator.alignInAlignedChunk(this.getEndAlignment());
        this.endOffset = allocator.getPosition();
    }

    private void allocateObjectsInAlignedChunks(ChunkedImageHeapAllocator allocator) {
        NavigableMap<Long, Queue<ImageHeapObject>> sortedObjects = this.createSortedObjectsMap();
        while (!sortedObjects.isEmpty()) {
            ImageHeapObject info = this.dequeueBestFit(sortedObjects, allocator.getRemainingBytesInAlignedChunk());
            if (info == null) {
                allocator.startNewAlignedChunk();
                continue;
            }
            this.appendAllocatedObject(info, allocator.allocateObjectInAlignedChunk(info, this.isWritable()));
        }
    }

    private ImageHeapObject dequeueBestFit(NavigableMap<Long, Queue<ImageHeapObject>> sortedObjects, long nbytes) {
        if (nbytes < (long)this.minimumObjectSize) {
            return null;
        }
        Map.Entry<Long, Queue<ImageHeapObject>> entry = sortedObjects.floorEntry(nbytes);
        if (entry == null) {
            return null;
        }
        Queue<ImageHeapObject> queue = entry.getValue();
        ImageHeapObject info = queue.remove();
        if (queue.isEmpty()) {
            sortedObjects.remove(entry.getKey());
        }
        return info;
    }

    private NavigableMap<Long, Queue<ImageHeapObject>> createSortedObjectsMap() {
        ImageHeapObject[] sorted = this.objects.toArray(new ImageHeapObject[0]);
        Arrays.sort(sorted, new SizeComparator());
        TreeMap<Long, Queue<ImageHeapObject>> map = new TreeMap<Long, Queue<ImageHeapObject>>();
        ArrayDeque<ImageHeapObject> currentQueue = null;
        long currentObjectsSize = -1L;
        for (ImageHeapObject obj : sorted) {
            long objSize = obj.getSize();
            if (objSize != currentObjectsSize) {
                assert (objSize > currentObjectsSize && objSize >= (long)ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize()) : Assertions.errorMessage((Object[])new Object[]{obj, objSize});
                currentObjectsSize = objSize;
                currentQueue = new ArrayDeque<ImageHeapObject>();
                map.put(currentObjectsSize, currentQueue);
            }
            assert (currentQueue != null);
            currentQueue.add(obj);
        }
        return map;
    }

    private void appendAllocatedObject(ImageHeapObject info, long allocationOffset) {
        if (this.firstObject == null) {
            this.firstObject = ChunkedImageHeapPartition.extractObject(info);
        }
        assert (info.getPartition() == this);
        long offsetInPartition = allocationOffset - this.startOffset;
        assert (ConfigurationValues.getObjectLayout().isAligned(offsetInPartition)) : "start: " + offsetInPartition + " must be aligned.";
        info.setOffsetInPartition(offsetInPartition);
        this.lastObject = ChunkedImageHeapPartition.extractObject(info);
    }

    private static Object extractObject(ImageHeapObject info) {
        if (info.getConstant() instanceof SubstrateObjectConstant) {
            return info.getObject();
        }
        return info.getConstant();
    }

    @Override
    public String getName() {
        return this.name;
    }

    boolean isWritable() {
        return this.writable;
    }

    boolean usesUnalignedObjects() {
        return this.hugeObjects;
    }

    final int getStartAlignment() {
        return this.startAlignment;
    }

    final int getEndAlignment() {
        return this.endAlignment;
    }

    @Override
    public long getStartOffset() {
        assert (this.startOffset >= 0L) : "Start offset not yet set";
        return this.startOffset;
    }

    long getEndOffset() {
        assert (this.endOffset >= 0L) : "End offset not yet set";
        return this.endOffset;
    }

    @Override
    public long getSize() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public String toString() {
        return this.name;
    }

    private static class SizeComparator
    implements Comparator<ImageHeapObject> {
        private SizeComparator() {
        }

        @Override
        public int compare(ImageHeapObject o1, ImageHeapObject o2) {
            return Long.signum(o1.getSize() - o2.getSize());
        }
    }
}

