/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.util.ImageHeapList;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class DCmdSupport {
    private final List<DCmd> commands = ImageHeapList.create(DCmd.class);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DCmdSupport() {
    }

    @Fold
    public static DCmdSupport singleton() {
        return (DCmdSupport)ImageSingletons.lookup(DCmdSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerCommand(DCmd cmd) {
        this.commands.add(cmd);
    }

    public DCmd getCommand(String name) {
        for (DCmd cmd : this.commands) {
            if (!cmd.getName().equals(name)) continue;
            return cmd;
        }
        return null;
    }

    public List<DCmd> getCommands() {
        return this.commands;
    }
}

