/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class AbstractDCmd
implements DCmd {
    private final String name;
    private final String description;
    private final DCmd.Impact impact;
    private final DCmdOption<?>[] arguments;
    private final DCmdOption<?>[] options;
    private final String[] examples;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractDCmd(String name, String description, DCmd.Impact impact) {
        this(name, description, impact, new DCmdOption[0], new DCmdOption[0], new String[0]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractDCmd(String name, String description, DCmd.Impact impact, DCmdOption<?>[] arguments, DCmdOption<?>[] options) {
        this(name, description, impact, arguments, options, new String[0]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractDCmd(String name, String description, DCmd.Impact impact, DCmdOption<?>[] arguments, DCmdOption<?>[] options, String[] examples) {
        this.name = name;
        this.description = description;
        this.impact = impact;
        this.arguments = arguments;
        this.options = options;
        this.examples = examples;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String parseAndExecute(String input) throws Throwable {
        DCmdArguments args = this.parse(input);
        return this.execute(args);
    }

    protected abstract String execute(DCmdArguments var1) throws Throwable;

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.cpp#L189-L220"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.cpp#L234-L253")})
    private DCmdArguments parse(String input) {
        DCmdArguments result = new DCmdArguments();
        DCmdArgCursor cursor = new DCmdArgCursor(input, ' ');
        boolean isCommandNamePresent = cursor.advance();
        assert (isCommandNamePresent);
        assert (this.name.equals(cursor.getKey()));
        assert (cursor.getValue() == null);
        while (cursor.advance()) {
            this.parseOption(cursor.getKey(), cursor.getValue(), result);
        }
        for (DCmdOption<?> arg : this.arguments) {
            if (!arg.required() || result.hasBeenSet(arg)) continue;
            throw new IllegalArgumentException("The argument '" + arg.name() + "' is mandatory.");
        }
        for (DCmdOption<?> option : this.options) {
            if (!option.required() || result.hasBeenSet(option)) continue;
            throw new IllegalArgumentException("The option '" + option.name() + "' is mandatory.");
        }
        return result;
    }

    private void parseOption(String left, String right, DCmdArguments result) {
        DCmdOption<?> matchingOption = this.findOption(left);
        if (matchingOption != null) {
            Object value = AbstractDCmd.parseValue(matchingOption, right);
            result.set(matchingOption, value);
            return;
        }
        for (DCmdOption<?> option : this.arguments) {
            if (result.hasBeenSet(option)) continue;
            Object value = AbstractDCmd.parseValue(option, left);
            result.set(option, value);
            return;
        }
        throw new IllegalArgumentException("Unknown argument '" + left + "' in diagnostic command");
    }

    private DCmdOption<?> findOption(String optionName) {
        for (DCmdOption<?> option : this.options) {
            if (!option.name().equals(optionName)) continue;
            return option;
        }
        return null;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+26/src/hotspot/share/services/diagnosticArgument.cpp#L141-L171")
    private static Object parseValue(DCmdOption<?> option, String valueString) {
        Class<?> type = option.type();
        if (type == Boolean.class) {
            if (valueString == null || valueString.isEmpty() || "true".equals(valueString)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueString)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Boolean parsing error in command argument '" + option.name() + "'. Could not parse: " + valueString + ".");
        }
        if (type == String.class) {
            return valueString;
        }
        throw VMError.shouldNotReachHere("Unexpected option type: " + String.valueOf(type));
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.cpp#L255-L299")
    public String getHelp() {
        String lineBreak = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(lineBreak);
        if (this.description != null) {
            sb.append(this.description).append(lineBreak);
        }
        sb.append(lineBreak);
        sb.append("Impact: ").append(this.impact.name()).append(lineBreak);
        sb.append(lineBreak);
        String value = this.getSyntaxAndExamples();
        sb.append(value);
        return sb.toString();
    }

    protected String getSyntaxAndExamples() {
        String lineBreak = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("Syntax : ").append(this.getName());
        if (this.options.length > 0) {
            sb.append(" [options]");
        }
        for (DCmdOption<?> dCmdOption : this.arguments) {
            sb.append(" ");
            if (!dCmdOption.required()) {
                sb.append("[");
            }
            sb.append("<").append(dCmdOption.name()).append(">");
            if (dCmdOption.required()) continue;
            sb.append("]");
        }
        if (this.arguments.length > 0) {
            sb.append(lineBreak).append(lineBreak);
            sb.append("Arguments:");
            for (DCmdOption<?> dCmdOption : this.arguments) {
                sb.append(lineBreak);
                AbstractDCmd.appendOption(sb, dCmdOption);
            }
        }
        if (this.options.length > 0) {
            sb.append(lineBreak).append(lineBreak);
            sb.append("Options: (options must be specified using the <key> or <key>=<value> syntax)");
            for (DCmdOption<?> dCmdOption : this.options) {
                sb.append(lineBreak);
                AbstractDCmd.appendOption(sb, dCmdOption);
            }
        }
        if (this.examples.length > 0) {
            sb.append(lineBreak).append(lineBreak);
            sb.append("Example usage:");
            for (String string : this.examples) {
                sb.append(lineBreak);
                sb.append("\t").append(string);
            }
        }
        return sb.toString();
    }

    private static void appendOption(StringBuilder sb, DCmdOption<?> option) {
        sb.append("\t").append(option.name()).append(" : ");
        if (!option.required()) {
            sb.append("[optional] ");
        }
        sb.append(option.description());
        sb.append(" (").append(AbstractDCmd.typeToString(option)).append(", ");
        if (option.defaultValue() != null) {
            sb.append(option.defaultValue());
        } else {
            sb.append("no default value");
        }
        sb.append(")");
    }

    private static String typeToString(DCmdOption<?> option) {
        Class<?> type = option.type();
        if (type == Boolean.class) {
            return "BOOLEAN";
        }
        if (type == String.class) {
            return "STRING";
        }
        throw VMError.shouldNotReachHere("Unexpected option type: " + String.valueOf(type));
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.hpp#L102-L121")
    private static class DCmdArgCursor {
        private final String input;
        private final int length;
        private final char delimiter;
        private int cursor;
        private int keyPos;
        private int keyLength;
        private int valuePos;
        private int valueLength;

        DCmdArgCursor(String input, char delimiter) {
            this.input = input;
            this.length = input.length();
            this.delimiter = delimiter;
        }

        String getKey() {
            if (this.keyLength == 0) {
                return null;
            }
            return this.input.substring(this.keyPos, this.keyPos + this.keyLength);
        }

        String getValue() {
            if (this.valueLength == 0) {
                return null;
            }
            return this.input.substring(this.valuePos, this.valuePos + this.valueLength);
        }

        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.cpp#L67-L145")
        private boolean advance() {
            while (this.cursor < this.length - 1 && this.input.charAt(this.cursor) == this.delimiter) {
                ++this.cursor;
            }
            if (this.cursor == this.length - 1 && this.input.charAt(this.cursor) == this.delimiter) {
                this.keyPos = this.cursor;
                this.keyLength = 0;
                this.valuePos = this.cursor;
                this.valueLength = 0;
                return false;
            }
            this.keyPos = this.cursor;
            boolean argHadQuotes = false;
            while (this.cursor <= this.length - 1 && this.input.charAt(this.cursor) != '=' && this.input.charAt(this.cursor) != this.delimiter) {
                if (this.input.charAt(this.cursor) == '\"' || this.input.charAt(this.cursor) == '\'') {
                    ++this.keyPos;
                    char quote = this.input.charAt(this.cursor);
                    argHadQuotes = true;
                    while (this.cursor < this.length - 1) {
                        ++this.cursor;
                        if (this.input.charAt(this.cursor) != quote || this.input.charAt(this.cursor - 1) == '\\') continue;
                    }
                    if (this.input.charAt(this.cursor) == quote) break;
                    throw new IllegalArgumentException("Format error in diagnostic command arguments");
                }
                ++this.cursor;
            }
            this.keyLength = this.cursor - this.keyPos;
            if (argHadQuotes) {
                ++this.cursor;
            }
            if (this.cursor <= this.length - 1 && this.input.charAt(this.cursor) == '=') {
                ++this.cursor;
                this.valuePos = this.cursor;
                boolean valueHadQuotes = false;
                while (this.cursor <= this.length - 1 && this.input.charAt(this.cursor) != this.delimiter) {
                    if (this.input.charAt(this.cursor) == '\"' || this.input.charAt(this.cursor) == '\'') {
                        ++this.valuePos;
                        char quote = this.input.charAt(this.cursor);
                        valueHadQuotes = true;
                        while (this.cursor < this.length - 1) {
                            ++this.cursor;
                            if (this.input.charAt(this.cursor) != quote || this.input.charAt(this.cursor - 1) == '\\') continue;
                        }
                        if (this.input.charAt(this.cursor) == quote) break;
                        throw new IllegalArgumentException("Format error in diagnostic command arguments");
                    }
                    ++this.cursor;
                }
                this.valueLength = this.cursor - this.valuePos;
                if (valueHadQuotes) {
                    ++this.cursor;
                }
            } else {
                this.valuePos = 0;
                this.valueLength = 0;
            }
            return this.keyLength != 0;
        }
    }
}

