/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.LegacySerializationConfigurationParser;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.SerializationMetadataParser;
import java.util.List;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public abstract class SerializationConfigurationParser<C>
extends ConfigurationParser {
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    protected final ConfigurationConditionResolver<C> conditionResolver;
    protected final RuntimeSerializationSupport<C> serializationSupport;

    public static <C> SerializationConfigurationParser<C> create(boolean strictMetadata, ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, boolean strictConfiguration) {
        if (strictMetadata) {
            return new SerializationMetadataParser<C>(conditionResolver, serializationSupport, strictConfiguration);
        }
        return new LegacySerializationConfigurationParser<C>(conditionResolver, serializationSupport, strictConfiguration);
    }

    public SerializationConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
        this.conditionResolver = conditionResolver;
    }

    protected void parseSerializationTypes(List<Object> listOfSerializationTypes, boolean lambdaCapturingTypes) {
        for (Object serializationType : listOfSerializationTypes) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationType, "Third-level of document must be serialization descriptor objects"), lambdaCapturingTypes);
        }
    }

    protected abstract void parseSerializationDescriptorObject(EconomicMap<String, Object> var1, boolean var2);

    protected void registerType(ConfigurationTypeDescriptor targetSerializationClass, C condition, Object optionalCustomCtorValue) {
        String customTargetConstructorClass;
        String string = customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
        if (targetSerializationClass instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedClass = (NamedConfigurationTypeDescriptor)targetSerializationClass;
            this.serializationSupport.registerWithTargetConstructorClass(condition, namedClass.name(), customTargetConstructorClass);
        } else if (targetSerializationClass instanceof ProxyConfigurationTypeDescriptor) {
            ProxyConfigurationTypeDescriptor proxyClass = (ProxyConfigurationTypeDescriptor)targetSerializationClass;
            this.serializationSupport.registerProxyClass(condition, proxyClass.interfaceNames());
        } else {
            throw new JsonParserException("Unknown configuration type descriptor: %s".formatted(targetSerializationClass.toString()));
        }
    }
}

