/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.collections;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.collections.UninterruptibleEntry;
import com.oracle.svm.core.collections.UninterruptibleHashtable;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractUninterruptibleHashtable
implements UninterruptibleHashtable {
    private static final int DEFAULT_TABLE_LENGTH = 2053;
    private final NmtCategory nmtCategory;
    private final UninterruptibleEntry[] table;
    private int size;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractUninterruptibleHashtable(NmtCategory nmtCategory) {
        this(nmtCategory, 2053);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractUninterruptibleHashtable(NmtCategory nmtCategory, int primeLength) {
        this.nmtCategory = nmtCategory;
        this.table = this.createTable(primeLength);
        this.size = 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract UninterruptibleEntry[] createTable(int var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract boolean isEqual(UninterruptibleEntry var1, UninterruptibleEntry var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract UninterruptibleEntry copyToHeap(UninterruptibleEntry var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UninterruptibleEntry copyToHeap(UninterruptibleEntry pointerOnStack, UnsignedWord sizeToAlloc) {
        UninterruptibleEntry pointerOnHeap = (UninterruptibleEntry)NullableNativeMemory.malloc(sizeToAlloc, this.nmtCategory);
        if (pointerOnHeap.isNonNull()) {
            UnmanagedMemoryUtil.copy((Pointer)pointerOnStack, (Pointer)pointerOnHeap, sizeToAlloc);
            return pointerOnHeap;
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void free(UninterruptibleEntry entry) {
        --this.size;
        NullableNativeMemory.free(entry);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UninterruptibleEntry insertEntry(UninterruptibleEntry valueOnStack) {
        int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
        UninterruptibleEntry newEntry = this.copyToHeap(valueOnStack);
        if (newEntry.isNonNull()) {
            UninterruptibleEntry existingEntry = this.table[index];
            newEntry.setNext(existingEntry);
            this.table[index] = newEntry;
            ++this.size;
            return newEntry;
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean remove(UninterruptibleEntry valueOnStack) {
        int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
        UninterruptibleEntry entry = this.table[index];
        UninterruptibleEntry prev = (UninterruptibleEntry)WordFactory.nullPointer();
        while (entry.isNonNull()) {
            if (this.isEqual(valueOnStack, entry)) {
                if (prev.isNull()) {
                    this.table[index] = entry.getNext();
                } else {
                    prev.setNext((UninterruptibleEntry)entry.getNext());
                }
                this.free(entry);
                return true;
            }
            prev = entry;
            entry = entry.getNext();
        }
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSize() {
        return this.size;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry[] getTable() {
        return this.table;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry get(UninterruptibleEntry valueOnStack) {
        int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
        UninterruptibleEntry entry = this.table[index];
        while (entry.isNonNull()) {
            if (this.isEqual(valueOnStack, entry)) {
                return entry;
            }
            entry = entry.getNext();
        }
        return (UninterruptibleEntry)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry getOrPut(UninterruptibleEntry valueOnStack) {
        assert (valueOnStack.isNonNull());
        UninterruptibleEntry entry = this.get(valueOnStack);
        if (entry.isNonNull()) {
            return entry;
        }
        return this.insertEntry(valueOnStack);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean putIfAbsent(UninterruptibleEntry valueOnStack) {
        assert (valueOnStack.isNonNull());
        UninterruptibleEntry existingEntry = this.get(valueOnStack);
        if (existingEntry.isNonNull()) {
            return false;
        }
        UninterruptibleEntry newEntry = this.insertEntry(valueOnStack);
        return newEntry.isNonNull();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleEntry putNew(UninterruptibleEntry valueOnStack) {
        assert (valueOnStack.isNonNull());
        assert (this.get(valueOnStack).isNull());
        return this.insertEntry(valueOnStack);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            UninterruptibleEntry entry = this.table[i];
            while (entry.isNonNull()) {
                UninterruptibleEntry tmp = entry;
                entry = entry.getNext();
                this.free(tmp);
            }
            this.table[i] = (UninterruptibleEntry)WordFactory.nullPointer();
        }
        assert (this.size == 0) : "The table is not empty!";
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void teardown() {
        this.clear();
    }
}

