/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.attach;

import com.oracle.svm.core.attach.AttachApiSupport;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdSupport;
import com.oracle.svm.core.jni.headers.JNIErrors;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.cpp#L453-L467")
public abstract class AttachListenerThread
extends Thread {
    private static final String JCMD_COMMAND_STRING = "jcmd";
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.hpp#L142")
    protected static final int NAME_LENGTH_MAX = 16;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.hpp#L143")
    protected static final int ARG_LENGTH_MAX = 1024;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.hpp#L144")
    protected static final int ARG_COUNT_MAX = 3;

    public AttachListenerThread() {
        super(PlatformThreads.singleton().systemGroup, "Attach Listener");
        this.setDaemon(true);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.cpp#L377-L436")
    public void run() {
        try {
            while (true) {
                AttachOperation op;
                if ((op = this.dequeue()) == null) {
                    AttachApiSupport.singleton().shutdown(false);
                    return;
                }
                if (JCMD_COMMAND_STRING.equals(op.name)) {
                    AttachListenerThread.handleJcmd(op);
                    continue;
                }
                op.complete(JNIErrors.JNI_ERR(), "Invalid Operation. Only jcmd is supported currently.");
            }
        }
        catch (Throwable e) {
            VMError.shouldNotReachHere("Exception in attach listener thread", e);
            return;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.cpp#L205-L217")
    private static void handleJcmd(AttachOperation op) {
        try {
            String response = AttachListenerThread.parseAndExecute(op.arg0);
            op.complete(JNIErrors.JNI_OK(), response);
        }
        catch (Throwable e) {
            AttachListenerThread.handleException(op, e);
        }
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticFramework.cpp#L383-L420"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+24/src/hotspot/share/services/diagnosticFramework.cpp#L422-L439")})
    private static String parseAndExecute(String input) throws Throwable {
        String[] args = StringUtil.split((String)input, (String)" ");
        String cmdName = args[0];
        for (int i = 1; i < args.length; ++i) {
            String v = args[i];
            if (!"-h".equals(v) && !"--help".equals(v) && !"-help".equals(v)) continue;
            DCmd cmd = DCmdSupport.singleton().getCommand("help");
            return cmd.parseAndExecute("help " + cmdName);
        }
        DCmd cmd = DCmdSupport.singleton().getCommand(cmdName);
        if (cmd == null) {
            throw new IllegalArgumentException("Unknown diagnostic command '" + cmdName + "'");
        }
        return cmd.parseAndExecute(input);
    }

    private static void handleException(AttachOperation op, Throwable e) {
        if (!Options.JCmdExceptionStackTrace.getValue().booleanValue()) {
            op.complete(JNIErrors.JNI_ERR(), e.toString());
            return;
        }
        StringWriter s = new StringWriter();
        e.printStackTrace(new PrintWriter(s));
        op.complete(JNIErrors.JNI_OK(), s.toString());
    }

    protected abstract AttachOperation dequeue();

    public static abstract class AttachOperation {
        private final String name;
        private final String arg0;
        private final String arg1;
        private final String arg2;

        public AttachOperation(String name, String arg0, String arg1, String arg2) {
            this.name = name;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public abstract void complete(int var1, String var2);
    }

    static class Options {
        public static final RuntimeOptionKey<Boolean> JCmdExceptionStackTrace = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);

        Options() {
        }
    }
}

