/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.ModuleNative;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ModuleSupport;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.instrument.UnmodifiableModuleException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class PreMainSupport {
    private static final String PREMAIN_OPTION_PREFIX = "-XXpremain:";
    private final Map<String, String> premainOptions = new HashMap<String, String>();
    private final List<PremainMethod> premainMethods = new ArrayList<PremainMethod>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerPremainMethod(String className, Method executable, Object ... args) {
        this.premainMethods.add(new PremainMethod(className, executable, args));
    }

    public String[] retrievePremainArgs(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> mainArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith(PREMAIN_OPTION_PREFIX)) {
                String premainOptionKeyValue = arg.substring(PREMAIN_OPTION_PREFIX.length());
                String[] pair = SubstrateUtil.split(premainOptionKeyValue, ":");
                if (pair.length != 2) continue;
                this.premainOptions.put(pair[0], pair[1]);
                continue;
            }
            mainArgs.add(arg);
        }
        return mainArgs.toArray(new String[0]);
    }

    public void invokePremain() {
        for (PremainMethod premainMethod : this.premainMethods) {
            Object[] args = premainMethod.args;
            if (this.premainOptions.containsKey(premainMethod.className)) {
                args[0] = this.premainOptions.get(premainMethod.className);
            }
            try {
                premainMethod.method.invoke(null, args);
            }
            catch (Throwable t) {
                Throwable cause = t;
                if (t instanceof InvocationTargetException) {
                    cause = t.getCause();
                }
                throw VMError.shouldNotReachHere("Failed to execute " + premainMethod.className + ".premain", cause);
            }
        }
    }

    record PremainMethod(String className, Method method, Object[] args) {
    }

    public static class NativeImageNoOpRuntimeInstrumentation
    implements Instrumentation {
        @Override
        public void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        }

        @Override
        public void addTransformer(ClassFileTransformer transformer) {
        }

        @Override
        public boolean removeTransformer(ClassFileTransformer transformer) {
            return false;
        }

        @Override
        public boolean isRetransformClassesSupported() {
            return false;
        }

        @Override
        public void retransformClasses(Class<?> ... classes) throws UnmodifiableClassException {
            throw new UnsupportedOperationException("Native image doesn't support retransform class at runtime.");
        }

        @Override
        public boolean isRedefineClassesSupported() {
            return false;
        }

        @Override
        public void redefineClasses(ClassDefinition ... definitions) throws ClassNotFoundException, UnmodifiableClassException {
            throw new UnsupportedOperationException("Native image doesn't support redefine class at runtime.");
        }

        @Override
        public boolean isModifiableClass(Class<?> theClass) {
            return false;
        }

        public Class<?>[] getAllLoadedClasses() {
            ArrayList userClasses = new ArrayList();
            Heap.getHeap().visitLoadedClasses(clazz -> {
                Module module = clazz.getModule();
                if (module == null || module.getName() == null || !NativeImageNoOpRuntimeInstrumentation.isSystemClass(module)) {
                    userClasses.add(clazz);
                }
            });
            return userClasses.toArray(new Class[0]);
        }

        private static boolean isSystemClass(Module module) {
            return ModuleSupport.SYSTEM_MODULES.contains(module.getName());
        }

        public Class<?>[] getInitiatedClasses(ClassLoader loader) {
            throw new UnsupportedOperationException("Native image has flat classloader hierarchy. Can't get classes by classloader. Try to call getAllLoadedClasses() to get all loaded classes.");
        }

        @Override
        public long getObjectSize(Object objectToSize) {
            return -1L;
        }

        @Override
        public void appendToBootstrapClassLoaderSearch(JarFile jarfile) {
            throw new UnsupportedOperationException("Native image doesn't support modification of the bootstrap classloader search path at run time. Please avoid calling this method in Native Image by checking \"runtime\".equals(System.getProperty(\"org.graalvm.nativeimage.imagecode\"))");
        }

        @Override
        public void appendToSystemClassLoaderSearch(JarFile jarfile) {
            throw new UnsupportedOperationException("Native image doesn't support modification of the system classloader search path at run time. Please avoid calling this method in Native Image by checking \"runtime\".equals(System.getProperty(\"org.graalvm.nativeimage.imagecode\"))");
        }

        @Override
        public boolean isNativeMethodPrefixSupported() {
            return false;
        }

        @Override
        public void setNativeMethodPrefix(ClassFileTransformer transformer, String prefix) {
        }

        @Override
        public void redefineModule(Module module, Set<Module> extraReads, Map<String, Set<Module>> extraExports, Map<String, Set<Module>> extraOpens, Set<Class<?>> extraUses, Map<Class<?>, List<Class<?>>> extraProvides) {
            if (!module.isNamed()) {
                return;
            }
            if (!this.isModifiableModule(module)) {
                throw new UnmodifiableModuleException(module.getName());
            }
            for (Module module2 : extraReads) {
                ModuleNative.addReads(module, module2);
            }
            for (Map.Entry entry : extraExports.entrySet()) {
                for (Module m : (Set)entry.getValue()) {
                    ModuleNative.addExports(module, (String)entry.getKey(), m);
                }
            }
        }

        @Override
        public boolean isModifiableModule(Module module) {
            if (module == null) {
                throw new NullPointerException("'module' is null");
            }
            return true;
        }
    }
}

